/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.schedulers.RxThreadFactory;
import io.reactivex.rxjava3.internal.schedulers.ScheduledDirectPeriodicTask;
import io.reactivex.rxjava3.internal.schedulers.ScheduledDirectTask;
import io.reactivex.rxjava3.internal.schedulers.ScheduledRunnable;
import io.reactivex.rxjava3.internal.schedulers.d;
import io.reactivex.rxjava3.internal.schedulers.j;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class k
extends ah {
    final ThreadFactory ayD;
    final AtomicReference<ScheduledExecutorService> ayE = new AtomicReference();
    private static final String ayF = "rx3.single-priority";
    private static final String ayG = "RxSingleScheduler";
    static final RxThreadFactory ayH;
    static final ScheduledExecutorService ayI;

    public k() {
        this(ayH);
    }

    public k(ThreadFactory threadFactory) {
        this.ayD = threadFactory;
        this.ayE.lazySet(k.b(threadFactory));
    }

    static ScheduledExecutorService b(ThreadFactory threadFactory) {
        return j.a(threadFactory);
    }

    @Override
    public void start() {
        ScheduledExecutorService current;
        ExecutorService next = null;
        do {
            if ((current = this.ayE.get()) != ayI) {
                if (next != null) {
                    next.shutdown();
                }
                return;
            }
            if (next != null) continue;
            next = k.b(this.ayD);
        } while (!this.ayE.compareAndSet(current, (ScheduledExecutorService)next));
    }

    @Override
    public void shutdown() {
        ScheduledExecutorService current = this.ayE.getAndSet(ayI);
        if (current != ayI) {
            current.shutdownNow();
        }
    }

    @Override
    @e
    public ah.c oS() {
        return new a(this.ayE.get());
    }

    @Override
    @e
    public b a(@e Runnable run, long delay, TimeUnit unit) {
        ScheduledDirectTask task = new ScheduledDirectTask(io.reactivex.rxjava3.d.a.h(run), true);
        try {
            Future<Void> f2 = delay <= 0L ? this.ayE.get().submit(task) : this.ayE.get().schedule(task, delay, unit);
            task.setFuture(f2);
            return task;
        }
        catch (RejectedExecutionException ex) {
            io.reactivex.rxjava3.d.a.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    @Override
    @e
    public b a(@e Runnable run, long initialDelay, long period, TimeUnit unit) {
        Runnable decoratedRun = io.reactivex.rxjava3.d.a.h(run);
        if (period <= 0L) {
            ScheduledExecutorService exec = this.ayE.get();
            d periodicWrapper = new d(decoratedRun, exec);
            try {
                Future<Void> f2 = initialDelay <= 0L ? exec.submit(periodicWrapper) : exec.schedule(periodicWrapper, initialDelay, unit);
                periodicWrapper.i(f2);
            }
            catch (RejectedExecutionException ex) {
                io.reactivex.rxjava3.d.a.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
            return periodicWrapper;
        }
        ScheduledDirectPeriodicTask task = new ScheduledDirectPeriodicTask(decoratedRun, true);
        try {
            ScheduledFuture<?> f3 = this.ayE.get().scheduleAtFixedRate(task, initialDelay, period, unit);
            task.setFuture(f3);
            return task;
        }
        catch (RejectedExecutionException ex) {
            io.reactivex.rxjava3.d.a.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    static {
        ayI = Executors.newScheduledThreadPool(0);
        ayI.shutdown();
        int priority = Math.max(1, Math.min(10, Integer.getInteger(ayF, 5)));
        ayH = new RxThreadFactory(ayG, priority, true);
    }

    static final class a
    extends ah.c {
        final ScheduledExecutorService ayJ;
        final io.reactivex.rxjava3.disposables.a ayK;
        volatile boolean disposed;

        a(ScheduledExecutorService executor) {
            this.ayJ = executor;
            this.ayK = new io.reactivex.rxjava3.disposables.a();
        }

        @Override
        @e
        public b b(@e Runnable run, long delay, @e TimeUnit unit) {
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            Runnable decoratedRun = io.reactivex.rxjava3.d.a.h(run);
            ScheduledRunnable sr = new ScheduledRunnable(decoratedRun, this.ayK);
            this.ayK.a((b)sr);
            try {
                Future<Object> f2 = delay <= 0L ? this.ayJ.submit(sr) : this.ayJ.schedule(sr, delay, unit);
                sr.setFuture(f2);
            }
            catch (RejectedExecutionException ex) {
                this.dispose();
                io.reactivex.rxjava3.d.a.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
            return sr;
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.ayK.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

