/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscribers;

import io.reactivex.rxjava3.b.a;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.observers.g;
import java.util.concurrent.atomic.AtomicReference;
import org.a.e;

public final class BoundedSubscriber<T>
extends AtomicReference<e>
implements o<T>,
b,
g,
e {
    private static final long serialVersionUID = -7251123623727029452L;
    final io.reactivex.rxjava3.b.g<? super T> onNext;
    final io.reactivex.rxjava3.b.g<? super Throwable> onError;
    final a onComplete;
    final io.reactivex.rxjava3.b.g<? super e> onSubscribe;
    final int bufferSize;
    int consumed;
    final int limit;

    public BoundedSubscriber(io.reactivex.rxjava3.b.g<? super T> onNext, io.reactivex.rxjava3.b.g<? super Throwable> onError, a onComplete, io.reactivex.rxjava3.b.g<? super e> onSubscribe, int bufferSize) {
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onSubscribe = onSubscribe;
        this.bufferSize = bufferSize;
        this.limit = bufferSize - (bufferSize >> 2);
    }

    @Override
    public void onSubscribe(e s2) {
        if (SubscriptionHelper.setOnce(this, s2)) {
            try {
                this.onSubscribe.accept(this);
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                s2.cancel();
                this.onError(e2);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.isDisposed()) {
            try {
                this.onNext.accept(t2);
                int c2 = this.consumed + 1;
                if (c2 == this.limit) {
                    this.consumed = 0;
                    ((e)this.get()).request(this.limit);
                } else {
                    this.consumed = c2;
                }
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                ((e)this.get()).cancel();
                this.onError(e2);
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.get() != SubscriptionHelper.CANCELLED) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            try {
                this.onError.accept(t2);
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                io.reactivex.rxjava3.d.a.onError(new CompositeException(t2, e2));
            }
        } else {
            io.reactivex.rxjava3.d.a.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.get() != SubscriptionHelper.CANCELLED) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            try {
                this.onComplete.run();
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                io.reactivex.rxjava3.d.a.onError(e2);
            }
        }
    }

    @Override
    public void dispose() {
        this.cancel();
    }

    @Override
    public boolean isDisposed() {
        return this.get() == SubscriptionHelper.CANCELLED;
    }

    @Override
    public void request(long n2) {
        ((e)this.get()).request(n2);
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this);
    }

    @Override
    public boolean hasCustomOnError() {
        return this.onError != Functions.KT;
    }
}

