/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscribers;

import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class SubscriberResourceWrapper<T>
extends AtomicReference<b>
implements o<T>,
b,
e {
    private static final long serialVersionUID = -8612022020200669122L;
    final d<? super T> downstream;
    final AtomicReference<e> upstream = new AtomicReference();

    public SubscriberResourceWrapper(d<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(e s2) {
        if (SubscriptionHelper.setOnce(this.upstream, s2)) {
            this.downstream.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        this.downstream.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        DisposableHelper.dispose(this);
        this.downstream.onError(t2);
    }

    @Override
    public void onComplete() {
        DisposableHelper.dispose(this);
        this.downstream.onComplete();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            this.upstream.get().request(n2);
        }
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this.upstream);
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.get() == SubscriptionHelper.CANCELLED;
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public void setResource(b resource) {
        DisposableHelper.set(this, resource);
    }
}

