/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscriptions;

import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.e;

public class SubscriptionArbiter
extends AtomicInteger
implements e {
    private static final long serialVersionUID = -2189523197179400958L;
    e actual;
    long requested;
    final AtomicReference<e> missedSubscription;
    final AtomicLong missedRequested;
    final AtomicLong missedProduced;
    final boolean cancelOnReplace;
    volatile boolean cancelled;
    protected boolean unbounded;

    public SubscriptionArbiter(boolean cancelOnReplace) {
        this.cancelOnReplace = cancelOnReplace;
        this.missedSubscription = new AtomicReference();
        this.missedRequested = new AtomicLong();
        this.missedProduced = new AtomicLong();
    }

    public final void setSubscription(e s2) {
        if (this.cancelled) {
            s2.cancel();
            return;
        }
        Objects.requireNonNull(s2, "s is null");
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            e a2 = this.actual;
            if (a2 != null && this.cancelOnReplace) {
                a2.cancel();
            }
            this.actual = s2;
            long r2 = this.requested;
            if (this.decrementAndGet() != 0) {
                this.drainLoop();
            }
            if (r2 != 0L) {
                s2.request(r2);
            }
            return;
        }
        e a3 = this.missedSubscription.getAndSet(s2);
        if (a3 != null && this.cancelOnReplace) {
            a3.cancel();
        }
        this.drain();
    }

    @Override
    public final void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            if (this.unbounded) {
                return;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r2 = this.requested;
                if (r2 != Long.MAX_VALUE) {
                    this.requested = r2 = b.g(r2, n2);
                    if (r2 == Long.MAX_VALUE) {
                        this.unbounded = true;
                    }
                }
                e a2 = this.actual;
                if (this.decrementAndGet() != 0) {
                    this.drainLoop();
                }
                if (a2 != null) {
                    a2.request(n2);
                }
                return;
            }
            b.a(this.missedRequested, n2);
            this.drain();
        }
    }

    public final void produced(long n2) {
        if (this.unbounded) {
            return;
        }
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            long r2 = this.requested;
            if (r2 != Long.MAX_VALUE) {
                long u2 = r2 - n2;
                if (u2 < 0L) {
                    SubscriptionHelper.reportMoreProduced(u2);
                    u2 = 0L;
                }
                this.requested = u2;
            }
            if (this.decrementAndGet() == 0) {
                return;
            }
            this.drainLoop();
            return;
        }
        b.a(this.missedProduced, n2);
        this.drain();
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.drain();
        }
    }

    final void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        this.drainLoop();
    }

    final void drainLoop() {
        int missed = 1;
        long requestAmount = 0L;
        e requestTarget = null;
        do {
            long mp;
            long mr;
            e ms;
            if ((ms = this.missedSubscription.get()) != null) {
                ms = this.missedSubscription.getAndSet(null);
            }
            if ((mr = this.missedRequested.get()) != 0L) {
                mr = this.missedRequested.getAndSet(0L);
            }
            if ((mp = this.missedProduced.get()) != 0L) {
                mp = this.missedProduced.getAndSet(0L);
            }
            e a2 = this.actual;
            if (this.cancelled) {
                if (a2 != null) {
                    a2.cancel();
                    this.actual = null;
                }
                if (ms == null) continue;
                ms.cancel();
                continue;
            }
            long r2 = this.requested;
            if (r2 != Long.MAX_VALUE) {
                long u2 = b.g(r2, mr);
                if (u2 != Long.MAX_VALUE) {
                    long v2 = u2 - mp;
                    if (v2 < 0L) {
                        SubscriptionHelper.reportMoreProduced(v2);
                        v2 = 0L;
                    }
                    r2 = v2;
                } else {
                    r2 = u2;
                }
                this.requested = r2;
            }
            if (ms != null) {
                if (a2 != null && this.cancelOnReplace) {
                    a2.cancel();
                }
                this.actual = ms;
                if (r2 == 0L) continue;
                requestAmount = b.g(requestAmount, r2);
                requestTarget = ms;
                continue;
            }
            if (a2 == null || mr == 0L) continue;
            requestAmount = b.g(requestAmount, mr);
            requestTarget = a2;
        } while ((missed = this.addAndGet(-missed)) != 0);
        if (requestAmount != 0L) {
            requestTarget.request(requestAmount);
        }
    }

    public final boolean isUnbounded() {
        return this.unbounded;
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }
}

