/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscriptions;

import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.exceptions.ProtocolViolationException;
import io.reactivex.rxjava3.internal.util.b;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.e;

public enum SubscriptionHelper implements e
{
    CANCELLED;


    @Override
    public void request(long n2) {
    }

    @Override
    public void cancel() {
    }

    public static boolean validate(e current, e next) {
        if (next == null) {
            a.onError(new NullPointerException("next is null"));
            return false;
        }
        if (current != null) {
            next.cancel();
            SubscriptionHelper.reportSubscriptionSet();
            return false;
        }
        return true;
    }

    public static void reportSubscriptionSet() {
        a.onError(new ProtocolViolationException("Subscription already set!"));
    }

    public static boolean validate(long n2) {
        if (n2 <= 0L) {
            a.onError(new IllegalArgumentException("n > 0 required but it was " + n2));
            return false;
        }
        return true;
    }

    public static void reportMoreProduced(long n2) {
        a.onError(new ProtocolViolationException("More produced than requested: " + n2));
    }

    public static boolean set(AtomicReference<e> field, e s2) {
        e current;
        do {
            if ((current = field.get()) != CANCELLED) continue;
            if (s2 != null) {
                s2.cancel();
            }
            return false;
        } while (!field.compareAndSet(current, s2));
        if (current != null) {
            current.cancel();
        }
        return true;
    }

    public static boolean setOnce(AtomicReference<e> field, e s2) {
        Objects.requireNonNull(s2, "s is null");
        if (!field.compareAndSet(null, s2)) {
            s2.cancel();
            if (field.get() != CANCELLED) {
                SubscriptionHelper.reportSubscriptionSet();
            }
            return false;
        }
        return true;
    }

    public static boolean replace(AtomicReference<e> field, e s2) {
        e current;
        do {
            if ((current = field.get()) != CANCELLED) continue;
            if (s2 != null) {
                s2.cancel();
            }
            return false;
        } while (!field.compareAndSet(current, s2));
        return true;
    }

    public static boolean cancel(AtomicReference<e> field) {
        e current = field.get();
        if (current != CANCELLED && (current = field.getAndSet(CANCELLED)) != CANCELLED) {
            if (current != null) {
                current.cancel();
            }
            return true;
        }
        return false;
    }

    public static boolean deferredSetOnce(AtomicReference<e> field, AtomicLong requested, e s2) {
        if (SubscriptionHelper.setOnce(field, s2)) {
            long r2 = requested.getAndSet(0L);
            if (r2 != 0L) {
                s2.request(r2);
            }
            return true;
        }
        return false;
    }

    public static void deferredRequest(AtomicReference<e> field, AtomicLong requested, long n2) {
        e s2 = field.get();
        if (s2 != null) {
            s2.request(n2);
        } else if (SubscriptionHelper.validate(n2)) {
            long r2;
            b.a(requested, n2);
            s2 = field.get();
            if (s2 != null && (r2 = requested.getAndSet(0L)) != 0L) {
                s2.request(r2);
            }
        }
    }

    public static boolean setOnce(AtomicReference<e> field, e s2, long request) {
        if (SubscriptionHelper.setOnce(field, s2)) {
            s2.request(request);
            return true;
        }
        return false;
    }
}

