/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.util;

import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import java.io.Serializable;
import java.util.Objects;
import org.a.d;
import org.a.e;

public enum NotificationLite {
    COMPLETE;


    public static <T> Object next(T value) {
        return value;
    }

    public static Object complete() {
        return COMPLETE;
    }

    public static Object error(Throwable e2) {
        return new ErrorNotification(e2);
    }

    public static Object subscription(e s2) {
        return new SubscriptionNotification(s2);
    }

    public static Object disposable(b d2) {
        return new DisposableNotification(d2);
    }

    public static boolean isComplete(Object o2) {
        return o2 == COMPLETE;
    }

    public static boolean isError(Object o2) {
        return o2 instanceof ErrorNotification;
    }

    public static boolean isSubscription(Object o2) {
        return o2 instanceof SubscriptionNotification;
    }

    public static boolean isDisposable(Object o2) {
        return o2 instanceof DisposableNotification;
    }

    public static <T> T getValue(Object o2) {
        return (T)o2;
    }

    public static Throwable getError(Object o2) {
        return ((ErrorNotification)o2).e;
    }

    public static e getSubscription(Object o2) {
        return ((SubscriptionNotification)o2).upstream;
    }

    public static b getDisposable(Object o2) {
        return ((DisposableNotification)o2).upstream;
    }

    public static <T> boolean accept(Object o2, d<? super T> s2) {
        if (o2 == COMPLETE) {
            s2.onComplete();
            return true;
        }
        if (o2 instanceof ErrorNotification) {
            s2.onError(((ErrorNotification)o2).e);
            return true;
        }
        s2.onNext(o2);
        return false;
    }

    public static <T> boolean accept(Object o2, ag<? super T> observer) {
        if (o2 == COMPLETE) {
            observer.onComplete();
            return true;
        }
        if (o2 instanceof ErrorNotification) {
            observer.onError(((ErrorNotification)o2).e);
            return true;
        }
        observer.onNext(o2);
        return false;
    }

    public static <T> boolean acceptFull(Object o2, d<? super T> s2) {
        if (o2 == COMPLETE) {
            s2.onComplete();
            return true;
        }
        if (o2 instanceof ErrorNotification) {
            s2.onError(((ErrorNotification)o2).e);
            return true;
        }
        if (o2 instanceof SubscriptionNotification) {
            s2.onSubscribe(((SubscriptionNotification)o2).upstream);
            return false;
        }
        s2.onNext(o2);
        return false;
    }

    public static <T> boolean acceptFull(Object o2, ag<? super T> observer) {
        if (o2 == COMPLETE) {
            observer.onComplete();
            return true;
        }
        if (o2 instanceof ErrorNotification) {
            observer.onError(((ErrorNotification)o2).e);
            return true;
        }
        if (o2 instanceof DisposableNotification) {
            observer.onSubscribe(((DisposableNotification)o2).upstream);
            return false;
        }
        observer.onNext(o2);
        return false;
    }

    public String toString() {
        return "NotificationLite.Complete";
    }

    static final class DisposableNotification
    implements Serializable {
        private static final long serialVersionUID = -7482590109178395495L;
        final b upstream;

        DisposableNotification(b d2) {
            this.upstream = d2;
        }

        public String toString() {
            return "NotificationLite.Disposable[" + this.upstream + "]";
        }
    }

    static final class SubscriptionNotification
    implements Serializable {
        private static final long serialVersionUID = -1322257508628817540L;
        final e upstream;

        SubscriptionNotification(e s2) {
            this.upstream = s2;
        }

        public String toString() {
            return "NotificationLite.Subscription[" + this.upstream + "]";
        }
    }

    static final class ErrorNotification
    implements Serializable {
        private static final long serialVersionUID = -8759979445933046293L;
        final Throwable e;

        ErrorNotification(Throwable e2) {
            this.e = e2;
        }

        public String toString() {
            return "NotificationLite.Error[" + this.e + "]";
        }

        public int hashCode() {
            return this.e.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ErrorNotification) {
                ErrorNotification n2 = (ErrorNotification)obj;
                return Objects.equals(this.e, n2.e);
            }
            return false;
        }
    }
}

