/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.observers;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.b.r;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.VolatileSizeArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class a<T, U extends a<T, U>> {
    protected final CountDownLatch azP;
    protected final List<T> azQ = new VolatileSizeArrayList();
    protected final List<Throwable> azR = new VolatileSizeArrayList<Throwable>();
    protected long azS;
    protected Thread azT;
    protected boolean azU;
    protected CharSequence azV;
    protected boolean azW;

    public a() {
        this.azP = new CountDownLatch(1);
    }

    @e
    public final List<T> qJ() {
        return this.azQ;
    }

    @e
    protected final AssertionError df(@e String message) {
        CharSequence tag;
        StringBuilder b2 = new StringBuilder(64 + message.length());
        b2.append(message);
        b2.append(" (").append("latch = ").append(this.azP.getCount()).append(", ").append("values = ").append(this.azQ.size()).append(", ").append("errors = ").append(this.azR.size()).append(", ").append("completions = ").append(this.azS);
        if (this.azW) {
            b2.append(", timeout!");
        }
        if (this.isDisposed()) {
            b2.append(", disposed!");
        }
        if ((tag = this.azV) != null) {
            b2.append(", tag = ").append(tag);
        }
        b2.append(')');
        AssertionError ae2 = new AssertionError((Object)b2.toString());
        if (!this.azR.isEmpty()) {
            if (this.azR.size() == 1) {
                ((Throwable)((Object)ae2)).initCause(this.azR.get(0));
            } else {
                CompositeException ce = new CompositeException(this.azR);
                ((Throwable)((Object)ae2)).initCause(ce);
            }
        }
        return ae2;
    }

    @e
    public final U qK() throws InterruptedException {
        if (this.azP.getCount() == 0L) {
            return (U)this;
        }
        this.azP.await();
        return (U)this;
    }

    public final boolean aa(long time, @e TimeUnit unit) throws InterruptedException {
        boolean d2 = this.azP.getCount() == 0L || this.azP.await(time, unit);
        this.azW = !d2;
        return d2;
    }

    @e
    public final U qL() {
        long c2 = this.azS;
        if (c2 == 0L) {
            throw this.df("Not completed");
        }
        if (c2 > 1L) {
            throw this.df("Multiple completions: " + c2);
        }
        return (U)this;
    }

    @e
    public final U qM() {
        long c2 = this.azS;
        if (c2 == 1L) {
            throw this.df("Completed!");
        }
        if (c2 > 1L) {
            throw this.df("Multiple completions: " + c2);
        }
        return (U)this;
    }

    @e
    public final U qN() {
        int s2 = this.azR.size();
        if (s2 != 0) {
            throw this.df("Error(s) present: " + this.azR);
        }
        return (U)this;
    }

    @e
    public final U u(@e Throwable error) {
        return this.a(Functions.aW(error), true);
    }

    @e
    public final U ad(@e Class<? extends Throwable> errorClass) {
        return this.a(Functions.ab(errorClass), true);
    }

    @e
    public final U A(@e r<Throwable> errorPredicate) {
        return this.a(errorPredicate, false);
    }

    @e
    private U a(@e r<Throwable> errorPredicate, boolean exact) {
        int s2 = this.azR.size();
        if (s2 == 0) {
            throw this.df("No errors");
        }
        boolean found = false;
        for (Throwable e2 : this.azR) {
            try {
                if (!errorPredicate.test(e2)) continue;
                found = true;
                break;
            }
            catch (Throwable ex) {
                throw ExceptionHelper.r(ex);
            }
        }
        if (found) {
            if (s2 != 1) {
                if (exact) {
                    throw this.df("Error present but other errors as well");
                }
                throw this.df("One error passed the predicate but other errors are present as well");
            }
        } else {
            if (exact) {
                throw this.df("Error not present");
            }
            throw this.df("No error(s) passed the predicate");
        }
        return (U)this;
    }

    @e
    public final U bc(@e T value) {
        int s2 = this.azQ.size();
        if (s2 != 1) {
            throw this.df("\nexpected: " + a.bd(value) + "\ngot: " + this.azQ);
        }
        T v2 = this.azQ.get(0);
        if (!Objects.equals(value, v2)) {
            throw this.df("\nexpected: " + a.bd(value) + "\ngot: " + a.bd(v2));
        }
        return (U)this;
    }

    @e
    public final U B(@e r<T> valuePredicate) {
        this.a(0, valuePredicate);
        if (this.azQ.size() > 1) {
            throw this.df("The first value passed the predicate but this consumer received more than one value");
        }
        return (U)this;
    }

    @e
    public final U a(int index, @e T value) {
        int s2 = this.azQ.size();
        if (s2 == 0) {
            throw this.df("No values");
        }
        if (index < 0 || index >= s2) {
            throw this.df("Index " + index + " is out of range [0, " + s2 + ")");
        }
        T v2 = this.azQ.get(index);
        if (!Objects.equals(value, v2)) {
            throw this.df("\nexpected: " + a.bd(value) + "\ngot: " + a.bd(v2) + "; Value at position " + index + " differ");
        }
        return (U)this;
    }

    @e
    public final U a(int index, @e r<T> valuePredicate) {
        int s2 = this.azQ.size();
        if (s2 == 0) {
            throw this.df("No values");
        }
        if (index < 0 || index >= s2) {
            throw this.df("Index " + index + " is out of range [0, " + s2 + ")");
        }
        boolean found = false;
        T v2 = this.azQ.get(index);
        try {
            if (valuePredicate.test(v2)) {
                found = true;
            }
        }
        catch (Throwable ex) {
            throw ExceptionHelper.r(ex);
        }
        if (!found) {
            throw this.df("Value " + a.bd(v2) + " at position " + index + " did not pass the predicate");
        }
        return (U)this;
    }

    @e
    public static String bd(@f Object o2) {
        if (o2 != null) {
            return o2 + " (class: " + o2.getClass().getSimpleName() + ")";
        }
        return "null";
    }

    @e
    public final U aM(int count) {
        int s2 = this.azQ.size();
        if (s2 != count) {
            throw this.df("\nexpected: " + count + "\ngot: " + s2 + "; Value counts differ");
        }
        return (U)this;
    }

    @e
    public final U qO() {
        return this.aM(0);
    }

    @SafeVarargs
    @e
    public final U n(T ... values) {
        int s2 = this.azQ.size();
        if (s2 != values.length) {
            throw this.df("\nexpected: " + values.length + " " + Arrays.toString(values) + "\ngot: " + s2 + " " + this.azQ + "; Value count differs");
        }
        for (int i2 = 0; i2 < s2; ++i2) {
            T u2 = values[i2];
            T v2 = this.azQ.get(i2);
            if (Objects.equals(u2, v2)) continue;
            throw this.df("\nexpected: " + a.bd(u2) + "\ngot: " + a.bd(v2) + "; Value at position " + i2 + " differ");
        }
        return (U)this;
    }

    @SafeVarargs
    @e
    public final U o(T ... values) {
        return ((a)((a)((a)this.qP()).n(values)).qN()).qM();
    }

    @e
    public final U A(@e Iterable<? extends T> sequence) {
        boolean actualNext;
        boolean expectedNext;
        int i2 = 0;
        Iterator<T> actualIterator = this.azQ.iterator();
        Iterator<T> expectedIterator = sequence.iterator();
        while (true) {
            T v2;
            expectedNext = expectedIterator.hasNext();
            actualNext = actualIterator.hasNext();
            if (!actualNext || !expectedNext) break;
            T u2 = expectedIterator.next();
            if (!Objects.equals(u2, v2 = actualIterator.next())) {
                throw this.df("\nexpected: " + a.bd(u2) + "\ngot: " + a.bd(v2) + "; Value at position " + i2 + " differ");
            }
            ++i2;
        }
        if (actualNext) {
            throw this.df("More values received than expected (" + i2 + ")");
        }
        if (expectedNext) {
            throw this.df("Fewer values received than expected (" + i2 + ")");
        }
        return (U)this;
    }

    @e
    protected abstract U qP();

    @SafeVarargs
    @e
    public final U p(T ... values) {
        return ((a)((a)((a)this.qP()).n(values)).qN()).qL();
    }

    @SafeVarargs
    @e
    public final U a(@e Class<? extends Throwable> error, T ... values) {
        return ((a)((a)((a)this.qP()).n(values)).ad(error)).qM();
    }

    @e
    public final U ab(long time, @e TimeUnit unit) {
        try {
            if (!this.azP.await(time, unit)) {
                this.azW = true;
                this.dispose();
            }
        }
        catch (InterruptedException ex) {
            this.dispose();
            throw ExceptionHelper.r(ex);
        }
        return (U)this;
    }

    @e
    public final U qQ() {
        return ((a)((a)((a)this.qP()).qO()).qN()).qM();
    }

    @e
    public final U a(@f CharSequence tag) {
        this.azV = tag;
        return (U)this;
    }

    @e
    public final U aN(int atLeast) {
        long start = System.currentTimeMillis();
        long timeoutMillis = 5000L;
        while (true) {
            if (System.currentTimeMillis() - start >= timeoutMillis) {
                this.azW = true;
                break;
            }
            if (this.azP.getCount() == 0L || this.azQ.size() >= atLeast) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
        return (U)this;
    }

    protected abstract boolean isDisposed();

    protected abstract void dispose();
}

