/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.c;
import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.internal.util.a;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.processors.a;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.a.d;

public final class BehaviorProcessor<@e T>
extends a<T> {
    final AtomicReference<BehaviorSubscription<T>[]> aBk;
    static final Object[] aBl = new Object[0];
    static final BehaviorSubscription[] aBm = new BehaviorSubscription[0];
    static final BehaviorSubscription[] aBn = new BehaviorSubscription[0];
    final ReadWriteLock aBo;
    final Lock aBp;
    final Lock aBq;
    final AtomicReference<Object> aBr = new AtomicReference();
    final AtomicReference<Throwable> aBs;
    long index;

    @c
    @e
    public static <T> BehaviorProcessor<T> rK() {
        return new BehaviorProcessor<T>();
    }

    @c
    @e
    public static <T> BehaviorProcessor<T> be(T defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue is null");
        return new BehaviorProcessor<T>(defaultValue);
    }

    BehaviorProcessor() {
        this.aBo = new ReentrantReadWriteLock();
        this.aBp = this.aBo.readLock();
        this.aBq = this.aBo.writeLock();
        this.aBk = new AtomicReference<BehaviorSubscription[]>(aBm);
        this.aBs = new AtomicReference();
    }

    BehaviorProcessor(T defaultValue) {
        this();
        this.aBr.lazySet(defaultValue);
    }

    @Override
    protected void d(@e d<? super T> s2) {
        BehaviorSubscription<T> bs2 = new BehaviorSubscription<T>(s2, this);
        s2.onSubscribe(bs2);
        if (this.a(bs2)) {
            if (bs2.cancelled) {
                this.b(bs2);
            } else {
                bs2.emitFirst();
            }
        } else {
            Throwable ex = this.aBs.get();
            if (ex == ExceptionHelper.azB) {
                s2.onComplete();
            } else {
                s2.onError(ex);
            }
        }
    }

    @Override
    public void onSubscribe(@e org.a.e s2) {
        if (this.aBs.get() != null) {
            s2.cancel();
            return;
        }
        s2.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(@e T t2) {
        ExceptionHelper.e(t2, "onNext called with a null value.");
        if (this.aBs.get() != null) {
            return;
        }
        Object o2 = NotificationLite.next(t2);
        this.bg(o2);
        for (BehaviorSubscription<T> bs2 : this.aBk.get()) {
            bs2.emitNext(o2, this.index);
        }
    }

    @Override
    public void onError(@e Throwable t2) {
        ExceptionHelper.e(t2, "onError called with a null Throwable.");
        if (!this.aBs.compareAndSet(null, t2)) {
            io.reactivex.rxjava3.d.a.onError(t2);
            return;
        }
        Object o2 = NotificationLite.error(t2);
        for (BehaviorSubscription<T> bs2 : this.bf(o2)) {
            bs2.emitNext(o2, this.index);
        }
    }

    @Override
    public void onComplete() {
        if (!this.aBs.compareAndSet(null, ExceptionHelper.azB)) {
            return;
        }
        Object o2 = NotificationLite.complete();
        for (BehaviorSubscription<T> bs2 : this.bf(o2)) {
            bs2.emitNext(o2, this.index);
        }
    }

    @c
    public boolean offer(@e T t2) {
        BehaviorSubscription<T>[] array;
        ExceptionHelper.e(t2, "offer called with a null value.");
        for (BehaviorSubscription<T> s2 : array = this.aBk.get()) {
            if (!s2.isFull()) continue;
            return false;
        }
        Object o2 = NotificationLite.next(t2);
        this.bg(o2);
        for (BehaviorSubscription<T> bs2 : array) {
            bs2.emitNext(o2, this.index);
        }
        return true;
    }

    @Override
    @c
    public boolean qc() {
        return this.aBk.get().length != 0;
    }

    @c
    int rL() {
        return this.aBk.get().length;
    }

    @Override
    @c
    @f
    public Throwable bP() {
        Object o2 = this.aBr.get();
        if (NotificationLite.isError(o2)) {
            return NotificationLite.getError(o2);
        }
        return null;
    }

    @c
    @f
    public T getValue() {
        Object o2 = this.aBr.get();
        if (NotificationLite.isComplete(o2) || NotificationLite.isError(o2)) {
            return null;
        }
        return NotificationLite.getValue(o2);
    }

    @Override
    @c
    public boolean rI() {
        Object o2 = this.aBr.get();
        return NotificationLite.isComplete(o2);
    }

    @Override
    @c
    public boolean rH() {
        Object o2 = this.aBr.get();
        return NotificationLite.isError(o2);
    }

    @c
    public boolean rJ() {
        Object o2 = this.aBr.get();
        return o2 != null && !NotificationLite.isComplete(o2) && !NotificationLite.isError(o2);
    }

    boolean a(BehaviorSubscription<T> rs) {
        BehaviorSubscription[] b2;
        BehaviorSubscription<T>[] a2;
        do {
            if ((a2 = this.aBk.get()) == aBn) {
                return false;
            }
            int len = a2.length;
            b2 = new BehaviorSubscription[len + 1];
            System.arraycopy(a2, 0, b2, 0, len);
            b2[len] = rs;
        } while (!this.aBk.compareAndSet(a2, b2));
        return true;
    }

    void b(BehaviorSubscription<T> rs) {
        BehaviorSubscription[] b2;
        BehaviorSubscription<T>[] a2;
        do {
            int len;
            if ((len = (a2 = this.aBk.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < len; ++i2) {
                if (a2[i2] != rs) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (len == 1) {
                b2 = aBm;
                continue;
            }
            b2 = new BehaviorSubscription[len - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, len - j2 - 1);
        } while (!this.aBk.compareAndSet(a2, b2));
    }

    BehaviorSubscription<T>[] bf(Object terminalValue) {
        this.bg(terminalValue);
        return this.aBk.getAndSet(aBn);
    }

    void bg(Object o2) {
        Lock wl = this.aBq;
        wl.lock();
        ++this.index;
        this.aBr.lazySet(o2);
        wl.unlock();
    }

    static final class BehaviorSubscription<@e T>
    extends AtomicLong
    implements a.a<Object>,
    org.a.e {
        private static final long serialVersionUID = 3293175281126227086L;
        final d<? super T> downstream;
        final BehaviorProcessor<T> state;
        boolean next;
        boolean emitting;
        io.reactivex.rxjava3.internal.util.a<Object> queue;
        boolean fastPath;
        volatile boolean cancelled;
        long index;

        BehaviorSubscription(d<? super T> actual, BehaviorProcessor<T> state) {
            this.downstream = actual;
            this.state = state;
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this, n2);
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.b(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitFirst() {
            Object o2;
            if (this.cancelled) {
                return;
            }
            BehaviorSubscription behaviorSubscription = this;
            synchronized (behaviorSubscription) {
                if (this.cancelled) {
                    return;
                }
                if (this.next) {
                    return;
                }
                BehaviorProcessor<T> s2 = this.state;
                Lock readLock = s2.aBp;
                readLock.lock();
                this.index = s2.index;
                o2 = s2.aBr.get();
                readLock.unlock();
                this.emitting = o2 != null;
                this.next = true;
            }
            if (o2 != null) {
                if (this.test(o2)) {
                    return;
                }
                this.emitLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitNext(Object value, long stateIndex) {
            if (this.cancelled) {
                return;
            }
            if (!this.fastPath) {
                BehaviorSubscription behaviorSubscription = this;
                synchronized (behaviorSubscription) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.index == stateIndex) {
                        return;
                    }
                    if (this.emitting) {
                        io.reactivex.rxjava3.internal.util.a<Object> q2 = this.queue;
                        if (q2 == null) {
                            this.queue = q2 = new io.reactivex.rxjava3.internal.util.a(4);
                        }
                        q2.add(value);
                        return;
                    }
                    this.next = true;
                }
                this.fastPath = true;
            }
            this.test(value);
        }

        @Override
        public boolean test(Object o2) {
            if (this.cancelled) {
                return true;
            }
            if (NotificationLite.isComplete(o2)) {
                this.downstream.onComplete();
                return true;
            }
            if (NotificationLite.isError(o2)) {
                this.downstream.onError(NotificationLite.getError(o2));
                return true;
            }
            long r2 = this.get();
            if (r2 != 0L) {
                this.downstream.onNext(NotificationLite.getValue(o2));
                if (r2 != Long.MAX_VALUE) {
                    this.decrementAndGet();
                }
                return false;
            }
            this.cancel();
            this.downstream.onError(MissingBackpressureException.createDefault());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitLoop() {
            while (!this.cancelled) {
                io.reactivex.rxjava3.internal.util.a<Object> q2;
                BehaviorSubscription behaviorSubscription = this;
                synchronized (behaviorSubscription) {
                    q2 = this.queue;
                    if (q2 == null) {
                        this.emitting = false;
                        return;
                    }
                    this.queue = null;
                }
                q2.a(this);
            }
            return;
        }

        public boolean isFull() {
            return this.get() == 0L;
        }
    }
}

