/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.BackpressureKind;
import io.reactivex.rxjava3.annotations.c;
import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.g;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.d;
import io.reactivex.rxjava3.operators.h;
import io.reactivex.rxjava3.processors.a;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@io.reactivex.rxjava3.annotations.a(mj=BackpressureKind.FULL)
@g(value="none")
public final class MulticastProcessor<@e T>
extends a<T> {
    final AtomicInteger aBt;
    final AtomicReference<org.a.e> aBu;
    final AtomicReference<MulticastSubscription<T>[]> aBv;
    final int aBw;
    final int aBx;
    final boolean aBy;
    volatile io.reactivex.rxjava3.operators.g<T> queue;
    volatile boolean done;
    volatile Throwable error;
    int consumed;
    int fusionMode;
    static final MulticastSubscription[] aBz = new MulticastSubscription[0];
    static final MulticastSubscription[] aBA = new MulticastSubscription[0];

    @c
    @e
    public static <T> MulticastProcessor<T> rN() {
        return new MulticastProcessor<T>(MulticastProcessor.mB(), false);
    }

    @c
    @e
    public static <T> MulticastProcessor<T> W(boolean refCount) {
        return new MulticastProcessor<T>(MulticastProcessor.mB(), refCount);
    }

    @c
    @e
    public static <T> MulticastProcessor<T> aS(int bufferSize) {
        io.reactivex.rxjava3.internal.functions.a.e(bufferSize, "bufferSize");
        return new MulticastProcessor<T>(bufferSize, false);
    }

    @c
    @e
    public static <T> MulticastProcessor<T> d(int bufferSize, boolean refCount) {
        io.reactivex.rxjava3.internal.functions.a.e(bufferSize, "bufferSize");
        return new MulticastProcessor<T>(bufferSize, refCount);
    }

    MulticastProcessor(int bufferSize, boolean refCount) {
        this.aBw = bufferSize;
        this.aBx = bufferSize - (bufferSize >> 2);
        this.aBt = new AtomicInteger();
        this.aBv = new AtomicReference<MulticastSubscription[]>(aBz);
        this.aBu = new AtomicReference();
        this.aBy = refCount;
    }

    public void start() {
        if (SubscriptionHelper.setOnce(this.aBu, EmptySubscription.INSTANCE)) {
            this.queue = new SpscArrayQueue<T>(this.aBw);
        }
    }

    public void rO() {
        if (SubscriptionHelper.setOnce(this.aBu, EmptySubscription.INSTANCE)) {
            this.queue = new h(this.aBw);
        }
    }

    @Override
    public void onSubscribe(@e org.a.e s2) {
        if (SubscriptionHelper.setOnce(this.aBu, s2)) {
            if (s2 instanceof d) {
                d qs = (d)s2;
                int m2 = qs.requestFusion(3);
                if (m2 == 1) {
                    this.fusionMode = m2;
                    this.queue = qs;
                    this.done = true;
                    this.drain();
                    return;
                }
                if (m2 == 2) {
                    this.fusionMode = m2;
                    this.queue = qs;
                    s2.request(this.aBw);
                    return;
                }
            }
            this.queue = new SpscArrayQueue<T>(this.aBw);
            s2.request(this.aBw);
        }
    }

    @Override
    public void onNext(@e T t2) {
        if (this.done) {
            return;
        }
        if (this.fusionMode == 0) {
            ExceptionHelper.e(t2, "onNext called with a null value.");
            if (!this.queue.offer(t2)) {
                SubscriptionHelper.cancel(this.aBu);
                this.onError(MissingBackpressureException.createDefault());
                return;
            }
        }
        this.drain();
    }

    @c
    public boolean offer(@e T t2) {
        ExceptionHelper.e(t2, "offer called with a null value.");
        if (this.done) {
            return false;
        }
        if (this.fusionMode == 0) {
            if (this.queue.offer(t2)) {
                this.drain();
                return true;
            }
            return false;
        }
        throw new IllegalStateException("offer() should not be called in fusion mode!");
    }

    @Override
    public void onError(@e Throwable t2) {
        ExceptionHelper.e(t2, "onError called with a null Throwable.");
        if (!this.done) {
            this.error = t2;
            this.done = true;
            this.drain();
            return;
        }
        io.reactivex.rxjava3.d.a.onError(t2);
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    @c
    public boolean qc() {
        return this.aBv.get().length != 0;
    }

    @Override
    @c
    public boolean rH() {
        return this.done && this.error != null;
    }

    @Override
    @c
    public boolean rI() {
        return this.done && this.error == null;
    }

    @Override
    @c
    public Throwable bP() {
        return this.done ? this.error : null;
    }

    @Override
    protected void d(@e org.a.d<? super T> s2) {
        MulticastSubscription<T> ms = new MulticastSubscription<T>(s2, this);
        s2.onSubscribe(ms);
        if (this.a(ms)) {
            if (ms.get() == Long.MIN_VALUE) {
                this.b(ms);
            } else {
                this.drain();
            }
        } else {
            Throwable ex;
            if (this.done && (ex = this.error) != null) {
                s2.onError(ex);
                return;
            }
            s2.onComplete();
        }
    }

    boolean a(MulticastSubscription<T> inner) {
        MulticastSubscription[] b2;
        MulticastSubscription<T>[] a2;
        do {
            if ((a2 = this.aBv.get()) == aBA) {
                return false;
            }
            int n2 = a2.length;
            b2 = new MulticastSubscription[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = inner;
        } while (!this.aBv.compareAndSet(a2, b2));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void b(MulticastSubscription<T> inner) {
        MulticastSubscription<T>[] a2;
        int n2;
        while ((n2 = (a2 = this.aBv.get()).length) != 0) {
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a2[i2] != inner) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) return;
            if (n2 == 1) {
                if (this.aBy) {
                    if (!this.aBv.compareAndSet(a2, aBA)) continue;
                    SubscriptionHelper.cancel(this.aBu);
                    this.done = true;
                    return;
                }
                if (!this.aBv.compareAndSet(a2, aBz)) continue;
                return;
            }
            MulticastSubscription[] b2 = new MulticastSubscription[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
            if (this.aBv.compareAndSet(a2, b2)) return;
        }
        return;
    }

    void drain() {
        if (this.aBt.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        AtomicReference<MulticastSubscription<T>[]> subs = this.aBv;
        int c2 = this.consumed;
        int lim = this.aBx;
        int fm = this.fusionMode;
        block2: while (true) {
            MulticastSubscription<T>[] as2;
            int n2;
            io.reactivex.rxjava3.operators.g<T> q2;
            if ((q2 = this.queue) != null && (n2 = (as2 = subs.get()).length) != 0) {
                MulticastSubscription<T>[] bs2;
                long r2 = -1L;
                for (MulticastSubscription<T> a2 : as2) {
                    long ra = a2.get();
                    if (ra < 0L) continue;
                    r2 = r2 == -1L ? ra - a2.emitted : Math.min(r2, ra - a2.emitted);
                }
                while (r2 > 0L) {
                    boolean empty;
                    T v2;
                    bs2 = subs.get();
                    if (bs2 == aBA) {
                        q2.clear();
                        return;
                    }
                    if (as2 != bs2) continue block2;
                    boolean d2 = this.done;
                    try {
                        v2 = q2.poll();
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        SubscriptionHelper.cancel(this.aBu);
                        d2 = true;
                        v2 = null;
                        this.error = ex;
                        this.done = true;
                    }
                    boolean bl2 = empty = v2 == null;
                    if (d2 && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            for (MulticastSubscription inner : subs.getAndSet(aBA)) {
                                inner.onError(ex);
                            }
                        } else {
                            for (MulticastSubscription inner : subs.getAndSet(aBA)) {
                                inner.onComplete();
                            }
                        }
                        return;
                    }
                    if (empty) break;
                    for (MulticastSubscription<T> inner : as2) {
                        inner.onNext(v2);
                    }
                    --r2;
                    if (fm == 1 || ++c2 != lim) continue;
                    c2 = 0;
                    this.aBu.get().request(lim);
                }
                if (r2 == 0L) {
                    bs2 = subs.get();
                    if (bs2 == aBA) {
                        q2.clear();
                        return;
                    }
                    if (as2 != bs2) continue;
                    if (this.done && q2.isEmpty()) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            for (MulticastSubscription inner : subs.getAndSet(aBA)) {
                                inner.onError(ex);
                            }
                        } else {
                            for (MulticastSubscription inner : subs.getAndSet(aBA)) {
                                inner.onComplete();
                            }
                        }
                        return;
                    }
                }
            }
            this.consumed = c2;
            if ((missed = this.aBt.addAndGet(-missed)) == 0) break;
        }
    }

    static final class MulticastSubscription<@e T>
    extends AtomicLong
    implements org.a.e {
        private static final long serialVersionUID = -363282618957264509L;
        final org.a.d<? super T> downstream;
        final MulticastProcessor<T> parent;
        long emitted;

        MulticastSubscription(org.a.d<? super T> actual, MulticastProcessor<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        @Override
        public void request(long n2) {
            long r2;
            if (SubscriptionHelper.validate(n2) && (r2 = b.b(this, n2)) != Long.MIN_VALUE && r2 != Long.MAX_VALUE) {
                this.parent.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.b(this);
            }
        }

        void onNext(T t2) {
            if (this.get() != Long.MIN_VALUE) {
                ++this.emitted;
                this.downstream.onNext(t2);
            }
        }

        void onError(Throwable t2) {
            if (this.get() != Long.MIN_VALUE) {
                this.downstream.onError(t2);
            }
        }

        void onComplete() {
            if (this.get() != Long.MIN_VALUE) {
                this.downstream.onComplete();
            }
        }
    }
}

