/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class ReplayProcessor<@e T>
extends io.reactivex.rxjava3.processors.a<T> {
    private static final Object[] aBE = new Object[0];
    final a<T> aBF;
    boolean done;
    final AtomicReference<ReplaySubscription<T>[]> aBG;
    static final ReplaySubscription[] aBH = new ReplaySubscription[0];
    static final ReplaySubscription[] aBI = new ReplaySubscription[0];

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> ReplayProcessor<T> rQ() {
        return new ReplayProcessor(new d(16));
    }

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> ReplayProcessor<T> aT(int capacityHint) {
        io.reactivex.rxjava3.internal.functions.a.e(capacityHint, "capacityHint");
        return new ReplayProcessor(new d(capacityHint));
    }

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> ReplayProcessor<T> aU(int maxSize) {
        io.reactivex.rxjava3.internal.functions.a.e(maxSize, "maxSize");
        return new ReplayProcessor(new c(maxSize));
    }

    @io.reactivex.rxjava3.annotations.c
    static <T> ReplayProcessor<T> rR() {
        return new ReplayProcessor(new c(Integer.MAX_VALUE));
    }

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> ReplayProcessor<T> Y(long maxAge, @e TimeUnit unit, @e ah scheduler) {
        io.reactivex.rxjava3.internal.functions.a.c(maxAge, "maxAge");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return new ReplayProcessor(new b(Integer.MAX_VALUE, maxAge, unit, scheduler));
    }

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> ReplayProcessor<T> c(long maxAge, @e TimeUnit unit, @e ah scheduler, int maxSize) {
        io.reactivex.rxjava3.internal.functions.a.e(maxSize, "maxSize");
        io.reactivex.rxjava3.internal.functions.a.c(maxAge, "maxAge");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return new ReplayProcessor(new b(maxSize, maxAge, unit, scheduler));
    }

    ReplayProcessor(a<T> buffer) {
        this.aBF = buffer;
        this.aBG = new AtomicReference<ReplaySubscription[]>(aBH);
    }

    @Override
    protected void d(org.a.d<? super T> s2) {
        ReplaySubscription<? super T> rs = new ReplaySubscription<T>(s2, this);
        s2.onSubscribe(rs);
        if (this.a(rs) && rs.cancelled) {
            this.b(rs);
            return;
        }
        this.aBF.c(rs);
    }

    @Override
    public void onSubscribe(org.a.e s2) {
        if (this.done) {
            s2.cancel();
            return;
        }
        s2.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t2) {
        ExceptionHelper.e(t2, "onNext called with a null value.");
        if (this.done) {
            return;
        }
        a<T> b2 = this.aBF;
        b2.next(t2);
        for (ReplaySubscription<T> rs : this.aBG.get()) {
            b2.c(rs);
        }
    }

    @Override
    public void onError(Throwable t2) {
        ExceptionHelper.e(t2, "onError called with a null Throwable.");
        if (this.done) {
            io.reactivex.rxjava3.d.a.onError(t2);
            return;
        }
        this.done = true;
        a<T> b2 = this.aBF;
        b2.error(t2);
        for (ReplaySubscription rs : this.aBG.getAndSet(aBI)) {
            b2.c(rs);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        a<T> b2 = this.aBF;
        b2.complete();
        for (ReplaySubscription rs : this.aBG.getAndSet(aBI)) {
            b2.c(rs);
        }
    }

    @Override
    @io.reactivex.rxjava3.annotations.c
    public boolean qc() {
        return this.aBG.get().length != 0;
    }

    @io.reactivex.rxjava3.annotations.c
    int rL() {
        return this.aBG.get().length;
    }

    @Override
    @io.reactivex.rxjava3.annotations.c
    @f
    public Throwable bP() {
        a<T> b2 = this.aBF;
        if (b2.isDone()) {
            return b2.nY();
        }
        return null;
    }

    public void rS() {
        this.aBF.trimHead();
    }

    @io.reactivex.rxjava3.annotations.c
    public T getValue() {
        return this.aBF.getValue();
    }

    @io.reactivex.rxjava3.annotations.c
    public Object[] getValues() {
        Object[] a2 = aBE;
        Object[] b2 = this.getValues(a2);
        if (b2 == aBE) {
            return new Object[0];
        }
        return b2;
    }

    @io.reactivex.rxjava3.annotations.c
    public T[] getValues(T[] array) {
        return this.aBF.getValues(array);
    }

    @Override
    @io.reactivex.rxjava3.annotations.c
    public boolean rI() {
        a<T> b2 = this.aBF;
        return b2.isDone() && b2.nY() == null;
    }

    @Override
    @io.reactivex.rxjava3.annotations.c
    public boolean rH() {
        a<T> b2 = this.aBF;
        return b2.isDone() && b2.nY() != null;
    }

    @io.reactivex.rxjava3.annotations.c
    public boolean rJ() {
        return this.aBF.size() != 0;
    }

    @io.reactivex.rxjava3.annotations.c
    int size() {
        return this.aBF.size();
    }

    boolean a(ReplaySubscription<T> rs) {
        ReplaySubscription[] b2;
        ReplaySubscription<T>[] a2;
        do {
            if ((a2 = this.aBG.get()) == aBI) {
                return false;
            }
            int len = a2.length;
            b2 = new ReplaySubscription[len + 1];
            System.arraycopy(a2, 0, b2, 0, len);
            b2[len] = rs;
        } while (!this.aBG.compareAndSet(a2, b2));
        return true;
    }

    void b(ReplaySubscription<T> rs) {
        ReplaySubscription[] b2;
        ReplaySubscription<T>[] a2;
        do {
            if ((a2 = this.aBG.get()) == aBI || a2 == aBH) {
                return;
            }
            int len = a2.length;
            int j2 = -1;
            for (int i2 = 0; i2 < len; ++i2) {
                if (a2[i2] != rs) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (len == 1) {
                b2 = aBH;
                continue;
            }
            b2 = new ReplaySubscription[len - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, len - j2 - 1);
        } while (!this.aBG.compareAndSet(a2, b2));
    }

    static final class b<T>
    implements a<T> {
        final int aBJ;
        final long aBK;
        final TimeUnit aBL;
        final ah aBM;
        int size;
        volatile TimedNode<T> aBN;
        TimedNode<T> aBO;
        Throwable error;
        volatile boolean done;

        b(int maxSize, long maxAge, TimeUnit unit, ah scheduler) {
            this.aBJ = maxSize;
            this.aBK = maxAge;
            this.aBL = unit;
            this.aBM = scheduler;
            TimedNode<Object> h2 = new TimedNode<Object>(null, 0L);
            this.aBO = h2;
            this.aBN = h2;
        }

        void trim() {
            if (this.size > this.aBJ) {
                --this.size;
                TimedNode<T> h2 = this.aBN;
                this.aBN = (TimedNode)h2.get();
            }
            long limit = this.aBM.h(this.aBL) - this.aBK;
            TimedNode h3 = this.aBN;
            while (true) {
                if (this.size <= 1) {
                    this.aBN = h3;
                    break;
                }
                TimedNode next = (TimedNode)h3.get();
                if (next.time > limit) {
                    this.aBN = h3;
                    break;
                }
                h3 = next;
                --this.size;
            }
        }

        void trimFinal() {
            long limit = this.aBM.h(this.aBL) - this.aBK;
            TimedNode h2 = this.aBN;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h2.get()) == null) {
                    if (h2.value != null) {
                        this.aBN = new TimedNode<Object>(null, 0L);
                        break;
                    }
                    this.aBN = h2;
                    break;
                }
                if (next.time > limit) {
                    if (h2.value != null) {
                        TimedNode<Object> n2 = new TimedNode<Object>(null, 0L);
                        n2.lazySet(h2.get());
                        this.aBN = n2;
                        break;
                    }
                    this.aBN = h2;
                    break;
                }
                h2 = next;
            }
        }

        @Override
        public void trimHead() {
            if (this.aBN.value != null) {
                TimedNode<Object> n2 = new TimedNode<Object>(null, 0L);
                n2.lazySet(this.aBN.get());
                this.aBN = n2;
            }
        }

        @Override
        public void next(T value) {
            TimedNode<T> n2 = new TimedNode<T>(value, this.aBM.h(this.aBL));
            TimedNode<T> t2 = this.aBO;
            this.aBO = n2;
            ++this.size;
            t2.set(n2);
            this.trim();
        }

        @Override
        public void error(Throwable ex) {
            this.trimFinal();
            this.error = ex;
            this.done = true;
        }

        @Override
        public void complete() {
            this.trimFinal();
            this.done = true;
        }

        @Override
        @f
        public T getValue() {
            TimedNode next;
            TimedNode h2 = this.aBN;
            while ((next = (TimedNode)h2.get()) != null) {
                h2 = next;
            }
            long limit = this.aBM.h(this.aBL) - this.aBK;
            if (h2.time < limit) {
                return null;
            }
            return h2.value;
        }

        @Override
        public T[] getValues(T[] array) {
            TimedNode h2 = this.rT();
            int s2 = this.a(h2);
            if (s2 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s2) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
                }
                for (int i2 = 0; i2 != s2; ++i2) {
                    TimedNode next = (TimedNode)h2.get();
                    array[i2] = next.value;
                    h2 = next;
                }
                if (array.length > s2) {
                    array[s2] = null;
                }
            }
            return array;
        }

        TimedNode<T> rT() {
            long ts;
            TimedNode index = this.aBN;
            long limit = this.aBM.h(this.aBL) - this.aBK;
            TimedNode next = (TimedNode)index.get();
            while (next != null && (ts = next.time) <= limit) {
                index = next;
                next = (TimedNode)index.get();
            }
            return index;
        }

        @Override
        public void c(ReplaySubscription<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            org.a.d a2 = rs.downstream;
            TimedNode index = (TimedNode)rs.index;
            if (index == null) {
                index = this.rT();
            }
            long e2 = rs.emitted;
            do {
                boolean d2;
                long r2 = rs.requested.get();
                while (e2 != r2) {
                    boolean empty;
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d2 = this.done;
                    TimedNode next = (TimedNode)index.get();
                    boolean bl2 = empty = next == null;
                    if (d2 && empty) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a2.onComplete();
                        } else {
                            a2.onError(ex);
                        }
                        return;
                    }
                    if (empty) break;
                    a2.onNext(next.value);
                    ++e2;
                    index = next;
                }
                if (e2 == r2) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d2 = this.done;
                    if (d2 && index.get() == null) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a2.onComplete();
                        } else {
                            a2.onError(ex);
                        }
                        return;
                    }
                }
                rs.index = index;
                rs.emitted = e2;
            } while ((missed = rs.addAndGet(-missed)) != 0);
        }

        @Override
        public int size() {
            return this.a(this.rT());
        }

        int a(TimedNode<T> h2) {
            TimedNode next;
            int s2;
            for (s2 = 0; s2 != Integer.MAX_VALUE && (next = (TimedNode)h2.get()) != null; ++s2) {
                h2 = next;
            }
            return s2;
        }

        @Override
        public Throwable nY() {
            return this.error;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }
    }

    static final class c<@e T>
    implements a<T> {
        final int aBP;
        int size;
        volatile Node<T> aBQ;
        Node<T> aBR;
        Throwable error;
        volatile boolean done;

        c(int maxSize) {
            this.aBP = maxSize;
            Node<Object> h2 = new Node<Object>(null);
            this.aBR = h2;
            this.aBQ = h2;
        }

        void trim() {
            if (this.size > this.aBP) {
                --this.size;
                Node<T> h2 = this.aBQ;
                this.aBQ = (Node)h2.get();
            }
        }

        @Override
        public void next(T value) {
            Node<T> n2 = new Node<T>(value);
            Node<T> t2 = this.aBR;
            this.aBR = n2;
            ++this.size;
            t2.set(n2);
            this.trim();
        }

        @Override
        public void error(Throwable ex) {
            this.error = ex;
            this.trimHead();
            this.done = true;
        }

        @Override
        public void complete() {
            this.trimHead();
            this.done = true;
        }

        @Override
        public void trimHead() {
            if (this.aBQ.value != null) {
                Node<Object> n2 = new Node<Object>(null);
                n2.lazySet(this.aBQ.get());
                this.aBQ = n2;
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public Throwable nY() {
            return this.error;
        }

        @Override
        public T getValue() {
            Node h2 = this.aBQ;
            Node n2;
            while ((n2 = (Node)h2.get()) != null) {
                h2 = n2;
            }
            return h2.value;
        }

        @Override
        public T[] getValues(T[] array) {
            Node next;
            Node h2;
            int s2 = 0;
            Node h0 = h2 = this.aBQ;
            while ((next = (Node)h0.get()) != null) {
                ++s2;
                h0 = next;
            }
            if (array.length < s2) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
            }
            for (int j2 = 0; j2 < s2; ++j2) {
                h2 = (Node)h2.get();
                array[j2] = h2.value;
            }
            if (array.length > s2) {
                array[s2] = null;
            }
            return array;
        }

        @Override
        public void c(ReplaySubscription<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            org.a.d a2 = rs.downstream;
            Node index = (Node)rs.index;
            if (index == null) {
                index = this.aBQ;
            }
            long e2 = rs.emitted;
            do {
                boolean d2;
                long r2 = rs.requested.get();
                while (e2 != r2) {
                    boolean empty;
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d2 = this.done;
                    Node next = (Node)index.get();
                    boolean bl2 = empty = next == null;
                    if (d2 && empty) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a2.onComplete();
                        } else {
                            a2.onError(ex);
                        }
                        return;
                    }
                    if (empty) break;
                    a2.onNext(next.value);
                    ++e2;
                    index = next;
                }
                if (e2 == r2) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d2 = this.done;
                    if (d2 && index.get() == null) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a2.onComplete();
                        } else {
                            a2.onError(ex);
                        }
                        return;
                    }
                }
                rs.index = index;
                rs.emitted = e2;
            } while ((missed = rs.addAndGet(-missed)) != 0);
        }

        @Override
        public int size() {
            Node next;
            int s2;
            Node h2 = this.aBQ;
            for (s2 = 0; s2 != Integer.MAX_VALUE && (next = (Node)h2.get()) != null; ++s2) {
                h2 = next;
            }
            return s2;
        }
    }

    static final class TimedNode<T>
    extends AtomicReference<TimedNode<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;
        final long time;

        TimedNode(T value, long time) {
            this.value = value;
            this.time = time;
        }
    }

    static final class Node<T>
    extends AtomicReference<Node<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;

        Node(T value) {
            this.value = value;
        }
    }

    static final class d<T>
    implements a<T> {
        final List<T> aBS;
        Throwable error;
        volatile boolean done;
        volatile int size;

        d(int capacityHint) {
            this.aBS = new ArrayList<T>(capacityHint);
        }

        @Override
        public void next(T value) {
            this.aBS.add(value);
            ++this.size;
        }

        @Override
        public void error(Throwable ex) {
            this.error = ex;
            this.done = true;
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void trimHead() {
        }

        @Override
        @f
        public T getValue() {
            int s2 = this.size;
            if (s2 == 0) {
                return null;
            }
            return this.aBS.get(s2 - 1);
        }

        @Override
        public T[] getValues(T[] array) {
            int s2 = this.size;
            if (s2 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            List<T> b2 = this.aBS;
            if (array.length < s2) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
            }
            for (int i2 = 0; i2 < s2; ++i2) {
                array[i2] = b2.get(i2);
            }
            if (array.length > s2) {
                array[s2] = null;
            }
            return array;
        }

        @Override
        public void c(ReplaySubscription<T> rs) {
            int index;
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            List<T> b2 = this.aBS;
            org.a.d<T> a2 = rs.downstream;
            Integer indexObject = (Integer)rs.index;
            if (indexObject != null) {
                index = indexObject;
            } else {
                index = 0;
                rs.index = 0;
            }
            long e2 = rs.emitted;
            do {
                int s2;
                boolean d2;
                long r2 = rs.requested.get();
                while (e2 != r2) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d2 = this.done;
                    s2 = this.size;
                    if (d2 && index == s2) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a2.onComplete();
                        } else {
                            a2.onError(ex);
                        }
                        return;
                    }
                    if (index == s2) break;
                    a2.onNext(b2.get(index));
                    ++index;
                    ++e2;
                }
                if (e2 == r2) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d2 = this.done;
                    s2 = this.size;
                    if (d2 && index == s2) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a2.onComplete();
                        } else {
                            a2.onError(ex);
                        }
                        return;
                    }
                }
                rs.index = index;
                rs.emitted = e2;
            } while ((missed = rs.addAndGet(-missed)) != 0);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public Throwable nY() {
            return this.error;
        }
    }

    static final class ReplaySubscription<@e T>
    extends AtomicInteger
    implements org.a.e {
        private static final long serialVersionUID = 466549804534799122L;
        final org.a.d<? super T> downstream;
        final ReplayProcessor<T> state;
        Object index;
        final AtomicLong requested;
        volatile boolean cancelled;
        long emitted;

        ReplaySubscription(org.a.d<? super T> actual, ReplayProcessor<T> state) {
            this.downstream = actual;
            this.state = state;
            this.requested = new AtomicLong();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
                this.state.aBF.c(this);
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.b(this);
            }
        }
    }

    static interface a<@e T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void c(ReplaySubscription<T> var1);

        public int size();

        @f
        public T getValue();

        public T[] getValues(T[] var1);

        public boolean isDone();

        public Throwable nY();

        public void trimHead();
    }
}

