/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.c;
import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.h;
import io.reactivex.rxjava3.processors.a;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;

public final class UnicastProcessor<@e T>
extends a<T> {
    final h<T> aBU;
    final AtomicReference<Runnable> aBV;
    final boolean aBW;
    volatile boolean done;
    Throwable error;
    final AtomicReference<d<? super T>> aBX;
    volatile boolean cancelled;
    final AtomicBoolean aBY;
    final BasicIntQueueSubscription<T> aBZ;
    final AtomicLong aCa;
    boolean aCb;

    @c
    @e
    public static <T> UnicastProcessor<T> rU() {
        return new UnicastProcessor<T>(UnicastProcessor.mB(), null, true);
    }

    @c
    @e
    public static <T> UnicastProcessor<T> aV(int capacityHint) {
        io.reactivex.rxjava3.internal.functions.a.e(capacityHint, "capacityHint");
        return new UnicastProcessor<T>(capacityHint, null, true);
    }

    @c
    @e
    public static <T> UnicastProcessor<T> X(boolean delayError) {
        return new UnicastProcessor<T>(UnicastProcessor.mB(), null, delayError);
    }

    @c
    @e
    public static <T> UnicastProcessor<T> a(int capacityHint, @e Runnable onTerminate) {
        return UnicastProcessor.a(capacityHint, onTerminate, true);
    }

    @c
    @e
    public static <T> UnicastProcessor<T> a(int capacityHint, @e Runnable onTerminate, boolean delayError) {
        Objects.requireNonNull(onTerminate, "onTerminate");
        io.reactivex.rxjava3.internal.functions.a.e(capacityHint, "capacityHint");
        return new UnicastProcessor<T>(capacityHint, onTerminate, delayError);
    }

    UnicastProcessor(int capacityHint, Runnable onTerminate, boolean delayError) {
        this.aBU = new h(capacityHint);
        this.aBV = new AtomicReference<Runnable>(onTerminate);
        this.aBW = delayError;
        this.aBX = new AtomicReference();
        this.aBY = new AtomicBoolean();
        this.aBZ = new UnicastQueueSubscription();
        this.aCa = new AtomicLong();
    }

    void rV() {
        Runnable r2 = this.aBV.getAndSet(null);
        if (r2 != null) {
            r2.run();
        }
    }

    void k(d<? super T> a2) {
        int missed = 1;
        h<T> q2 = this.aBU;
        boolean failFast = !this.aBW;
        do {
            long e2;
            long r2 = this.aCa.get();
            for (e2 = 0L; r2 != e2; ++e2) {
                boolean empty;
                boolean d2 = this.done;
                T t2 = q2.poll();
                boolean bl2 = empty = t2 == null;
                if (this.a(failFast, d2, empty, a2, q2)) {
                    return;
                }
                if (empty) break;
                a2.onNext(t2);
            }
            if (r2 == e2 && this.a(failFast, this.done, q2.isEmpty(), a2, q2)) {
                return;
            }
            if (e2 == 0L || r2 == Long.MAX_VALUE) continue;
            this.aCa.addAndGet(-e2);
        } while ((missed = this.aBZ.addAndGet(-missed)) != 0);
    }

    void l(d<? super T> a2) {
        boolean failFast;
        int missed = 1;
        h<T> q2 = this.aBU;
        boolean bl2 = failFast = !this.aBW;
        do {
            if (this.cancelled) {
                this.aBX.lazySet(null);
                return;
            }
            boolean d2 = this.done;
            if (failFast && d2 && this.error != null) {
                q2.clear();
                this.aBX.lazySet(null);
                a2.onError(this.error);
                return;
            }
            a2.onNext(null);
            if (!d2) continue;
            this.aBX.lazySet(null);
            Throwable ex = this.error;
            if (ex != null) {
                a2.onError(ex);
            } else {
                a2.onComplete();
            }
            return;
        } while ((missed = this.aBZ.addAndGet(-missed)) != 0);
    }

    void drain() {
        if (this.aBZ.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        d<? super T> a2 = this.aBX.get();
        while (true) {
            if (a2 != null) {
                if (this.aCb) {
                    this.l(a2);
                } else {
                    this.k(a2);
                }
                return;
            }
            if ((missed = this.aBZ.addAndGet(-missed)) == 0) break;
            a2 = this.aBX.get();
        }
    }

    boolean a(boolean failFast, boolean d2, boolean empty, d<? super T> a2, h<T> q2) {
        if (this.cancelled) {
            q2.clear();
            this.aBX.lazySet(null);
            return true;
        }
        if (d2) {
            if (failFast && this.error != null) {
                q2.clear();
                this.aBX.lazySet(null);
                a2.onError(this.error);
                return true;
            }
            if (empty) {
                Throwable e2 = this.error;
                this.aBX.lazySet(null);
                if (e2 != null) {
                    a2.onError(e2);
                } else {
                    a2.onComplete();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onSubscribe(org.a.e s2) {
        if (this.done || this.cancelled) {
            s2.cancel();
        } else {
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        ExceptionHelper.e(t2, "onNext called with a null value.");
        if (this.done || this.cancelled) {
            return;
        }
        this.aBU.offer(t2);
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        ExceptionHelper.e(t2, "onError called with a null Throwable.");
        if (this.done || this.cancelled) {
            io.reactivex.rxjava3.d.a.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        this.rV();
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        this.rV();
        this.drain();
    }

    @Override
    protected void d(d<? super T> s2) {
        if (!this.aBY.get() && this.aBY.compareAndSet(false, true)) {
            s2.onSubscribe(this.aBZ);
            this.aBX.set(s2);
            if (this.cancelled) {
                this.aBX.lazySet(null);
            } else {
                this.drain();
            }
        } else {
            EmptySubscription.error(new IllegalStateException("This processor allows only a single Subscriber"), s2);
        }
    }

    @Override
    @c
    public boolean qc() {
        return this.aBX.get() != null;
    }

    @Override
    @c
    @f
    public Throwable bP() {
        if (this.done) {
            return this.error;
        }
        return null;
    }

    @Override
    @c
    public boolean rI() {
        return this.done && this.error == null;
    }

    @Override
    @c
    public boolean rH() {
        return this.done && this.error != null;
    }

    final class UnicastQueueSubscription
    extends BasicIntQueueSubscription<T> {
        private static final long serialVersionUID = -4896760517184205454L;

        UnicastQueueSubscription() {
        }

        @Override
        @f
        public T poll() {
            return UnicastProcessor.this.aBU.poll();
        }

        @Override
        public boolean isEmpty() {
            return UnicastProcessor.this.aBU.isEmpty();
        }

        @Override
        public void clear() {
            UnicastProcessor.this.aBU.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                UnicastProcessor.this.aCb = true;
                return 2;
            }
            return 0;
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(UnicastProcessor.this.aCa, n2);
                UnicastProcessor.this.drain();
            }
        }

        @Override
        public void cancel() {
            if (UnicastProcessor.this.cancelled) {
                return;
            }
            UnicastProcessor.this.cancelled = true;
            UnicastProcessor.this.rV();
            UnicastProcessor.this.aBX.lazySet(null);
            if (UnicastProcessor.this.aBZ.getAndIncrement() == 0) {
                UnicastProcessor.this.aBX.lazySet(null);
                if (!UnicastProcessor.this.aCb) {
                    UnicastProcessor.this.aBU.clear();
                }
            }
        }
    }
}

