/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subjects;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.subjects.c;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ReplaySubject<T>
extends c<T> {
    final a<T> aCT;
    final AtomicReference<ReplayDisposable<T>[]> aCU;
    static final ReplayDisposable[] aCV = new ReplayDisposable[0];
    static final ReplayDisposable[] aCW = new ReplayDisposable[0];
    boolean done;
    private static final Object[] aCX = new Object[0];

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> ReplaySubject<T> sm() {
        return new ReplaySubject(new UnboundedReplayBuffer(16));
    }

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> ReplaySubject<T> aW(int capacityHint) {
        io.reactivex.rxjava3.internal.functions.a.e(capacityHint, "capacityHint");
        return new ReplaySubject(new UnboundedReplayBuffer(capacityHint));
    }

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> ReplaySubject<T> aX(int maxSize) {
        io.reactivex.rxjava3.internal.functions.a.e(maxSize, "maxSize");
        return new ReplaySubject(new SizeBoundReplayBuffer(maxSize));
    }

    static <T> ReplaySubject<T> sn() {
        return new ReplaySubject(new SizeBoundReplayBuffer(Integer.MAX_VALUE));
    }

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> ReplaySubject<T> Z(long maxAge, @e TimeUnit unit, @e ah scheduler) {
        io.reactivex.rxjava3.internal.functions.a.c(maxAge, "maxAge");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return new ReplaySubject(new SizeAndTimeBoundReplayBuffer(Integer.MAX_VALUE, maxAge, unit, scheduler));
    }

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> ReplaySubject<T> d(long maxAge, @e TimeUnit unit, @e ah scheduler, int maxSize) {
        io.reactivex.rxjava3.internal.functions.a.e(maxSize, "maxSize");
        io.reactivex.rxjava3.internal.functions.a.c(maxAge, "maxAge");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return new ReplaySubject(new SizeAndTimeBoundReplayBuffer(maxSize, maxAge, unit, scheduler));
    }

    ReplaySubject(a<T> buffer) {
        this.aCT = buffer;
        this.aCU = new AtomicReference<ReplayDisposable[]>(aCV);
    }

    @Override
    protected void d(ag<? super T> observer) {
        ReplayDisposable<? super T> rs = new ReplayDisposable<T>(observer, this);
        observer.onSubscribe(rs);
        if (this.a(rs) && rs.cancelled) {
            this.b(rs);
            return;
        }
        this.aCT.replay(rs);
    }

    @Override
    public void onSubscribe(b d2) {
        if (this.done) {
            d2.dispose();
        }
    }

    @Override
    public void onNext(T t2) {
        ExceptionHelper.e(t2, "onNext called with a null value.");
        if (this.done) {
            return;
        }
        a<T> b2 = this.aCT;
        b2.add(t2);
        for (ReplayDisposable<T> rs : this.aCU.get()) {
            b2.replay(rs);
        }
    }

    @Override
    public void onError(Throwable t2) {
        ExceptionHelper.e(t2, "onError called with a null Throwable.");
        if (this.done) {
            io.reactivex.rxjava3.d.a.onError(t2);
            return;
        }
        this.done = true;
        Object o2 = NotificationLite.error(t2);
        a<T> b2 = this.aCT;
        b2.addFinal(o2);
        for (ReplayDisposable<T> rs : this.bj(o2)) {
            b2.replay(rs);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Object o2 = NotificationLite.complete();
        a<T> b2 = this.aCT;
        b2.addFinal(o2);
        for (ReplayDisposable<T> rs : this.bj(o2)) {
            b2.replay(rs);
        }
    }

    @Override
    @io.reactivex.rxjava3.annotations.c
    public boolean ql() {
        return this.aCU.get().length != 0;
    }

    @io.reactivex.rxjava3.annotations.c
    int sj() {
        return this.aCU.get().length;
    }

    @Override
    @io.reactivex.rxjava3.annotations.c
    @f
    public Throwable bP() {
        Object o2 = this.aCT.get();
        if (NotificationLite.isError(o2)) {
            return NotificationLite.getError(o2);
        }
        return null;
    }

    @io.reactivex.rxjava3.annotations.c
    @f
    public T getValue() {
        return this.aCT.getValue();
    }

    public void rS() {
        this.aCT.trimHead();
    }

    @io.reactivex.rxjava3.annotations.c
    public Object[] getValues() {
        Object[] a2 = aCX;
        Object[] b2 = this.getValues(a2);
        if (b2 == aCX) {
            return new Object[0];
        }
        return b2;
    }

    @io.reactivex.rxjava3.annotations.c
    public T[] getValues(T[] array) {
        return this.aCT.getValues(array);
    }

    @Override
    @io.reactivex.rxjava3.annotations.c
    public boolean rI() {
        Object o2 = this.aCT.get();
        return NotificationLite.isComplete(o2);
    }

    @Override
    @io.reactivex.rxjava3.annotations.c
    public boolean rH() {
        Object o2 = this.aCT.get();
        return NotificationLite.isError(o2);
    }

    @io.reactivex.rxjava3.annotations.c
    public boolean rJ() {
        return this.aCT.size() != 0;
    }

    @io.reactivex.rxjava3.annotations.c
    int size() {
        return this.aCT.size();
    }

    boolean a(ReplayDisposable<T> rs) {
        ReplayDisposable[] b2;
        ReplayDisposable<T>[] a2;
        do {
            if ((a2 = this.aCU.get()) == aCW) {
                return false;
            }
            int len = a2.length;
            b2 = new ReplayDisposable[len + 1];
            System.arraycopy(a2, 0, b2, 0, len);
            b2[len] = rs;
        } while (!this.aCU.compareAndSet(a2, b2));
        return true;
    }

    void b(ReplayDisposable<T> rs) {
        ReplayDisposable[] b2;
        ReplayDisposable<T>[] a2;
        do {
            if ((a2 = this.aCU.get()) == aCW || a2 == aCV) {
                return;
            }
            int len = a2.length;
            int j2 = -1;
            for (int i2 = 0; i2 < len; ++i2) {
                if (a2[i2] != rs) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (len == 1) {
                b2 = aCV;
                continue;
            }
            b2 = new ReplayDisposable[len - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, len - j2 - 1);
        } while (!this.aCU.compareAndSet(a2, b2));
    }

    ReplayDisposable<T>[] bj(Object terminalValue) {
        this.aCT.compareAndSet(null, terminalValue);
        return this.aCU.getAndSet(aCW);
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends AtomicReference<Object>
    implements a<T> {
        private static final long serialVersionUID = -8056260896137901749L;
        final int maxSize;
        final long maxAge;
        final TimeUnit unit;
        final ah scheduler;
        int size;
        volatile TimedNode<Object> head;
        TimedNode<Object> tail;
        volatile boolean done;

        SizeAndTimeBoundReplayBuffer(int maxSize, long maxAge, TimeUnit unit, ah scheduler) {
            this.maxSize = maxSize;
            this.maxAge = maxAge;
            this.unit = unit;
            this.scheduler = scheduler;
            TimedNode<Object> h2 = new TimedNode<Object>(null, 0L);
            this.tail = h2;
            this.head = h2;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                TimedNode<Object> h2 = this.head;
                this.head = (TimedNode)h2.get();
            }
            long limit = this.scheduler.h(this.unit) - this.maxAge;
            TimedNode h3 = this.head;
            while (true) {
                if (this.size <= 1) {
                    this.head = h3;
                    break;
                }
                TimedNode next = (TimedNode)h3.get();
                if (next.time > limit) {
                    this.head = h3;
                    break;
                }
                h3 = next;
                --this.size;
            }
        }

        void trimFinal() {
            long limit = this.scheduler.h(this.unit) - this.maxAge;
            TimedNode h2 = this.head;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h2.get()).get() == null) {
                    if (h2.value != null) {
                        TimedNode<Object> lasth = new TimedNode<Object>(null, 0L);
                        lasth.lazySet(h2.get());
                        this.head = lasth;
                        break;
                    }
                    this.head = h2;
                    break;
                }
                if (next.time > limit) {
                    if (h2.value != null) {
                        TimedNode<Object> lasth = new TimedNode<Object>(null, 0L);
                        lasth.lazySet(h2.get());
                        this.head = lasth;
                        break;
                    }
                    this.head = h2;
                    break;
                }
                h2 = next;
            }
        }

        @Override
        public void add(T value) {
            TimedNode<T> n2 = new TimedNode<T>(value, this.scheduler.h(this.unit));
            TimedNode<Object> t2 = this.tail;
            this.tail = n2;
            ++this.size;
            t2.set(n2);
            this.trim();
        }

        @Override
        public void addFinal(Object notificationLite) {
            TimedNode<Object> n2 = new TimedNode<Object>(notificationLite, Long.MAX_VALUE);
            TimedNode<Object> t2 = this.tail;
            this.tail = n2;
            ++this.size;
            t2.lazySet(n2);
            this.trimFinal();
            this.done = true;
        }

        @Override
        public void trimHead() {
            TimedNode<Object> h2 = this.head;
            if (h2.value != null) {
                TimedNode<Object> n2 = new TimedNode<Object>(null, 0L);
                n2.lazySet(h2.get());
                this.head = n2;
            }
        }

        @Override
        @f
        public T getValue() {
            TimedNode next;
            TimedNode prev = null;
            TimedNode h2 = this.head;
            while ((next = (TimedNode)h2.get()) != null) {
                prev = h2;
                h2 = next;
            }
            long limit = this.scheduler.h(this.unit) - this.maxAge;
            if (h2.time < limit) {
                return null;
            }
            Object v2 = h2.value;
            if (v2 == null) {
                return null;
            }
            if (NotificationLite.isComplete(v2) || NotificationLite.isError(v2)) {
                return prev.value;
            }
            return v2;
        }

        TimedNode<Object> getHead() {
            long ts;
            TimedNode index = this.head;
            long limit = this.scheduler.h(this.unit) - this.maxAge;
            TimedNode next = (TimedNode)index.get();
            while (next != null && (ts = next.time) <= limit) {
                index = next;
                next = (TimedNode)index.get();
            }
            return index;
        }

        @Override
        public T[] getValues(T[] array) {
            TimedNode h2 = this.getHead();
            int s2 = this.size(h2);
            if (s2 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s2) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
                }
                for (int i2 = 0; i2 != s2; ++i2) {
                    TimedNode next = (TimedNode)h2.get();
                    array[i2] = next.value;
                    h2 = next;
                }
                if (array.length > s2) {
                    array[s2] = null;
                }
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            ag a2 = rs.downstream;
            TimedNode index = (TimedNode)rs.index;
            if (index == null) {
                index = this.getHead();
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                TimedNode n2 = (TimedNode)index.get();
                if (n2 != null) {
                    Object o2 = n2.value;
                    if (this.done && n2.get() == null) {
                        if (NotificationLite.isComplete(o2)) {
                            a2.onComplete();
                        } else {
                            a2.onError(NotificationLite.getError(o2));
                        }
                        rs.index = null;
                        rs.cancelled = true;
                        return;
                    }
                    a2.onNext(o2);
                    index = n2;
                    continue;
                }
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            return this.size(this.getHead());
        }

        int size(TimedNode<Object> h2) {
            int s2;
            for (s2 = 0; s2 != Integer.MAX_VALUE; ++s2) {
                TimedNode next = (TimedNode)h2.get();
                if (next == null) {
                    Object o2 = h2.value;
                    if (!NotificationLite.isComplete(o2) && !NotificationLite.isError(o2)) break;
                    --s2;
                    break;
                }
                h2 = next;
            }
            return s2;
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends AtomicReference<Object>
    implements a<T> {
        private static final long serialVersionUID = 1107649250281456395L;
        final int maxSize;
        int size;
        volatile Node<Object> head;
        Node<Object> tail;
        volatile boolean done;

        SizeBoundReplayBuffer(int maxSize) {
            this.maxSize = maxSize;
            Node<Object> h2 = new Node<Object>(null);
            this.tail = h2;
            this.head = h2;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                Node<Object> h2 = this.head;
                this.head = (Node)h2.get();
            }
        }

        @Override
        public void add(T value) {
            Node<T> n2 = new Node<T>(value);
            Node<Object> t2 = this.tail;
            this.tail = n2;
            ++this.size;
            t2.set(n2);
            this.trim();
        }

        @Override
        public void addFinal(Object notificationLite) {
            Node<Object> n2 = new Node<Object>(notificationLite);
            Node<Object> t2 = this.tail;
            this.tail = n2;
            ++this.size;
            t2.lazySet(n2);
            this.trimHead();
            this.done = true;
        }

        @Override
        public void trimHead() {
            Node<Object> h2 = this.head;
            if (h2.value != null) {
                Node<Object> n2 = new Node<Object>(null);
                n2.lazySet(h2.get());
                this.head = n2;
            }
        }

        @Override
        @f
        public T getValue() {
            Node next;
            Node prev = null;
            Node h2 = this.head;
            while ((next = (Node)h2.get()) != null) {
                prev = h2;
                h2 = next;
            }
            Object v2 = h2.value;
            if (v2 == null) {
                return null;
            }
            if (NotificationLite.isComplete(v2) || NotificationLite.isError(v2)) {
                return prev.value;
            }
            return v2;
        }

        @Override
        public T[] getValues(T[] array) {
            Node h2 = this.head;
            int s2 = this.size();
            if (s2 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s2) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
                }
                for (int i2 = 0; i2 != s2; ++i2) {
                    Node next = (Node)h2.get();
                    array[i2] = next.value;
                    h2 = next;
                }
                if (array.length > s2) {
                    array[s2] = null;
                }
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            ag a2 = rs.downstream;
            Node index = (Node)rs.index;
            if (index == null) {
                index = this.head;
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                Node n2 = (Node)index.get();
                if (n2 != null) {
                    Object o2 = n2.value;
                    if (this.done && n2.get() == null) {
                        if (NotificationLite.isComplete(o2)) {
                            a2.onComplete();
                        } else {
                            a2.onError(NotificationLite.getError(o2));
                        }
                        rs.index = null;
                        rs.cancelled = true;
                        return;
                    }
                    a2.onNext(o2);
                    index = n2;
                    continue;
                }
                if (index.get() != null) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            int s2;
            Node h2 = this.head;
            for (s2 = 0; s2 != Integer.MAX_VALUE; ++s2) {
                Node next = (Node)h2.get();
                if (next == null) {
                    Object o2 = h2.value;
                    if (!NotificationLite.isComplete(o2) && !NotificationLite.isError(o2)) break;
                    --s2;
                    break;
                }
                h2 = next;
            }
            return s2;
        }
    }

    static final class TimedNode<T>
    extends AtomicReference<TimedNode<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;
        final long time;

        TimedNode(T value, long time) {
            this.value = value;
            this.time = time;
        }
    }

    static final class Node<T>
    extends AtomicReference<Node<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;

        Node(T value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends AtomicReference<Object>
    implements a<T> {
        private static final long serialVersionUID = -733876083048047795L;
        final List<Object> buffer;
        volatile boolean done;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            this.buffer = new ArrayList<Object>(capacityHint);
        }

        @Override
        public void add(T value) {
            this.buffer.add(value);
            ++this.size;
        }

        @Override
        public void addFinal(Object notificationLite) {
            this.buffer.add(notificationLite);
            this.trimHead();
            ++this.size;
            this.done = true;
        }

        @Override
        public void trimHead() {
        }

        @Override
        @f
        public T getValue() {
            int s2 = this.size;
            if (s2 != 0) {
                List<Object> b2 = this.buffer;
                Object o2 = b2.get(s2 - 1);
                if (NotificationLite.isComplete(o2) || NotificationLite.isError(o2)) {
                    if (s2 == 1) {
                        return null;
                    }
                    return (T)b2.get(s2 - 2);
                }
                return (T)o2;
            }
            return null;
        }

        @Override
        public T[] getValues(T[] array) {
            int s2 = this.size;
            if (s2 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            List<Object> b2 = this.buffer;
            Object o2 = b2.get(s2 - 1);
            if ((NotificationLite.isComplete(o2) || NotificationLite.isError(o2)) && --s2 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            if (array.length < s2) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
            }
            for (int i2 = 0; i2 < s2; ++i2) {
                array[i2] = b2.get(i2);
            }
            if (array.length > s2) {
                array[s2] = null;
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs) {
            int index;
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            List<Object> b2 = this.buffer;
            ag<Object> a2 = rs.downstream;
            Integer indexObject = (Integer)rs.index;
            if (indexObject != null) {
                index = indexObject;
            } else {
                index = 0;
                rs.index = 0;
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                int s2 = this.size;
                while (s2 != index) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    Object o2 = b2.get(index);
                    if (this.done && index + 1 == s2 && index + 1 == (s2 = this.size)) {
                        if (NotificationLite.isComplete(o2)) {
                            a2.onComplete();
                        } else {
                            a2.onError(NotificationLite.getError(o2));
                        }
                        rs.index = null;
                        rs.cancelled = true;
                        return;
                    }
                    a2.onNext(o2);
                    ++index;
                }
                if (index != this.size) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            int s2 = this.size;
            if (s2 != 0) {
                Object o2 = this.buffer.get(s2 - 1);
                if (NotificationLite.isComplete(o2) || NotificationLite.isError(o2)) {
                    return s2 - 1;
                }
                return s2;
            }
            return 0;
        }
    }

    static final class ReplayDisposable<T>
    extends AtomicInteger
    implements b {
        private static final long serialVersionUID = 466549804534799122L;
        final ag<? super T> downstream;
        final ReplaySubject<T> state;
        Object index;
        volatile boolean cancelled;

        ReplayDisposable(ag<? super T> actual, ReplaySubject<T> state) {
            this.downstream = actual;
            this.state = state;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.b(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }
    }

    static interface a<T> {
        public void add(T var1);

        public void addFinal(Object var1);

        public void replay(ReplayDisposable<T> var1);

        public int size();

        @f
        public T getValue();

        public T[] getValues(T[] var1);

        public Object get();

        public boolean compareAndSet(Object var1, Object var2);

        public void trimHead();
    }
}

