/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subjects;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.observers.BasicIntQueueDisposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.g;
import io.reactivex.rxjava3.operators.h;
import io.reactivex.rxjava3.subjects.c;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class UnicastSubject<T>
extends c<T> {
    final h<T> aDd;
    final AtomicReference<ag<? super T>> aDe;
    final AtomicReference<Runnable> aDf;
    final boolean aDg;
    volatile boolean disposed;
    volatile boolean done;
    Throwable error;
    final AtomicBoolean aDh;
    final BasicIntQueueDisposable<T> aDi;
    boolean aCb;

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> UnicastSubject<T> sq() {
        return new UnicastSubject<T>(UnicastSubject.mB(), null, true);
    }

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> UnicastSubject<T> aY(int capacityHint) {
        io.reactivex.rxjava3.internal.functions.a.e(capacityHint, "capacityHint");
        return new UnicastSubject<T>(capacityHint, null, true);
    }

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> UnicastSubject<T> b(int capacityHint, @e Runnable onTerminate) {
        io.reactivex.rxjava3.internal.functions.a.e(capacityHint, "capacityHint");
        Objects.requireNonNull(onTerminate, "onTerminate");
        return new UnicastSubject<T>(capacityHint, onTerminate, true);
    }

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> UnicastSubject<T> b(int capacityHint, @e Runnable onTerminate, boolean delayError) {
        io.reactivex.rxjava3.internal.functions.a.e(capacityHint, "capacityHint");
        Objects.requireNonNull(onTerminate, "onTerminate");
        return new UnicastSubject<T>(capacityHint, onTerminate, delayError);
    }

    @io.reactivex.rxjava3.annotations.c
    @e
    public static <T> UnicastSubject<T> Y(boolean delayError) {
        return new UnicastSubject<T>(UnicastSubject.mB(), null, delayError);
    }

    UnicastSubject(int capacityHint, Runnable onTerminate, boolean delayError) {
        this.aDd = new h(capacityHint);
        this.aDf = new AtomicReference<Runnable>(onTerminate);
        this.aDg = delayError;
        this.aDe = new AtomicReference();
        this.aDh = new AtomicBoolean();
        this.aDi = new UnicastQueueDisposable();
    }

    @Override
    protected void d(ag<? super T> observer) {
        if (!this.aDh.get() && this.aDh.compareAndSet(false, true)) {
            observer.onSubscribe(this.aDi);
            this.aDe.lazySet(observer);
            if (this.disposed) {
                this.aDe.lazySet(null);
                return;
            }
            this.drain();
        } else {
            EmptyDisposable.error((Throwable)new IllegalStateException("Only a single observer allowed."), observer);
        }
    }

    void rV() {
        Runnable r2 = this.aDf.get();
        if (r2 != null && this.aDf.compareAndSet(r2, null)) {
            r2.run();
        }
    }

    @Override
    public void onSubscribe(b d2) {
        if (this.done || this.disposed) {
            d2.dispose();
        }
    }

    @Override
    public void onNext(T t2) {
        ExceptionHelper.e(t2, "onNext called with a null value.");
        if (this.done || this.disposed) {
            return;
        }
        this.aDd.offer(t2);
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        ExceptionHelper.e(t2, "onError called with a null Throwable.");
        if (this.done || this.disposed) {
            a.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        this.rV();
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.done || this.disposed) {
            return;
        }
        this.done = true;
        this.rV();
        this.drain();
    }

    void n(ag<? super T> a2) {
        int missed = 1;
        h<T> q2 = this.aDd;
        boolean failFast = !this.aDg;
        boolean canBeError = true;
        while (true) {
            boolean empty;
            if (this.disposed) {
                this.aDe.lazySet(null);
                q2.clear();
                return;
            }
            boolean d2 = this.done;
            T v2 = this.aDd.poll();
            boolean bl2 = empty = v2 == null;
            if (d2) {
                if (failFast && canBeError) {
                    if (this.a(q2, a2)) {
                        return;
                    }
                    canBeError = false;
                }
                if (empty) {
                    this.p(a2);
                    return;
                }
            }
            if (!empty) {
                a2.onNext(v2);
                continue;
            }
            if ((missed = this.aDi.addAndGet(-missed)) == 0) break;
        }
    }

    void o(ag<? super T> a2) {
        boolean failFast;
        int missed = 1;
        h<T> q2 = this.aDd;
        boolean bl2 = failFast = !this.aDg;
        do {
            if (this.disposed) {
                this.aDe.lazySet(null);
                return;
            }
            boolean d2 = this.done;
            if (failFast && d2 && this.a(q2, a2)) {
                return;
            }
            a2.onNext(null);
            if (!d2) continue;
            this.p(a2);
            return;
        } while ((missed = this.aDi.addAndGet(-missed)) != 0);
    }

    void p(ag<? super T> a2) {
        this.aDe.lazySet(null);
        Throwable ex = this.error;
        if (ex != null) {
            a2.onError(ex);
        } else {
            a2.onComplete();
        }
    }

    boolean a(g<T> q2, ag<? super T> a2) {
        Throwable ex = this.error;
        if (ex != null) {
            this.aDe.lazySet(null);
            q2.clear();
            a2.onError(ex);
            return true;
        }
        return false;
    }

    void drain() {
        if (this.aDi.getAndIncrement() != 0) {
            return;
        }
        ag<? super T> a2 = this.aDe.get();
        int missed = 1;
        while (true) {
            if (a2 != null) {
                if (this.aCb) {
                    this.o(a2);
                } else {
                    this.n(a2);
                }
                return;
            }
            if ((missed = this.aDi.addAndGet(-missed)) == 0) break;
            a2 = this.aDe.get();
        }
    }

    @Override
    @io.reactivex.rxjava3.annotations.c
    public boolean ql() {
        return this.aDe.get() != null;
    }

    @Override
    @io.reactivex.rxjava3.annotations.c
    @f
    public Throwable bP() {
        if (this.done) {
            return this.error;
        }
        return null;
    }

    @Override
    @io.reactivex.rxjava3.annotations.c
    public boolean rH() {
        return this.done && this.error != null;
    }

    @Override
    @io.reactivex.rxjava3.annotations.c
    public boolean rI() {
        return this.done && this.error == null;
    }

    final class UnicastQueueDisposable
    extends BasicIntQueueDisposable<T> {
        private static final long serialVersionUID = 7926949470189395511L;

        UnicastQueueDisposable() {
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                UnicastSubject.this.aCb = true;
                return 2;
            }
            return 0;
        }

        @Override
        @f
        public T poll() {
            return UnicastSubject.this.aDd.poll();
        }

        @Override
        public boolean isEmpty() {
            return UnicastSubject.this.aDd.isEmpty();
        }

        @Override
        public void clear() {
            UnicastSubject.this.aDd.clear();
        }

        @Override
        public void dispose() {
            if (!UnicastSubject.this.disposed) {
                UnicastSubject.this.disposed = true;
                UnicastSubject.this.rV();
                UnicastSubject.this.aDe.lazySet(null);
                if (UnicastSubject.this.aDi.getAndIncrement() == 0) {
                    UnicastSubject.this.aDe.lazySet(null);
                    if (!UnicastSubject.this.aCb) {
                        UnicastSubject.this.aDd.clear();
                    }
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return UnicastSubject.this.disposed;
        }
    }
}

