/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1TaggedObjectParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;

class DLTaggedObjectParser
extends BERTaggedObjectParser {
    private final boolean _constructed;

    DLTaggedObjectParser(int n2, int n3, boolean bl2, ASN1StreamParser aSN1StreamParser) {
        super(n2, n3, aSN1StreamParser);
        this._constructed = bl2;
    }

    @Override
    public ASN1Primitive getLoadedObject() throws IOException {
        return this._parser.loadTaggedDL(this._tagClass, this._tagNo, this._constructed);
    }

    @Override
    public ASN1Encodable parseBaseUniversal(boolean bl2, int n2) throws IOException {
        if (bl2) {
            if (!this._constructed) {
                throw new IOException("Explicit tags must be constructed (see X.690 8.14.2)");
            }
            return this._parser.parseObject(n2);
        }
        return this._constructed ? this._parser.parseImplicitConstructedDL(n2) : this._parser.parseImplicitPrimitive(n2);
    }

    @Override
    public ASN1Encodable parseExplicitBaseObject() throws IOException {
        if (!this._constructed) {
            throw new IOException("Explicit tags must be constructed (see X.690 8.14.2)");
        }
        return this._parser.readObject();
    }

    @Override
    public ASN1TaggedObjectParser parseExplicitBaseTagged() throws IOException {
        if (!this._constructed) {
            throw new IOException("Explicit tags must be constructed (see X.690 8.14.2)");
        }
        return this._parser.parseTaggedObject();
    }

    @Override
    public ASN1TaggedObjectParser parseImplicitBaseTagged(int n2, int n3) throws IOException {
        return new DLTaggedObjectParser(n2, n3, this._constructed, this._parser);
    }
}

