/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private byte[] defHash;
    private Digest mgf1Hash;
    private AsymmetricBlockCipher engine;
    private SecureRandom random;
    private boolean forEncryption;

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this(asymmetricBlockCipher, DigestFactory.createSHA1(), null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, byte[] byArray) {
        this(asymmetricBlockCipher, digest, digest, byArray);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray) {
        this.engine = asymmetricBlockCipher;
        this.mgf1Hash = digest2;
        this.defHash = new byte[digest.getDigestSize()];
        digest.reset();
        if (byArray != null) {
            digest.update(byArray, 0, byArray.length);
        }
        digest.doFinal(this.defHash, 0);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
        } else {
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
        this.engine.init(bl2, cipherParameters);
        this.forEncryption = bl2;
    }

    @Override
    public int getInputBlockSize() {
        int n2 = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return n2 - 1 - 2 * this.defHash.length;
        }
        return n2;
    }

    @Override
    public int getOutputBlockSize() {
        int n2 = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n2;
        }
        return n2 - 1 - 2 * this.defHash.length;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n2, n3);
        }
        return this.decodeBlock(byArray, n2, n3);
    }

    public byte[] encodeBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        if (n3 > this.getInputBlockSize()) {
            throw new DataLengthException("input data too long");
        }
        byte[] byArray2 = new byte[this.getInputBlockSize() + 1 + 2 * this.defHash.length];
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        byArray2[byArray2.length - n3 - 1] = 1;
        System.arraycopy(this.defHash, 0, byArray2, this.defHash.length, this.defHash.length);
        byte[] byArray3 = new byte[this.defHash.length];
        this.random.nextBytes(byArray3);
        byte[] byArray4 = this.maskGeneratorFunction1(byArray3, 0, byArray3.length, byArray2.length - this.defHash.length);
        for (n4 = this.defHash.length; n4 != byArray2.length; ++n4) {
            int n5 = n4;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray4[n4 - this.defHash.length]);
        }
        System.arraycopy(byArray3, 0, byArray2, 0, this.defHash.length);
        byArray4 = this.maskGeneratorFunction1(byArray2, this.defHash.length, byArray2.length - this.defHash.length, this.defHash.length);
        for (n4 = 0; n4 != this.defHash.length; ++n4) {
            int n6 = n4;
            byArray2[n6] = (byte)(byArray2[n6] ^ byArray4[n4]);
        }
        return this.engine.processBlock(byArray2, 0, byArray2.length);
    }

    public byte[] decodeBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        byte[] byArray2 = this.engine.processBlock(byArray, n2, n3);
        byte[] byArray3 = new byte[this.engine.getOutputBlockSize()];
        int n5 = byArray3.length - (2 * this.defHash.length + 1) >> 31;
        if (byArray2.length <= byArray3.length) {
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        } else {
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            n5 |= 1;
        }
        byte[] byArray4 = this.maskGeneratorFunction1(byArray3, this.defHash.length, byArray3.length - this.defHash.length, this.defHash.length);
        for (n4 = 0; n4 != this.defHash.length; ++n4) {
            int n6 = n4;
            byArray3[n6] = (byte)(byArray3[n6] ^ byArray4[n4]);
        }
        byArray4 = this.maskGeneratorFunction1(byArray3, 0, this.defHash.length, byArray3.length - this.defHash.length);
        for (n4 = this.defHash.length; n4 != byArray3.length; ++n4) {
            int n7 = n4;
            byArray3[n7] = (byte)(byArray3[n7] ^ byArray4[n4 - this.defHash.length]);
        }
        for (n4 = 0; n4 != this.defHash.length; ++n4) {
            n5 |= this.defHash[n4] ^ byArray3[this.defHash.length + n4];
        }
        n4 = -1;
        for (int i2 = 2 * this.defHash.length; i2 != byArray3.length; ++i2) {
            int n8 = byArray3[i2] & 0xFF;
            int n9 = (-n8 & n4) >> 31;
            n4 += i2 & n9;
        }
        n5 |= n4 >> 31;
        if ((n5 |= byArray3[++n4] ^ 1) != 0) {
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("data wrong");
        }
        byte[] byArray5 = new byte[byArray3.length - ++n4];
        System.arraycopy(byArray3, n4, byArray5, 0, byArray5.length);
        Arrays.fill(byArray3, (byte)0);
        return byArray5;
    }

    private byte[] maskGeneratorFunction1(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[this.mgf1Hash.getDigestSize()];
        byte[] byArray4 = new byte[4];
        this.mgf1Hash.reset();
        for (n5 = 0; n5 < n4 / byArray3.length; ++n5) {
            Pack.intToBigEndian(n5, byArray4, 0);
            this.mgf1Hash.update(byArray, n2, n3);
            this.mgf1Hash.update(byArray4, 0, byArray4.length);
            this.mgf1Hash.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * byArray3.length, byArray3.length);
        }
        if (n5 * byArray3.length < n4) {
            Pack.intToBigEndian(n5, byArray4, 0);
            this.mgf1Hash.update(byArray, n2, n3);
            this.mgf1Hash.update(byArray4, 0, byArray4.length);
            this.mgf1Hash.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * byArray3.length, byArray2.length - n5 * byArray3.length);
        }
        return byArray2;
    }
}

