/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntru;

import org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.pqc.crypto.ntru.NTRUOWCPA;
import org.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.OWCPADecryptResult;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;
import org.bouncycastle.util.Arrays;

public class NTRUKEMExtractor
implements EncapsulatedSecretExtractor {
    private final NTRUParameters params;
    private final NTRUPrivateKeyParameters ntruPrivateKey;

    public NTRUKEMExtractor(NTRUPrivateKeyParameters nTRUPrivateKeyParameters) {
        this.params = nTRUPrivateKeyParameters.getParameters();
        this.ntruPrivateKey = nTRUPrivateKeyParameters;
    }

    @Override
    public byte[] extractSecret(byte[] byArray) {
        int n2;
        NTRUParameterSet nTRUParameterSet = this.params.parameterSet;
        byte[] byArray2 = this.ntruPrivateKey.privateKey;
        byte[] byArray3 = new byte[nTRUParameterSet.prfKeyBytes() + nTRUParameterSet.ntruCiphertextBytes()];
        NTRUOWCPA nTRUOWCPA = new NTRUOWCPA(nTRUParameterSet);
        OWCPADecryptResult oWCPADecryptResult = nTRUOWCPA.decrypt(byArray, this.ntruPrivateKey.privateKey);
        byte[] byArray4 = oWCPADecryptResult.rm;
        int n3 = oWCPADecryptResult.fail;
        SHA3Digest sHA3Digest = new SHA3Digest(256);
        byte[] byArray5 = new byte[sHA3Digest.getDigestSize()];
        sHA3Digest.update(byArray4, 0, byArray4.length);
        sHA3Digest.doFinal(byArray5, 0);
        for (n2 = 0; n2 < nTRUParameterSet.prfKeyBytes(); ++n2) {
            byArray3[n2] = byArray2[n2 + nTRUParameterSet.owcpaSecretKeyBytes()];
        }
        for (n2 = 0; n2 < nTRUParameterSet.ntruCiphertextBytes(); ++n2) {
            byArray3[nTRUParameterSet.prfKeyBytes() + n2] = byArray[n2];
        }
        sHA3Digest.reset();
        sHA3Digest.update(byArray3, 0, byArray3.length);
        sHA3Digest.doFinal(byArray4, 0);
        this.cmov(byArray5, byArray4, (byte)n3);
        byte[] byArray6 = Arrays.copyOfRange(byArray5, 0, nTRUParameterSet.sharedKeyBytes());
        Arrays.clear(byArray5);
        return byArray6;
    }

    private void cmov(byte[] byArray, byte[] byArray2, byte by2) {
        by2 = (byte)(~by2 + 1);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = i2;
            byArray[n2] = (byte)(byArray[n2] ^ by2 & (byArray2[i2] ^ byArray[i2]));
        }
    }

    @Override
    public int getEncapsulationLength() {
        return this.params.parameterSet.ntruCiphertextBytes();
    }
}

