/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.ntru;

import org.bouncycastle.pqc.math.ntru.Polynomial;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUHRSSParameterSet;

public class HRSSPolynomial
extends Polynomial {
    public HRSSPolynomial(NTRUHRSSParameterSet nTRUHRSSParameterSet) {
        super(nTRUHRSSParameterSet);
    }

    @Override
    public byte[] sqToBytes(int n2) {
        int n3;
        int n4;
        byte[] byArray = new byte[n2];
        short[] sArray = new short[8];
        for (n4 = 0; n4 < this.params.packDegree() / 8; ++n4) {
            for (n3 = 0; n3 < 8; ++n3) {
                sArray[n3] = (short)HRSSPolynomial.modQ(this.coeffs[8 * n4 + n3] & 0xFFFF, this.params.q());
            }
            byArray[13 * n4 + 0] = (byte)(sArray[0] & 0xFF);
            byArray[13 * n4 + 1] = (byte)(sArray[0] >>> 8 | (sArray[1] & 7) << 5);
            byArray[13 * n4 + 2] = (byte)(sArray[1] >>> 3 & 0xFF);
            byArray[13 * n4 + 3] = (byte)(sArray[1] >>> 11 | (sArray[2] & 0x3F) << 2);
            byArray[13 * n4 + 4] = (byte)(sArray[2] >>> 6 | (sArray[3] & 1) << 7);
            byArray[13 * n4 + 5] = (byte)(sArray[3] >>> 1 & 0xFF);
            byArray[13 * n4 + 6] = (byte)(sArray[3] >>> 9 | (sArray[4] & 0xF) << 4);
            byArray[13 * n4 + 7] = (byte)(sArray[4] >>> 4 & 0xFF);
            byArray[13 * n4 + 8] = (byte)(sArray[4] >>> 12 | (sArray[5] & 0x7F) << 1);
            byArray[13 * n4 + 9] = (byte)(sArray[5] >>> 7 | (sArray[6] & 3) << 6);
            byArray[13 * n4 + 10] = (byte)(sArray[6] >>> 2 & 0xFF);
            byArray[13 * n4 + 11] = (byte)(sArray[6] >>> 10 | (sArray[7] & 0x1F) << 3);
            byArray[13 * n4 + 12] = (byte)(sArray[7] >>> 5);
        }
        for (n3 = 0; n3 < this.params.packDegree() - 8 * n4; ++n3) {
            sArray[n3] = (short)HRSSPolynomial.modQ(this.coeffs[8 * n4 + n3] & 0xFFFF, this.params.q());
        }
        while (n3 < 8) {
            sArray[n3] = 0;
            ++n3;
        }
        switch (this.params.packDegree() - 8 * (this.params.packDegree() / 8)) {
            case 4: {
                byArray[13 * n4 + 0] = (byte)(sArray[0] & 0xFF);
                byArray[13 * n4 + 1] = (byte)(sArray[0] >>> 8 | (sArray[1] & 7) << 5);
                byArray[13 * n4 + 2] = (byte)(sArray[1] >>> 3 & 0xFF);
                byArray[13 * n4 + 3] = (byte)(sArray[1] >>> 11 | (sArray[2] & 0x3F) << 2);
                byArray[13 * n4 + 4] = (byte)(sArray[2] >>> 6 | (sArray[3] & 1) << 7);
                byArray[13 * n4 + 5] = (byte)(sArray[3] >>> 1 & 0xFF);
                byArray[13 * n4 + 6] = (byte)(sArray[3] >>> 9 | (sArray[4] & 0xF) << 4);
            }
            case 2: {
                byArray[13 * n4 + 0] = (byte)(sArray[0] & 0xFF);
                byArray[13 * n4 + 1] = (byte)(sArray[0] >>> 8 | (sArray[1] & 7) << 5);
                byArray[13 * n4 + 2] = (byte)(sArray[1] >>> 3 & 0xFF);
                byArray[13 * n4 + 3] = (byte)(sArray[1] >>> 11 | (sArray[2] & 0x3F) << 2);
            }
        }
        return byArray;
    }

    @Override
    public void sqFromBytes(byte[] byArray) {
        int n2;
        for (n2 = 0; n2 < this.params.packDegree() / 8; ++n2) {
            this.coeffs[8 * n2 + 0] = (short)(byArray[13 * n2 + 0] & 0xFF | ((short)(byArray[13 * n2 + 1] & 0xFF) & 0x1F) << 8);
            this.coeffs[8 * n2 + 1] = (short)((byArray[13 * n2 + 1] & 0xFF) >>> 5 | (short)(byArray[13 * n2 + 2] & 0xFF) << 3 | ((short)(byArray[13 * n2 + 3] & 0xFF) & 3) << 11);
            this.coeffs[8 * n2 + 2] = (short)((byArray[13 * n2 + 3] & 0xFF) >>> 2 | ((short)(byArray[13 * n2 + 4] & 0xFF) & 0x7F) << 6);
            this.coeffs[8 * n2 + 3] = (short)((byArray[13 * n2 + 4] & 0xFF) >>> 7 | (short)(byArray[13 * n2 + 5] & 0xFF) << 1 | ((short)(byArray[13 * n2 + 6] & 0xFF) & 0xF) << 9);
            this.coeffs[8 * n2 + 4] = (short)((byArray[13 * n2 + 6] & 0xFF) >>> 4 | (short)(byArray[13 * n2 + 7] & 0xFF) << 4 | ((short)(byArray[13 * n2 + 8] & 0xFF) & 1) << 12);
            this.coeffs[8 * n2 + 5] = (short)((byArray[13 * n2 + 8] & 0xFF) >>> 1 | ((short)(byArray[13 * n2 + 9] & 0xFF) & 0x3F) << 7);
            this.coeffs[8 * n2 + 6] = (short)((byArray[13 * n2 + 9] & 0xFF) >>> 6 | (short)(byArray[13 * n2 + 10] & 0xFF) << 2 | ((short)(byArray[13 * n2 + 11] & 0xFF) & 7) << 10);
            this.coeffs[8 * n2 + 7] = (short)((byArray[13 * n2 + 11] & 0xFF) >>> 3 | (short)(byArray[13 * n2 + 12] & 0xFF) << 5);
        }
        switch (this.params.packDegree() & 7) {
            case 4: {
                this.coeffs[8 * n2 + 0] = (short)(byArray[13 * n2 + 0] & 0xFF | ((short)(byArray[13 * n2 + 1] & 0xFF) & 0x1F) << 8);
                this.coeffs[8 * n2 + 1] = (short)((byArray[13 * n2 + 1] & 0xFF) >>> 5 | (short)(byArray[13 * n2 + 2] & 0xFF) << 3 | ((short)(byArray[13 * n2 + 3] & 0xFF) & 3) << 11);
                this.coeffs[8 * n2 + 2] = (short)((byArray[13 * n2 + 3] & 0xFF) >>> 2 | ((short)(byArray[13 * n2 + 4] & 0xFF) & 0x7F) << 6);
                this.coeffs[8 * n2 + 3] = (short)((byArray[13 * n2 + 4] & 0xFF) >>> 7 | (short)(byArray[13 * n2 + 5] & 0xFF) << 1 | ((short)(byArray[13 * n2 + 6] & 0xFF) & 0xF) << 9);
                break;
            }
            case 2: {
                this.coeffs[8 * n2 + 0] = (short)(byArray[13 * n2 + 0] & 0xFF | ((short)(byArray[13 * n2 + 1] & 0xFF) & 0x1F) << 8);
                this.coeffs[8 * n2 + 1] = (short)((byArray[13 * n2 + 1] & 0xFF) >>> 5 | (short)(byArray[13 * n2 + 2] & 0xFF) << 3 | ((short)(byArray[13 * n2 + 3] & 0xFF) & 3) << 11);
            }
        }
        this.coeffs[this.params.n() - 1] = 0;
    }

    @Override
    public void lift(Polynomial polynomial) {
        int n2;
        int n3 = this.coeffs.length;
        HRSSPolynomial hRSSPolynomial = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        short s2 = (short)(3 - n3 % 3);
        hRSSPolynomial.coeffs[0] = (short)(polynomial.coeffs[0] * (2 - s2) + polynomial.coeffs[1] * 0 + polynomial.coeffs[2] * s2);
        hRSSPolynomial.coeffs[1] = (short)(polynomial.coeffs[1] * (2 - s2) + polynomial.coeffs[2] * 0);
        hRSSPolynomial.coeffs[2] = (short)(polynomial.coeffs[2] * (2 - s2));
        short s3 = 0;
        for (n2 = 3; n2 < n3; ++n2) {
            hRSSPolynomial.coeffs[0] = (short)(hRSSPolynomial.coeffs[0] + polynomial.coeffs[n2] * (s3 + 2 * s2));
            hRSSPolynomial.coeffs[1] = (short)(hRSSPolynomial.coeffs[1] + polynomial.coeffs[n2] * (s3 + s2));
            hRSSPolynomial.coeffs[2] = (short)(hRSSPolynomial.coeffs[2] + polynomial.coeffs[n2] * s3);
            s3 = (short)((s3 + s2) % 3);
        }
        hRSSPolynomial.coeffs[1] = (short)(hRSSPolynomial.coeffs[1] + polynomial.coeffs[0] * (s3 + s2));
        hRSSPolynomial.coeffs[2] = (short)(hRSSPolynomial.coeffs[2] + polynomial.coeffs[0] * s3);
        hRSSPolynomial.coeffs[2] = (short)(hRSSPolynomial.coeffs[2] + polynomial.coeffs[1] * (s3 + s2));
        for (n2 = 3; n2 < n3; ++n2) {
            hRSSPolynomial.coeffs[n2] = (short)(hRSSPolynomial.coeffs[n2 - 3] + 2 * (polynomial.coeffs[n2] + polynomial.coeffs[n2 - 1] + polynomial.coeffs[n2 - 2]));
        }
        hRSSPolynomial.mod3PhiN();
        hRSSPolynomial.z3ToZq();
        this.coeffs[0] = -hRSSPolynomial.coeffs[0];
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            this.coeffs[n2 + 1] = (short)(hRSSPolynomial.coeffs[n2] - hRSSPolynomial.coeffs[n2 + 1]);
        }
    }

    @Override
    public void r2Inv(Polynomial polynomial) {
        HRSSPolynomial hRSSPolynomial = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        HRSSPolynomial hRSSPolynomial2 = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        HRSSPolynomial hRSSPolynomial3 = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        HRSSPolynomial hRSSPolynomial4 = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        this.r2Inv(polynomial, hRSSPolynomial, hRSSPolynomial2, hRSSPolynomial3, hRSSPolynomial4);
    }

    @Override
    public void rqInv(Polynomial polynomial) {
        HRSSPolynomial hRSSPolynomial = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        HRSSPolynomial hRSSPolynomial2 = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        HRSSPolynomial hRSSPolynomial3 = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        HRSSPolynomial hRSSPolynomial4 = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        this.rqInv(polynomial, hRSSPolynomial, hRSSPolynomial2, hRSSPolynomial3, hRSSPolynomial4);
    }

    @Override
    public void s3Inv(Polynomial polynomial) {
        HRSSPolynomial hRSSPolynomial = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        HRSSPolynomial hRSSPolynomial2 = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        HRSSPolynomial hRSSPolynomial3 = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        HRSSPolynomial hRSSPolynomial4 = new HRSSPolynomial((NTRUHRSSParameterSet)this.params);
        this.s3Inv(polynomial, hRSSPolynomial, hRSSPolynomial2, hRSSPolynomial3, hRSSPolynomial4);
    }
}

