/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.math.BigInteger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.bouncycastle.util.Strings;

public class Properties {
    public static final String EMULATE_ORACLE = "org.bouncycastle.emulate.oracle";
    private static final ThreadLocal threadProperties = new ThreadLocal();

    private Properties() {
    }

    public static boolean isOverrideSet(String string) {
        try {
            return Properties.isSetTrue(Properties.getPropertyValue(string));
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static boolean isOverrideSetTo(String string, boolean bl2) {
        try {
            String string2 = Properties.getPropertyValue(string);
            if (bl2) {
                return Properties.isSetTrue(string2);
            }
            return Properties.isSetFalse(string2);
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static boolean setThreadOverride(String string, boolean bl2) {
        boolean bl3 = Properties.isOverrideSet(string);
        HashMap<String, String> hashMap = (HashMap<String, String>)threadProperties.get();
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            threadProperties.set(hashMap);
        }
        hashMap.put(string, bl2 ? "true" : "false");
        return bl3;
    }

    public static boolean removeThreadOverride(String string) {
        String string2;
        Map map = (Map)threadProperties.get();
        if (map != null && (string2 = (String)map.remove(string)) != null) {
            if (map.isEmpty()) {
                threadProperties.remove();
            }
            return "true".equals(Strings.toLowerCase(string2));
        }
        return false;
    }

    public static int asInteger(String string, int n2) {
        String string2 = Properties.getPropertyValue(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return n2;
    }

    public static BigInteger asBigInteger(String string) {
        String string2 = Properties.getPropertyValue(string);
        if (string2 != null) {
            return new BigInteger(string2);
        }
        return null;
    }

    public static Set<String> asKeySet(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = Properties.getPropertyValue(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreElements()) {
                hashSet.add(Strings.toLowerCase(stringTokenizer.nextToken()).trim());
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static String getPropertyValue(final String string) {
        String string2;
        String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(string);
            }
        });
        if (string3 != null) {
            return string3;
        }
        Map map = (Map)threadProperties.get();
        if (map != null && (string2 = (String)map.get(string)) != null) {
            return string2;
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    public static String getPropertyValue(String string, String string2) {
        String string3 = Properties.getPropertyValue(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private static boolean isSetFalse(String string) {
        if (string == null || string.length() != 5) {
            return false;
        }
        return !(string.charAt(0) != 'f' && string.charAt(0) != 'F' || string.charAt(1) != 'a' && string.charAt(1) != 'A' || string.charAt(2) != 'l' && string.charAt(2) != 'L' || string.charAt(3) != 's' && string.charAt(3) != 'S' || string.charAt(4) != 'e' && string.charAt(4) != 'E');
    }

    private static boolean isSetTrue(String string) {
        if (string == null || string.length() != 4) {
            return false;
        }
        return !(string.charAt(0) != 't' && string.charAt(0) != 'T' || string.charAt(1) != 'r' && string.charAt(1) != 'R' || string.charAt(2) != 'u' && string.charAt(2) != 'U' || string.charAt(3) != 'e' && string.charAt(3) != 'E');
    }
}

