/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.a;
import org.slf4j.c;
import org.slf4j.event.e;
import org.slf4j.helpers.Reporter;
import org.slf4j.helpers.h;
import org.slf4j.helpers.j;
import org.slf4j.helpers.l;
import org.slf4j.helpers.n;

public final class d {
    static final String aDE = "https://www.slf4j.org/codes.html";
    static final String aDF = "https://www.slf4j.org/codes.html#noProviders";
    static final String aDG = "https://www.slf4j.org/codes.html#ignoredBindings";
    static final String aDH = "https://www.slf4j.org/codes.html#multiple_bindings";
    static final String aDI = "https://www.slf4j.org/codes.html#version_mismatch";
    static final String aDJ = "https://www.slf4j.org/codes.html#substituteLogger";
    static final String aDK = "https://www.slf4j.org/codes.html#loggerNameMismatch";
    static final String aDL = "https://www.slf4j.org/codes.html#replay";
    static final String aDM = "https://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String aDN = "org.slf4j.LoggerFactory in failed state. Original exception was thrown EARLIER. See also https://www.slf4j.org/codes.html#unsuccessfulInit";
    public static final String aDO = "slf4j.provider";
    static final int aDP = 0;
    static final int aDQ = 1;
    static final int aDR = 2;
    static final int aDS = 3;
    static final int aDT = 4;
    static volatile int aDU = 0;
    static final l aDV = new l();
    static final h aDW = new h();
    static final String aDX = "slf4j.detectLoggerNameMismatch";
    static final String aDY = "java.vendor.url";
    static boolean aDZ = n.do("slf4j.detectLoggerNameMismatch");
    static volatile org.slf4j.a.j aEa;
    private static final String[] aEb;
    private static final String aEc = "org/slf4j/impl/StaticLoggerBinder.class";

    static List<org.slf4j.a.j> sC() {
        ArrayList<org.slf4j.a.j> providerList = new ArrayList<org.slf4j.a.j>();
        ClassLoader classLoaderOfLoggerFactory = d.class.getClassLoader();
        org.slf4j.a.j explicitProvider = d.f(classLoaderOfLoggerFactory);
        if (explicitProvider != null) {
            providerList.add(explicitProvider);
            return providerList;
        }
        ServiceLoader<org.slf4j.a.j> serviceLoader = d.e(classLoaderOfLoggerFactory);
        Iterator<org.slf4j.a.j> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            d.a(providerList, iterator);
        }
        return providerList;
    }

    private static ServiceLoader<org.slf4j.a.j> e(ClassLoader classLoaderOfLoggerFactory) {
        ServiceLoader serviceLoader;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            serviceLoader = ServiceLoader.load(org.slf4j.a.j.class, classLoaderOfLoggerFactory);
        } else {
            PrivilegedAction<ServiceLoader> action = () -> ServiceLoader.load(org.slf4j.a.j.class, classLoaderOfLoggerFactory);
            serviceLoader = AccessController.doPrivileged(action);
        }
        return serviceLoader;
    }

    private static void a(List<org.slf4j.a.j> providerList, Iterator<org.slf4j.a.j> iterator) {
        try {
            org.slf4j.a.j provider = iterator.next();
            providerList.add(provider);
        }
        catch (ServiceConfigurationError e2) {
            Reporter.dm("A service provider failed to instantiate:\n" + e2.getMessage());
        }
    }

    private d() {
    }

    static void reset() {
        aDU = 0;
    }

    private static final void sD() {
        d.sE();
        if (aDU == 3) {
            d.sK();
        }
    }

    private static final void sE() {
        try {
            List<org.slf4j.a.j> providersList = d.sC();
            d.o(providersList);
            if (providersList != null && !providersList.isEmpty()) {
                aEa = providersList.get(0);
                aEa.initialize();
                aDU = 3;
                d.p(providersList);
            } else {
                aDU = 4;
                Reporter.dl("No SLF4J providers were found.");
                Reporter.dl("Defaulting to no-operation (NOP) logger implementation");
                Reporter.dl("See https://www.slf4j.org/codes.html#noProviders for further details.");
                Set<URL> staticLoggerBinderPathSet = d.sF();
                d.a(staticLoggerBinderPathSet);
            }
            d.sG();
        }
        catch (Exception e2) {
            d.x(e2);
            throw new IllegalStateException("Unexpected initialization failure", e2);
        }
    }

    static org.slf4j.a.j f(ClassLoader classLoader) {
        String explicitlySpecified = System.getProperty(aDO);
        if (null == explicitlySpecified || explicitlySpecified.isEmpty()) {
            return null;
        }
        try {
            String message = String.format("Attempting to load provider \"%s\" specified via \"%s\" system property", explicitlySpecified, aDO);
            Reporter.info(message);
            Class<?> clazz = classLoader.loadClass(explicitlySpecified);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object provider = constructor.newInstance(new Object[0]);
            return (org.slf4j.a.j)provider;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            String message = String.format("Failed to instantiate the specified SLF4JServiceProvider (%s)", explicitlySpecified);
            Reporter.e(message, e2);
            return null;
        }
        catch (ClassCastException e3) {
            String message = String.format("Specified SLF4JServiceProvider (%s) does not implement SLF4JServiceProvider interface", explicitlySpecified);
            Reporter.e(message, e3);
            return null;
        }
    }

    private static void a(Set<URL> staticLoggerBinderPathSet) {
        if (staticLoggerBinderPathSet.isEmpty()) {
            return;
        }
        Reporter.dl("Class path contains SLF4J bindings targeting slf4j-api versions 1.7.x or earlier.");
        for (URL path : staticLoggerBinderPathSet) {
            Reporter.dl("Ignoring binding found at [" + path + "]");
        }
        Reporter.dl("See https://www.slf4j.org/codes.html#ignoredBindings for an explanation.");
    }

    static Set<URL> sF() {
        LinkedHashSet<URL> staticLoggerBinderPathSet = new LinkedHashSet<URL>();
        try {
            ClassLoader loggerFactoryClassLoader = d.class.getClassLoader();
            Enumeration<URL> paths = loggerFactoryClassLoader == null ? ClassLoader.getSystemResources(aEc) : loggerFactoryClassLoader.getResources(aEc);
            while (paths.hasMoreElements()) {
                URL path = paths.nextElement();
                staticLoggerBinderPathSet.add(path);
            }
        }
        catch (IOException ioe) {
            Reporter.e("Error getting resources from path", ioe);
        }
        return staticLoggerBinderPathSet;
    }

    private static void sG() {
        d.sH();
        d.sI();
        aDV.tl().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sH() {
        l l2 = aDV;
        synchronized (l2) {
            aDV.tl().tk();
            for (j substLogger : aDV.tl().ti()) {
                c logger = d.r(substLogger.getName());
                substLogger.a(logger);
            }
        }
    }

    static void x(Throwable t2) {
        aDU = 2;
        Reporter.e("Failed to instantiate SLF4J LoggerFactory", t2);
    }

    private static void sI() {
        int numDrained;
        LinkedBlockingQueue<e> queue = aDV.tl().tj();
        int queueSize = queue.size();
        int count = 0;
        int maxDrain = 128;
        ArrayList eventList = new ArrayList(128);
        while ((numDrained = queue.drainTo(eventList, 128)) != 0) {
            for (e event : eventList) {
                d.a(event);
                if (count++ != 0) continue;
                d.a(event, queueSize);
            }
            eventList.clear();
        }
    }

    private static void a(e event, int queueSize) {
        if (event.sU().te()) {
            d.aZ(queueSize);
        } else if (!event.sU().tg()) {
            d.sJ();
        }
    }

    private static void a(e event) {
        if (event == null) {
            return;
        }
        j substLogger = event.sU();
        String loggerName = substLogger.getName();
        if (substLogger.tf()) {
            throw new IllegalStateException("Delegate logger cannot be null at this state.");
        }
        if (!substLogger.tg()) {
            if (substLogger.te()) {
                if (substLogger.b(event.sR())) {
                    substLogger.log(event);
                }
            } else {
                Reporter.dl(loggerName);
            }
        }
    }

    private static void sJ() {
        Reporter.dl("The following set of substitute loggers may have been accessed");
        Reporter.dl("during the initialization phase. Logging calls during this");
        Reporter.dl("phase were not honored. However, subsequent logging calls to these");
        Reporter.dl("loggers will work as normally expected.");
        Reporter.dl("See also https://www.slf4j.org/codes.html#substituteLogger");
    }

    private static void aZ(int eventCount) {
        Reporter.dl("A number (" + eventCount + ") of logging calls during the initialization phase have been intercepted and are");
        Reporter.dl("now being replayed. These are subject to the filtering rules of the underlying logging system.");
        Reporter.dl("See also https://www.slf4j.org/codes.html#replay");
    }

    private static final void sK() {
        try {
            String requested = aEa.bN();
            boolean match = false;
            for (String aAPI_COMPATIBILITY_LIST : aEb) {
                if (!requested.startsWith(aAPI_COMPATIBILITY_LIST)) continue;
                match = true;
            }
            if (!match) {
                Reporter.dl("The requested version " + requested + " by your slf4j provider is not compatible with " + Arrays.asList(aEb).toString());
                Reporter.dl("See https://www.slf4j.org/codes.html#version_mismatch for further details.");
            }
        }
        catch (Throwable e2) {
            Reporter.e("Unexpected problem occurred during version sanity check", e2);
        }
    }

    private static boolean n(List<org.slf4j.a.j> providerList) {
        return providerList.size() > 1;
    }

    private static void o(List<org.slf4j.a.j> providerList) {
        if (d.n(providerList)) {
            Reporter.dl("Class path contains multiple SLF4J providers.");
            for (org.slf4j.a.j provider : providerList) {
                Reporter.dl("Found provider [" + provider + "]");
            }
            Reporter.dl("See https://www.slf4j.org/codes.html#multiple_bindings for an explanation.");
        }
    }

    private static void p(List<org.slf4j.a.j> providerList) {
        if (!providerList.isEmpty() && d.n(providerList)) {
            Reporter.info("Actual provider is of type [" + providerList.get(0) + "]");
        }
    }

    public static c r(String name) {
        a iLoggerFactory = d.sL();
        return iLoggerFactory.r(name);
    }

    public static c ae(Class<?> clazz) {
        Class<?> autoComputedCallingClass;
        c logger = d.r(clazz.getName());
        if (aDZ && (autoComputedCallingClass = n.to()) != null && d.a(clazz, autoComputedCallingClass)) {
            Reporter.dl(String.format("Detected logger name mismatch. Given name: \"%s\"; computed name: \"%s\".", logger.getName(), autoComputedCallingClass.getName()));
            Reporter.dl("See https://www.slf4j.org/codes.html#loggerNameMismatch for an explanation");
        }
        return logger;
    }

    private static boolean a(Class<?> clazz, Class<?> autoComputedCallingClass) {
        return !autoComputedCallingClass.isAssignableFrom(clazz);
    }

    public static a sL() {
        return d.sM().bL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static org.slf4j.a.j sM() {
        if (aDU == 0) {
            Class<d> clazz = d.class;
            // MONITORENTER : org.slf4j.d.class
            if (aDU == 0) {
                aDU = 1;
                d.sD();
            }
            // MONITOREXIT : clazz
        }
        switch (aDU) {
            case 3: {
                return aEa;
            }
            case 4: {
                return aDW;
            }
            case 2: {
                throw new IllegalStateException(aDN);
            }
            case 1: {
                return aDV;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    static {
        aEb = new String[]{"2.0"};
    }
}

