/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.io.PrintStream;

public class Reporter {
    static final String aER = "SLF4J(I): ";
    static final String aES = "SLF4J(W): ";
    static final String aET = "SLF4J(E): ";
    public static final String aEU = "slf4j.internal.report.stream";
    private static final String[] aEV = new String[]{"System.out", "stdout", "sysout"};
    public static final String aEW = "slf4j.internal.verbosity";
    private static final TargetChoice aEX = Reporter.sW();
    private static final Level aEY = Reporter.sX();

    private static TargetChoice sW() {
        String reportStreamStr = System.getProperty(aEU);
        if (reportStreamStr == null || reportStreamStr.isEmpty()) {
            return TargetChoice.Stderr;
        }
        for (String s2 : aEV) {
            if (!s2.equalsIgnoreCase(reportStreamStr)) continue;
            return TargetChoice.Stdout;
        }
        return TargetChoice.Stderr;
    }

    private static Level sX() {
        String verbosityStr = System.getProperty(aEW);
        if (verbosityStr == null || verbosityStr.isEmpty()) {
            return Level.INFO;
        }
        if (verbosityStr.equalsIgnoreCase("ERROR")) {
            return Level.ERROR;
        }
        if (verbosityStr.equalsIgnoreCase("WARN")) {
            return Level.WARN;
        }
        return Level.INFO;
    }

    static boolean a(Level level) {
        return level.levelInt >= Reporter.aEY.levelInt;
    }

    private static PrintStream sY() {
        switch (aEX.ordinal()) {
            case 1: {
                return System.out;
            }
        }
        return System.err;
    }

    public static void info(String msg) {
        if (Reporter.a(Level.INFO)) {
            Reporter.sY().println(aER + msg);
        }
    }

    public static final void dl(String msg) {
        if (Reporter.a(Level.WARN)) {
            Reporter.sY().println(aES + msg);
        }
    }

    public static final void e(String msg, Throwable t2) {
        Reporter.sY().println(aET + msg);
        Reporter.sY().println("SLF4J(E): Reported exception:");
        t2.printStackTrace(Reporter.sY());
    }

    public static final void dm(String msg) {
        Reporter.sY().println(aET + msg);
    }

    private static final class TargetChoice
    extends Enum<TargetChoice> {
        public static final /* enum */ TargetChoice Stderr = new TargetChoice();
        public static final /* enum */ TargetChoice Stdout = new TargetChoice();
        private static final /* synthetic */ TargetChoice[] aFa;

        public static TargetChoice[] values() {
            return (TargetChoice[])aFa.clone();
        }

        public static TargetChoice valueOf(String name) {
            return Enum.valueOf(TargetChoice.class, name);
        }

        private static /* synthetic */ TargetChoice[] tb() {
            return new TargetChoice[]{Stderr, Stdout};
        }

        static {
            aFa = TargetChoice.tb();
        }
    }

    private static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level INFO = new Level(1);
        public static final /* enum */ Level WARN = new Level(2);
        public static final /* enum */ Level ERROR = new Level(3);
        int levelInt;
        private static final /* synthetic */ Level[] aEZ;

        public static Level[] values() {
            return (Level[])aEZ.clone();
        }

        public static Level valueOf(String name) {
            return Enum.valueOf(Level.class, name);
        }

        private Level(int levelInt) {
            this.levelInt = levelInt;
        }

        private int sZ() {
            return this.levelInt;
        }

        private static /* synthetic */ Level[] ta() {
            return new Level[]{INFO, WARN, ERROR};
        }

        static {
            aEZ = Level.ta();
        }
    }
}

