/*
 * Decompiled with CFR 0.152.
 */
package simkey.kms;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import simkey.kms.ap;
import simkey.kms.at;

public final class au {
    private final int cr;
    private final ap cs;
    private final int ct;

    public au(int n2, int n3, ap ap2) {
        if (n2 < 2 || n2 > 65536) {
            throw new IllegalArgumentException("Radix must be in the range [2..65536]: " + n2);
        }
        this.ct = n2;
        this.cr = 4096;
        this.cs = ap2;
    }

    public final int[] a(SecretKey secretKey, byte[] byArray, int[] object) throws InvalidKeyException {
        if (secretKey == null) {
            throw new NullPointerException("K must not be null");
        }
        if (!secretKey.getAlgorithm().equals("AES")) {
            throw new InvalidKeyException("K must be an AES key");
        }
        if (byArray == null) {
            throw new NullPointerException("T must not be null");
        }
        if (byArray.length > this.cr) {
            throw new IllegalArgumentException("The length of T is not within the permitted range of 1.." + this.cr + ": " + byArray.length);
        }
        if (object == null) {
            throw new NullPointerException("X must not be null");
        }
        if (((int[])object).length < 2 || ((int[])object).length > 4096) {
            throw new IllegalArgumentException("The length of X is not within the permitted range of 2..4096: " + ((int[])object).length);
        }
        if (Math.pow(this.ct, ((int[])object).length) < 100.0) {
            throw new IllegalArgumentException("The length of X must be such that radix ^ length > 100");
        }
        int n2 = ((int[])object).length;
        int n3 = byArray.length;
        int n4 = at.b((double)n2 / 2.0);
        int n5 = n2 - n4;
        Object[] objectArray = Arrays.copyOfRange(object, 0, n4);
        object = Arrays.copyOfRange(object, n4, n2);
        int n6 = at.a((double)at.a((double)n5 * at.b(this.ct)) / 8.0);
        int n7 = 4 * at.a((double)n6 / 4.0) + 4;
        byte[] byArray2 = at.a(this.ct, 3);
        byte[] byArray3 = at.a(n2, 4);
        Object[] objectArray2 = at.a(n3, 4);
        byArray3 = new byte[]{1, 2, 1, byArray2[0], byArray2[1], byArray2[2], 10, (byte)at.b(n4, 256), byArray3[0], byArray3[1], byArray3[2], byArray3[3], objectArray2[0], objectArray2[1], objectArray2[2], objectArray2[3]};
        for (int i2 = 9; i2 >= 0; --i2) {
            objectArray2 = at.c(byArray, at.a(0, at.b(-n3 - n6 - 1, 16)));
            objectArray2 = at.c(objectArray2, at.a(i2, 1));
            objectArray2 = at.c(objectArray2, at.a(at.a(objectArray, this.ct), n6));
            objectArray2 = this.cs.b(secretKey, at.c(byArray3, objectArray2));
            byte[] byArray4 = objectArray2;
            for (int i3 = 1; i3 <= at.a((double)n7 / 16.0) - 1; ++i3) {
                byArray4 = at.c(byArray4, this.cs.c(secretKey, at.d(objectArray2, at.a(i3, 16))));
            }
            byArray4 = Arrays.copyOf(byArray4, n7);
            BigInteger bigInteger = at.f(byArray4);
            int n8 = i2 % 2 == 0 ? n4 : n5;
            BigInteger bigInteger2 = at.a(at.a(object, this.ct).subtract(bigInteger), BigInteger.valueOf(this.ct).pow(n8));
            object = bigInteger2;
            objectArray2 = at.a(bigInteger2, this.ct, n8);
            object = objectArray;
            objectArray = objectArray2;
        }
        int[] nArray = at.a(objectArray, object);
        return nArray;
    }

    public final int[] b(SecretKey secretKey, byte[] byArray, int[] objectArray) throws InvalidKeyException {
        if (secretKey == null) {
            throw new NullPointerException("K must not be null");
        }
        if (!secretKey.getAlgorithm().equals("AES")) {
            throw new InvalidKeyException("K must be an AES key");
        }
        if (byArray == null) {
            throw new NullPointerException("T must not be null");
        }
        if (byArray.length > this.cr) {
            throw new IllegalArgumentException("The length of T is not within the permitted range of 1.." + this.cr + ": " + byArray.length);
        }
        if (objectArray == null) {
            throw new NullPointerException("X must not be null");
        }
        if (objectArray.length < 2 || objectArray.length > 4096) {
            throw new IllegalArgumentException("The length of X is not within the permitted range of 2..4096: " + objectArray.length);
        }
        if (Math.pow(this.ct, objectArray.length) < 100.0) {
            throw new IllegalArgumentException("The length of X must be such that radix ^ length > 100 (radix ^ length =" + Math.pow(this.ct, objectArray.length));
        }
        int n2 = objectArray.length;
        int n3 = byArray.length;
        int n4 = at.b((double)n2 / 2.0);
        int n5 = n2 - n4;
        Object object = Arrays.copyOfRange(objectArray, 0, n4);
        objectArray = Arrays.copyOfRange(objectArray, n4, n2);
        int n6 = at.a((double)at.a((double)n5 * at.b(this.ct)) / 8.0);
        int n7 = 4 * at.a((double)n6 / 4.0) + 4;
        byte[] byArray2 = at.a(this.ct, 3);
        byte[] byArray3 = at.a(n2, 4);
        Object[] objectArray2 = at.a(n3, 4);
        byArray3 = new byte[]{1, 2, 1, byArray2[0], byArray2[1], byArray2[2], 10, (byte)at.b(n4, 256), byArray3[0], byArray3[1], byArray3[2], byArray3[3], objectArray2[0], objectArray2[1], objectArray2[2], objectArray2[3]};
        for (int i2 = 0; i2 < 10; ++i2) {
            objectArray2 = at.c(byArray, at.a(0, at.b(-n3 - n6 - 1, 16)));
            objectArray2 = at.c(objectArray2, at.a(i2, 1));
            objectArray2 = at.c(objectArray2, at.a(at.a(objectArray, this.ct), n6));
            objectArray2 = this.cs.a(secretKey, at.c(byArray3, objectArray2));
            byte[] byArray4 = objectArray2;
            for (int i3 = 1; i3 <= at.a((double)n7 / 16.0) - 1; ++i3) {
                byArray4 = at.c(byArray4, this.cs.c(secretKey, at.d(objectArray2, at.a(i3, 16))));
            }
            byArray4 = Arrays.copyOf(byArray4, n7);
            BigInteger bigInteger = at.f(byArray4);
            int n8 = i2 % 2 == 0 ? n4 : n5;
            BigInteger bigInteger2 = at.a(at.a(object, this.ct).add(bigInteger), BigInteger.valueOf(this.ct).pow(n8));
            object = bigInteger2;
            objectArray2 = at.a(bigInteger2, this.ct, n8);
            object = objectArray;
            objectArray = objectArray2;
        }
        int[] nArray = at.a(object, objectArray);
        return nArray;
    }
}

