/*
 * Decompiled with CFR 0.152.
 */
package simkey.kms;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Arrays;
import javax.crypto.spec.SecretKeySpec;
import simkey.kms.ap;
import simkey.kms.at;

public final class av {
    private final int cu;
    private final ap cv;
    private final int cw;
    private final int cx;

    public av(int n2, ap ap2) {
        if (n2 < 2 || n2 > 65536) {
            throw new IllegalArgumentException("Radix must be in the range 2..65536: " + n2);
        }
        this.cx = n2;
        this.cw = Math.max(2, at.a(Math.log(100.0) / Math.log(n2)));
        this.cu = Math.max(this.cw, 2 * at.b(Math.log(Math.pow(2.0, 96.0)) / Math.log(n2)));
        this.cv = ap2;
    }

    public final int[] a(SecretKeySpec secretKeySpec, byte[] byArray, int[] object) throws InvalidKeyException {
        if (!secretKeySpec.getAlgorithm().equals("AES")) {
            throw new InvalidKeyException("K must be an AES key");
        }
        if (!secretKeySpec.getFormat().equals("RAW")) {
            throw new InvalidKeyException("K must be in RAW format");
        }
        if (byArray == null) {
            throw new NullPointerException("T must not be null");
        }
        if (byArray.length != 8) {
            throw new IllegalArgumentException("T must be an array of 8 bytes: " + byArray.length);
        }
        if (object == null) {
            throw new NullPointerException("X must not be null");
        }
        if (((int[])object).length < this.cw || ((int[])object).length > this.cu) {
            throw new IllegalArgumentException("The length of X is not within the permitted range of " + this.cw + ".." + this.cu + ": " + ((int[])object).length);
        }
        int n2 = ((int[])object).length;
        secretKeySpec = new SecretKeySpec(at.g(secretKeySpec.getEncoded()), "AES");
        int n3 = at.a((double)n2 / 2.0);
        int n4 = n2 - n3;
        int[] nArray = Arrays.copyOfRange(object, 0, n3);
        object = Arrays.copyOfRange(object, n3, n2);
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 4);
        byArray = Arrays.copyOfRange(byArray, 4, 8);
        for (int i2 = 7; i2 >= 0; --i2) {
            int n5 = i2 % 2 == 0 ? n3 : n4;
            Object object2 = i2 % 2 == 0 ? byArray : byArray2;
            object2 = at.c(at.d(object2, at.a(i2, 4)), at.a(at.a(at.b(nArray), this.cx), 12));
            object2 = at.g(this.cv.c(secretKeySpec, at.g(object2)));
            object2 = at.f(object2);
            BigInteger bigInteger = at.a(at.a(at.b(object), this.cx).subtract((BigInteger)object2), BigInteger.valueOf(this.cx).pow(n5));
            object = bigInteger;
            int[] nArray2 = at.b(at.a(bigInteger, this.cx, n5));
            object = nArray;
            nArray = nArray2;
        }
        int[] nArray3 = at.a(nArray, object);
        return nArray3;
    }

    public final int[] b(SecretKeySpec secretKeySpec, byte[] byArray, int[] nArray) throws InvalidKeyException {
        if (!secretKeySpec.getAlgorithm().equals("AES")) {
            throw new InvalidKeyException("K must be an AES key");
        }
        if (!secretKeySpec.getFormat().equals("RAW")) {
            throw new InvalidKeyException("K must be in RAW format");
        }
        if (byArray == null) {
            throw new NullPointerException("T must not be null");
        }
        if (byArray.length != 8) {
            throw new IllegalArgumentException("T must be an array of 8 bytes: " + byArray.length);
        }
        if (nArray == null) {
            throw new NullPointerException("X must not be null");
        }
        if (nArray.length < this.cw || nArray.length > this.cu) {
            throw new IllegalArgumentException("The length of X is not within the permitted range of " + this.cw + ".." + this.cu + ": " + nArray.length);
        }
        int n2 = nArray.length;
        secretKeySpec = new SecretKeySpec(at.g(secretKeySpec.getEncoded()), "AES");
        int n3 = at.a((double)n2 / 2.0);
        int n4 = n2 - n3;
        Object object = Arrays.copyOfRange(nArray, 0, n3);
        nArray = Arrays.copyOfRange(nArray, n3, n2);
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 4);
        byArray = Arrays.copyOfRange(byArray, 4, 8);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n5 = i2 % 2 == 0 ? n3 : n4;
            Object object2 = i2 % 2 == 0 ? byArray : byArray2;
            object2 = at.c(at.d(object2, at.a(i2, 4)), at.a(at.a(at.b(nArray), this.cx), 12));
            object2 = at.g(this.cv.c(secretKeySpec, at.g(object2)));
            object2 = at.f(object2);
            BigInteger bigInteger = at.a(at.a(at.b(object), this.cx).add((BigInteger)object2), BigInteger.valueOf(this.cx).pow(n5));
            object = bigInteger;
            int[] nArray2 = at.b(at.a(bigInteger, this.cx, n5));
            object = nArray;
            nArray = nArray2;
        }
        int[] nArray3 = at.a(object, nArray);
        return nArray3;
    }
}

