/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.cache;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class LruCache<K, V> {
    private final LinkedHashMap<K, V> map;
    private int size;
    private int maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    /*
     * WARNING - void declaration
     */
    public LruCache(int maxSize) {
        void var1_1;
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = var1_1;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized V get(K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        V v2 = this.map.get(key);
        if (v2 != null) {
            ++this.hitCount;
            return v2;
        }
        ++this.missCount;
        v2 = this.create(key);
        if (v2 != null) {
            void var1_1;
            ++this.createCount;
            this.size += this.safeSizeOf(key, v2);
            this.map.put(var1_1, v2);
            LruCache lruCache = this;
            lruCache.trimToSize(lruCache.maxSize);
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized V put(K key, V value) {
        void var2_2;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        ++this.putCount;
        this.size += this.safeSizeOf(key, value);
        if ((var2_2 = this.map.put(key, var2_2)) != null) {
            void var1_1;
            this.size -= this.safeSizeOf(var1_1, var2_2);
        }
        LruCache lruCache = this;
        lruCache.trimToSize(lruCache.maxSize);
        return var2_2;
    }

    private void trimToSize(int maxSize) {
        Map.Entry<K, V> entry;
        while (this.size > maxSize && !this.map.isEmpty() && (entry = this.map.entrySet().iterator().next()) != null) {
            K k2 = entry.getKey();
            entry = entry.getValue();
            this.map.remove(k2);
            this.size -= this.safeSizeOf(k2, entry);
            ++this.evictionCount;
            this.entryEvicted(k2, entry);
        }
        if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
            throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized V remove(K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        Object v2 = this.map.remove(key);
        if (v2 != null) {
            void var1_1;
            this.size -= this.safeSizeOf(var1_1, v2);
        }
        return v2;
    }

    protected void entryEvicted(K key, V value) {
    }

    protected V create(K key) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private int safeSizeOf(K key, V value) {
        int n2 = this.sizeOf(key, value);
        if (n2 < 0) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException("Negative size: " + var1_1 + "=" + var2_2);
        }
        return n2;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final synchronized void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized int maxSize() {
        return this.maxSize;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int missCount() {
        return this.missCount;
    }

    public final synchronized int createCount() {
        return this.createCount;
    }

    public final synchronized int putCount() {
        return this.putCount;
    }

    public final synchronized int evictionCount() {
        return this.evictionCount;
    }

    public final synchronized Map<K, V> snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }

    public final synchronized String toString() {
        int n2 = this.hitCount + this.missCount;
        n2 = n2 != 0 ? 100 * this.hitCount / n2 : 0;
        return String.format(Locale.getDefault(), "LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.maxSize, this.hitCount, this.missCount, n2);
    }
}

