/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.encoding;

public class Hex {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] decodeHex(String data) {
        return Hex.decodeHex(data.toCharArray());
    }

    public static byte[] decodeHex(char[] data) {
        int n2 = data.length;
        if ((n2 & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] byArray = new byte[n2 >> 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = Hex.toDigit(data[n4], n4) << 4;
            n5 |= Hex.toDigit(data[++n4], n4);
            ++n4;
            byArray[n3] = (byte)n5;
            ++n3;
        }
        return byArray;
    }

    public static char[] encodeHex(byte[] data) {
        return Hex.encodeHex(data, true);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        void var1_1;
        return Hex.encodeHex(data, var1_1 != false ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int n2 = data.length;
        char[] cArray = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[n3++] = toDigits[(0xF0 & data[i2]) >>> 4];
            cArray[n3++] = toDigits[0xF & data[i2]];
        }
        return cArray;
    }

    /*
     * WARNING - void declaration
     */
    protected static int toDigit(char ch, int index) {
        int n2 = Character.digit(ch, 16);
        if (n2 == -1) {
            void var1_1;
            char c2;
            throw new IllegalArgumentException("Illegal hexadecimal character " + c2 + " at index " + (int)var1_1);
        }
        return n2;
    }

    public static String parseByte2HexStr(byte[] buf) {
        try {
            Object[] objectArray = Hex.encodeHex(buf, false);
            return new String((char[])objectArray);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String parseByte2HexStr(byte buf) {
        byte by2;
        return Hex.parseByte2HexStr(new byte[]{by2});
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        try {
            return Hex.decodeHex(hexStr);
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }
}

