/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.http;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import simkey.kms.aw;

public class FileUploader {
    private static final String TAG = "FileUploader";
    private static final int CONNECT_TIME_OUT = 5000;
    private static final int READ_TIME_OUT = 180000;
    private static final String CHARSET = "utf-8";
    private static final String PREFIX = "--";
    private static final String LINE_END = "\r\n";

    /*
     * WARNING - void declaration
     */
    public static void upload(String host, File file, Map<String, String> params, FileUploadListener listener) {
        Object object = UUID.randomUUID().toString();
        Object object2 = "multipart/form-data";
        if (file == null) {
            return;
        }
        try {
            Object object3;
            CharSequence charSequence;
            if (!file.exists()) {
                return;
            }
            charSequence = FileUploader.getParameterString((Map<String, String>)((Object)charSequence), CHARSET);
            object3 = new URL((String)object3 + "?" + (String)charSequence);
            object3 = (HttpURLConnection)((URL)object3).openConnection();
            try {
                void var3_8;
                int n2;
                void var1_1;
                ((URLConnection)object3).setConnectTimeout(5000);
                ((URLConnection)object3).setReadTimeout(180000);
                ((HttpURLConnection)object3).setRequestMethod("POST");
                ((URLConnection)object3).setRequestProperty("Charset", CHARSET);
                ((URLConnection)object3).setRequestProperty("connection", "keep-alive");
                ((URLConnection)object3).setRequestProperty("Content-Type", (String)object2 + ";boundary=" + (String)object);
                ((URLConnection)object3).setDoInput(true);
                ((URLConnection)object3).setDoOutput(true);
                ((URLConnection)object3).setUseCaches(false);
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(LINE_END);
                ((StringBuilder)charSequence).append(PREFIX);
                ((StringBuilder)charSequence).append((String)object);
                ((StringBuilder)charSequence).append(LINE_END);
                ((StringBuilder)charSequence).append("Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"\r\n");
                ((StringBuilder)charSequence).append("Content-Type: application/octet-stream; charset=utf-8\r\n");
                ((StringBuilder)charSequence).append(LINE_END);
                object2 = ((URLConnection)object3).getOutputStream();
                object2 = new DataOutputStream((OutputStream)object2);
                ((FilterOutputStream)object2).write(((StringBuilder)charSequence).toString().getBytes());
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[1024];
                long l2 = var1_1.length();
                long l3 = 0L;
                while ((n2 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                    ((DataOutputStream)object2).write(byArray, 0, n2);
                    listener.onProgress(l3 += (long)n2, 1.0 * (double)l3 / (double)l2);
                }
                ((InputStream)fileInputStream).close();
                ((FilterOutputStream)object2).write(LINE_END.getBytes());
                byte[] byArray2 = (PREFIX + (String)object + "--\r\n").getBytes();
                ((FilterOutputStream)object2).write(byArray2);
                ((DataOutputStream)object2).flush();
                int n3 = ((HttpURLConnection)object3).getResponseCode();
                ((StringBuilder)charSequence).setLength(0);
                object = new BufferedReader(new InputStreamReader(((URLConnection)object3).getInputStream()));
                while ((object2 = ((BufferedReader)object).readLine()) != null) {
                    ((StringBuilder)charSequence).append((String)object2);
                }
                ((BufferedReader)object).close();
                var3_8.onFinish(n3, ((StringBuilder)charSequence).toString(), ((URLConnection)object3).getHeaderFields());
            }
            finally {
                ((HttpURLConnection)object3).disconnect();
            }
        }
        catch (Exception exception) {
            aw.a(TAG, exception.getMessage(), exception);
        }
    }

    private static String getParameterString(Map<String, String> params, String paramsEncoding) {
        if (params != null && params.size() > 0) {
            Iterator<Map.Entry<String, String>> iterator;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                for (Map.Entry<String, String> entry : iterator.entrySet()) {
                    stringBuilder.append(URLEncoder.encode(entry.getKey(), paramsEncoding));
                    stringBuilder.append('=');
                    stringBuilder.append(URLEncoder.encode(entry.getValue(), paramsEncoding));
                    stringBuilder.append('&');
                }
                return stringBuilder.toString();
            }
            catch (Exception exception) {
                iterator = exception;
                exception.printStackTrace();
                return null;
            }
        }
        return "";
    }

    public static interface FileUploadListener {
        public void onProgress(long var1, double var3);

        public void onFinish(int var1, String var2, Map<String, List<String>> var3);
    }
}

