/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.http.hurl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ByteArrayPool {
    private final List<byte[]> mBuffersByLastUse = new ArrayList<byte[]>();
    private final List<byte[]> mBuffersBySize = new ArrayList<byte[]>(64);
    private int mCurrentSize = 0;
    private final int mSizeLimit;
    protected static final Comparator<byte[]> BUF_COMPARATOR = new Comparator<byte[]>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(byte[] lhs, byte[] rhs) {
            void var2_2;
            return lhs.length - ((void)var2_2).length;
        }
    };

    /*
     * WARNING - void declaration
     */
    public ByteArrayPool(int sizeLimit) {
        void var1_1;
        this.mSizeLimit = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized byte[] getBuf(int len) {
        void var1_1;
        for (int i2 = 0; i2 < this.mBuffersBySize.size(); ++i2) {
            byte[] byArray = this.mBuffersBySize.get(i2);
            if (byArray.length < len) continue;
            this.mCurrentSize -= byArray.length;
            this.mBuffersBySize.remove(i2);
            this.mBuffersByLastUse.remove(byArray);
            return byArray;
        }
        return new byte[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void returnBuf(byte[] buf) {
        void var1_1;
        if (buf == null || buf.length > this.mSizeLimit) {
            return;
        }
        this.mBuffersByLastUse.add(buf);
        int n2 = Collections.binarySearch(this.mBuffersBySize, buf, BUF_COMPARATOR);
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        this.mBuffersBySize.add(n2, buf);
        this.mCurrentSize += ((void)var1_1).length;
        this.trim();
    }

    private synchronized void trim() {
        while (this.mCurrentSize > this.mSizeLimit) {
            byte[] byArray = this.mBuffersByLastUse.remove(0);
            this.mBuffersBySize.remove(byArray);
            this.mCurrentSize -= byArray.length;
        }
    }
}

