/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.http.hurl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import simkey.kms.aw;
import tech.simkey.dove.http.hurl.ByteArrayPool;
import tech.simkey.dove.http.hurl.HttpHeaderParser;
import tech.simkey.dove.http.hurl.HttpResponse;
import tech.simkey.dove.http.hurl.NetworkResponse;
import tech.simkey.dove.http.hurl.PoolingByteArrayOutputStream;

public class EntityUtils {
    private static final int DEFAULT_POOL_SIZE = 4096;

    /*
     * WARNING - void declaration
     */
    public static byte[] inputStreamToBytes(InputStream in, int contentLength) throws IOException {
        byte[] byArray;
        byte[] byArray2;
        PoolingByteArrayOutputStream poolingByteArrayOutputStream;
        ByteArrayPool byteArrayPool;
        block13: {
            void var1_1;
            byteArrayPool = new ByteArrayPool(4096);
            poolingByteArrayOutputStream = new PoolingByteArrayOutputStream(byteArrayPool, (int)var1_1);
            byArray2 = null;
            if (in != null) break block13;
            byte[] byArray3 = new byte[]{};
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {
                aw.c("EntityUtils", "Error occurred when closing InputStream");
            }
            byteArrayPool.returnBuf(byArray2);
            poolingByteArrayOutputStream.close();
            return byArray3;
        }
        try {
            int n2;
            byArray2 = byteArrayPool.getBuf(1024);
            while ((n2 = in.read(byArray2)) != -1) {
                poolingByteArrayOutputStream.write(byArray2, 0, n2);
            }
            byArray = poolingByteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    InputStream inputStream;
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                aw.c("EntityUtils", "Error occurred when closing InputStream");
            }
            byteArrayPool.returnBuf(byArray2);
            poolingByteArrayOutputStream.close();
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            aw.c("EntityUtils", "Error occurred when closing InputStream");
        }
        byteArrayPool.returnBuf(byArray2);
        poolingByteArrayOutputStream.close();
        return byArray;
    }

    private static byte[] inputStreamToBytes(HttpResponse httpResponse) {
        byte[] byArray = new byte[]{};
        try {
            InputStream inputStream = httpResponse.getContent();
            if (inputStream != null) {
                HttpResponse httpResponse2;
                byArray = EntityUtils.inputStreamToBytes(inputStream, httpResponse2.getContentLength());
            }
        }
        catch (Exception exception) {
            aw.a("", exception.getMessage(), exception);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(HttpResponse response, String defaultCharset) {
        Object object;
        byte[] byArray = EntityUtils.inputStreamToBytes(response);
        try {
            void var1_1;
            HttpHeaderParser.toHeaderMap(((HttpResponse)object).getHeaders());
            object = new String(byArray, (String)var1_1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new String(byArray);
        }
        return object;
    }

    public static String toString(NetworkResponse response, String defaultCharset) {
        String string;
        try {
            Map<String, String> cfr_ignored_0 = response.headers;
            string = new String(response.data, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            NetworkResponse networkResponse;
            string = new String(networkResponse.data);
        }
        return string;
    }
}

