/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.http.hurl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import tech.simkey.dove.http.hurl.Header;

public class HttpHeaderParser {
    static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    private static final String RFC1123_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";

    /*
     * WARNING - void declaration
     */
    public static String parseCharset(Map<String, String> headers, String defaultCharset) {
        void var1_1;
        Object object = headers.get(HEADER_CONTENT_TYPE);
        if (object != null) {
            object = object.split(";", 0);
            for (int i2 = 1; i2 < ((String[])object).length; ++i2) {
                String[] stringArray = object[i2].trim().split("=", 0);
                if (stringArray.length != 2 || !stringArray[0].equals("charset")) continue;
                return stringArray[1];
            }
        }
        return var1_1;
    }

    public static String parseCharset(Map<String, String> headers) {
        return HttpHeaderParser.parseCharset(headers, DEFAULT_CONTENT_CHARSET);
    }

    static Map<String, String> toHeaderMap(List<Header> allHeaders) {
        Iterator<Header> iterator;
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Header header = (Header)iterator.next();
            treeMap.put(header.getName(), header.getValue());
        }
        return treeMap;
    }

    static List<Header> toAllHeaderList(Map<String, String> headers) {
        Object object;
        ArrayList<Header> arrayList = new ArrayList<Header>(headers.size());
        for (Map.Entry entry : object.entrySet()) {
            arrayList.add(new Header((String)entry.getKey(), (String)entry.getValue()));
        }
        return arrayList;
    }
}

