/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.http.hurl;

import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import simkey.kms.aw;
import tech.simkey.dove.http.HttpClientBase;
import tech.simkey.dove.http.hurl.EntityUtils;
import tech.simkey.dove.http.hurl.Header;
import tech.simkey.dove.http.hurl.HttpResponse;
import tech.simkey.dove.http.hurl.NetworkResponse;

public class HttpURLConnectionClient {
    private static final String COOKIE_KEY = "set-cookie";
    private static final int HTTP_CONTINUE = 100;
    private static final String Encoding = "UTF-8";
    private static final int timeoutMs = 10000;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public final boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    /*
     * WARNING - void declaration
     */
    public String performStringRequest(String url, int requestMethod, Map<String, String> header, Map<String, String> body) {
        Object object;
        try {
            void var3_3;
            void var2_2;
            object = this.performSimpleRequest((String)object, (int)var2_2, (Map<String, String>)var3_3, body);
            if (object != null) {
                return EntityUtils.toString((NetworkResponse)object, Encoding);
            }
        }
        catch (Exception exception) {
            object = exception;
            HttpURLConnectionClient.printErr(exception);
        }
        return "";
    }

    public String performStringRequest(String url, String requestData) {
        Object object;
        try {
            Object object2;
            object = requestData.getBytes(Encoding);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(CONTENT_TYPE, this.getBodyContentTypeJson());
            object2 = this.performRequestWithRetry((String)object2, 1, (Map<String, String>)hashMap, (byte[])object, null, 0);
            if (object2 != null) {
                object2 = EntityUtils.toString((NetworkResponse)object2, Encoding);
                return object2;
            }
        }
        catch (Exception exception) {
            object = exception;
            HttpURLConnectionClient.printErr(exception);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public HttpClientBase.StreamEntity performStreamRequest(String url, int requestMethod, Map<String, String> header, Map<String, String> body) {
        Object object;
        try {
            void var3_4;
            void var2_2;
            object = this.performSimpleRequest((String)object, (int)var2_2, (Map<String, String>)var3_4, body);
            if (object != null) {
                HttpClientBase.StreamEntity streamEntity = new HttpClientBase.StreamEntity();
                new HttpClientBase.StreamEntity().data = ((NetworkResponse)object).data;
                streamEntity.contentLength = HttpURLConnectionClient.getContentLengthFromResp((NetworkResponse)object);
                streamEntity.fileName = HttpURLConnectionClient.getFileNameFromResp((NetworkResponse)object);
                return streamEntity;
            }
        }
        catch (Exception exception) {
            object = exception;
            HttpURLConnectionClient.printErr(exception);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public NetworkResponse performSimpleRequest(String url, int requestMethod, Map<String, String> header, Map<String, String> body) {
        Object object;
        try {
            void var3_3;
            void var2_2;
            this.removeNullValueIfExist(body);
            object = this.addParamsToGetUrl((String)object, requestMethod, body);
            byte[] byArray = this.parseBodyIfExists(requestMethod, body);
            object = this.performRequestWithRetry(((StringBuilder)object).toString(), (int)var2_2, (Map<String, String>)var3_3, byArray, null, 0);
            return object;
        }
        catch (Exception exception) {
            object = exception;
            HttpURLConnectionClient.printErr(exception);
            return null;
        }
    }

    public static int getContentLengthFromResp(NetworkResponse response) {
        Object object;
        try {
            object = response.getFirstHeader("Content-Length").getValue();
            return Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            object = exception;
            HttpURLConnectionClient.printErr(exception);
            return -1;
        }
    }

    public static String getFileNameFromResp(NetworkResponse response) {
        Object object;
        try {
            object = response.getFirstHeader("Content-Disposition");
            if (object != null) {
                object = ((Header)object).getValue();
                String string = "filename=";
                Object object2 = object;
                object = URLDecoder.decode(((String)object2).substring(((String)object2).indexOf(string) + string.length()), Encoding);
                return object;
            }
        }
        catch (Exception exception) {
            object = exception;
            HttpURLConnectionClient.printErr(exception);
        }
        return "";
    }

    private void removeNullValueIfExist(Map<String, String> body) {
        if (body != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : body.keySet()) {
                if (body.get(string) != null) continue;
                arrayList.add(string);
            }
            for (String string : arrayList) {
                body.remove(string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder addParamsToGetUrl(String url, int requestMethod, Map<String, String> body) {
        void var2_2;
        void var1_1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)var1_1);
        if (var2_2 == false && body != null && body.size() > 0) {
            void var3_3;
            stringBuilder.append("?");
            stringBuilder.append(this.getParameterString((Map<String, String>)var3_3, Encoding));
        }
        return stringBuilder;
    }

    private NetworkResponse performRequestWithRetry(String url, int requestMethod, Map<String, String> header, byte[] requestData, SSLSocketFactory mSslSocketFactory, int retryCount) {
        while (true) {
            try {
                return this.performRequest(url, requestMethod, header, requestData, mSslSocketFactory);
            }
            catch (IOException iOException) {
                if (this.isRetryAble(iOException, retryCount)) {
                    ++retryCount;
                    continue;
                }
                HttpURLConnectionClient.printErr(iOException);
                return null;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                HttpURLConnectionClient.printErr(exception);
                return null;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isRetryAble(IOException exception, int executionCount) {
        void var1_1;
        if (executionCount >= 3) {
            return false;
        }
        if (exception instanceof InterruptedIOException) {
            return false;
        }
        if (exception instanceof UnknownHostException) {
            return false;
        }
        if (var1_1 instanceof SSLException) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private NetworkResponse performRequest(String strurl, int requestMethod, Map<String, String> header, byte[] requestData, SSLSocketFactory mSslSocketFactory) throws MalformedURLException, ProtocolException, IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            void var2_6;
            int n2;
            void var3_8;
            Object object;
            object = new URL((String)object);
            httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setInstanceFollowRedirects(true);
            this.disableConnectionReuseIfNecessary();
            if ("https".equals(httpURLConnection.getURL().getProtocol()) && mSslSocketFactory != null) {
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(mSslSocketFactory);
            }
            this.addHeader(httpURLConnection, (Map<String, String>)var3_8);
            this.addBody(httpURLConnection, requestMethod);
            if (requestData != null) {
                httpURLConnection.setDoOutput(true);
                object = new DataOutputStream(httpURLConnection.getOutputStream());
                ((FilterOutputStream)object).write(requestData);
                ((FilterOutputStream)object).close();
            }
            if ((n2 = httpURLConnection.getResponseCode()) == -1) {
                System.out.println("Could not retrieve response code from HttpUrlConnection.");
                NetworkResponse networkResponse = null;
                return networkResponse;
            }
            Object object2 = !HttpURLConnectionClient.hasResponseBody((int)var2_6, n2) ? new HttpResponse(n2, HttpURLConnectionClient.convertHeaders(httpURLConnection.getHeaderFields())) : new HttpResponse(n2, HttpURLConnectionClient.convertHeaders(httpURLConnection.getHeaderFields()), httpURLConnection.getContentLength(), HttpURLConnectionClient.inputStreamFromConnection(httpURLConnection));
            int n3 = ((HttpResponse)object2).getStatusCode();
            Object object3 = ((HttpResponse)object2).getContent();
            object3 = object3 != null ? (Object)EntityUtils.inputStreamToBytes((InputStream)object3, ((HttpResponse)object2).getContentLength()) : (Object)new byte[0];
            object2 = new NetworkResponse(n3, (byte[])object3, false, 0L, ((HttpResponse)object2).getHeaders());
            return object2;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addBody(HttpURLConnection connection, int requestMethod) throws ProtocolException, IOException {
        switch (requestMethod) {
            case 0: {
                connection.setRequestMethod("GET");
                return;
            }
            case 3: {
                connection.setRequestMethod("DELETE");
                return;
            }
            case 1: {
                connection.setRequestMethod("POST");
                return;
            }
            case 2: {
                connection.setRequestMethod("PUT");
                return;
            }
            case 4: {
                connection.setRequestMethod("HEAD");
                return;
            }
            case 5: {
                connection.setRequestMethod("OPTIONS");
                return;
            }
            case 6: {
                connection.setRequestMethod("TRACE");
                return;
            }
            case 7: {
                void var1_1;
                var1_1.setRequestMethod("PATCH");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] parseBodyIfExists(int requestMethod, Map<String, String> body) throws IOException {
        void var1_1;
        byte[] byArray = null;
        switch (var1_1) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                byArray = this.encodeParameters(body, Encoding);
                break;
            }
            case 2: {
                byArray = this.encodeParameters(body, Encoding);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                void var2_2;
                byArray = this.encodeParameters((Map<String, String>)var2_2, Encoding);
            }
        }
        return byArray;
    }

    private String getBodyContentType() {
        return "application/x-www-form-urlencoded; charset=UTF-8";
    }

    private String getBodyContentTypeJson() {
        return "application/json; charset=UTF-8";
    }

    private String getParameterString(Map<String, String> params, String paramsEncoding) {
        if (params != null && params.size() > 0) {
            Exception exception;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                for (Map.Entry entry : exception.entrySet()) {
                    stringBuilder.append(URLEncoder.encode((String)entry.getKey(), paramsEncoding));
                    stringBuilder.append('=');
                    stringBuilder.append(URLEncoder.encode((String)entry.getValue(), paramsEncoding));
                    stringBuilder.append('&');
                }
                return stringBuilder.toString();
            }
            catch (Exception exception2) {
                exception = exception2;
                HttpURLConnectionClient.printErr(exception2);
                return null;
            }
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private byte[] encodeParameters(Map<String, String> params, String paramsEncoding) {
        try {
            void var1_1;
            return this.getParameterString((Map<String, String>)var1_1, paramsEncoding).getBytes(paramsEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void var2_3;
            System.out.println("Encoding not supported: " + (String)var2_3);
            HttpURLConnectionClient.printErr(unsupportedEncodingException);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addHeader(HttpURLConnection connection, Map<String, String> header) {
        block4: {
            void var1_1;
            block3: {
                void var2_2;
                if (header == null || header.size() <= 0) break block3;
                for (String string : header.keySet()) {
                    connection.addRequestProperty(string, header.get(string));
                }
                if (var2_2.keySet().contains(CONTENT_TYPE)) break block4;
            }
            var1_1.addRequestProperty(CONTENT_TYPE, this.getBodyContentType());
        }
    }

    private void disableConnectionReuseIfNecessary() {
    }

    private static void printErr(Exception e2) {
        Exception exception;
        aw.a("HttpURLConnectionClient", e2.getMessage(), exception);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean hasResponseBody(int requestMethod, int responseCode) {
        void var1_1;
        return requestMethod != 4 && (100 > responseCode || responseCode >= 200) && responseCode != 204 && var1_1 != 304;
    }

    private static InputStream inputStreamFromConnection(HttpURLConnection connection) {
        InputStream inputStream;
        try {
            inputStream = connection.getInputStream();
        }
        catch (IOException iOException) {
            HttpURLConnection httpURLConnection;
            inputStream = httpURLConnection.getErrorStream();
        }
        return inputStream;
    }

    static List<Header> convertHeaders(Map<String, List<String>> responseHeaders) {
        Object object;
        ArrayList<Header> arrayList = new ArrayList<Header>(responseHeaders.size());
        for (Map.Entry entry : object.entrySet()) {
            if (entry.getKey() == null) continue;
            for (String string : (List)entry.getValue()) {
                arrayList.add(new Header((String)entry.getKey(), string));
            }
        }
        return arrayList;
    }

    private static void trustAllHosts() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public final X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public final void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public final void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            HttpURLConnectionClient.printErr(exception);
            return;
        }
    }

    static class UrlConnectionInputStream
    extends FilterInputStream {
        private final HttpURLConnection mConnection;

        /*
         * WARNING - void declaration
         */
        UrlConnectionInputStream(HttpURLConnection connection) {
            super(HttpURLConnectionClient.inputStreamFromConnection(connection));
            void var1_1;
            this.mConnection = var1_1;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.mConnection != null) {
                this.mConnection.disconnect();
            }
        }
    }
}

