/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.padding;

import java.security.SecureRandom;
import tech.simkey.dove.encoding.HexStringConvert;
import tech.simkey.dove.exception.InvalidCipherTextException;

public class PKCS1EncodingV15 {
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private int bitSize;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private int inblockSize;
    private int outblockSize;
    private String hashAlgorithm;
    private static final String MD2_OID = "3020300c06082a864886f70d020205000410";
    private static final String MD5_OID = "3020300c06082a864886f70d020505000410";
    private static final String SHA1_OID = "3021300906052b0e03021a05000414";
    private static final String SHA256_OID = "3031300d060960864801650304020105000420";
    private static final String SHA384_OID = "3041300d060960864801650304020105000430";
    private static final String SHA512_OID = "3051300d060960864801650304020105000440";
    private static final String SHA224_OID = "302d300d06096086480165030402040500041c";
    private static final String SHA_512_224_OID = "302d300d06096086480165030402050500041c";
    private static final String SHA_512_256_OID = "3031300d060960864801650304020505000420";
    public static final String MD2 = "MD2";
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA1";
    public static final String SHA_224 = "SHA-224";
    public static final String SHA_256 = "SHA-256";
    public static final String SHA_384 = "SHA-384";
    public static final String SHA_512 = "SHA-512";
    public static final String SHA_512_224 = "SHA-512/224";
    public static final String SHA_512_256 = "SHA-512/256";

    /*
     * WARNING - void declaration
     */
    public PKCS1EncodingV15(int modulus, boolean forEncryption, boolean forPrivateKey, String hashAlgorithm) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.bitSize = var1_1;
        this.random = new SecureRandom();
        this.forPrivateKey = var3_3;
        this.forEncryption = forEncryption;
        this.hashAlgorithm = hashAlgorithm;
        if (var2_2 != false) {
            this.inblockSize = (this.bitSize + 7) / 8 - 1;
            this.outblockSize = (this.bitSize + 7) / 8;
            return;
        }
        this.inblockSize = (this.bitSize + 7) / 8;
        this.outblockSize = (this.bitSize + 7) / 8 - 1;
    }

    public int getInputBlockSize() {
        if (this.forEncryption) {
            return this.inblockSize - 10;
        }
        return this.inblockSize;
    }

    public int getOutputBlockSize() {
        if (this.forEncryption) {
            return this.outblockSize;
        }
        return this.outblockSize - 10;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] processBlock(byte[] inData, int inOff, int inLen) throws InvalidCipherTextException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.forEncryption) {
            byte[] byArray = this.addOID(inData);
            return this.encodeBlock(byArray, inOff, byArray.length - inData.length + inLen);
        }
        byte[] byArray = this.decodeBlock((byte[])var1_1, (int)var2_2, (int)var3_3);
        return this.removeOID(byArray);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (inLen > this.getInputBlockSize()) {
            throw new InvalidCipherTextException("input data too large");
        }
        byte[] byArray = new byte[this.inblockSize + 1];
        if (this.forPrivateKey) {
            byArray[0] = 0;
            byArray[1] = 1;
            for (int i2 = 2; i2 != byArray.length - inLen - 1; ++i2) {
                byArray[i2] = -1;
            }
        } else {
            this.random.nextBytes(byArray);
            byArray[0] = 0;
            byArray[1] = 2;
            for (int i3 = 2; i3 != byArray.length - inLen - 1; ++i3) {
                while (byArray[i3] == 0) {
                    byArray[i3] = (byte)this.random.nextInt();
                }
            }
        }
        byArray[byArray.length - inLen - 1] = 0;
        System.arraycopy(var1_1, (int)var2_2, byArray, byArray.length - inLen, (int)var3_3);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] decodeBlock(byte[] block, int inOff, int inLen) throws InvalidCipherTextException {
        void var1_1;
        byte by2;
        int n2;
        if (block.length < this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block truncated");
        }
        byte by3 = block[1];
        if (by3 != 1 && by3 != 2) {
            throw new InvalidCipherTextException("unknown block type");
        }
        if (block.length != this.outblockSize + 1) {
            throw new InvalidCipherTextException("block incorrect size");
        }
        for (n2 = 2; n2 != block.length && (by2 = block[n2]) != 0; ++n2) {
            if (by3 != 1 || by2 == -1) continue;
            throw new InvalidCipherTextException("block padding incorrect");
        }
        if (++n2 > block.length || n2 < 10) {
            throw new InvalidCipherTextException("no data in block");
        }
        byte[] byArray = new byte[block.length - n2];
        System.arraycopy(var1_1, n2, byArray, 0, byArray.length);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] addOID(byte[] inData) {
        if (inData == null) {
            return null;
        }
        if (this.hashAlgorithm == null) {
            return inData;
        }
        byte[] byArray = inData;
        if (MD5.equals(this.hashAlgorithm)) {
            byArray = PKCS1EncodingV15.appendBytes(HexStringConvert.parseHexStr2Byte(MD5_OID), inData);
        } else if (SHA1.equals(this.hashAlgorithm)) {
            byArray = PKCS1EncodingV15.appendBytes(HexStringConvert.parseHexStr2Byte(SHA1_OID), inData);
        } else if (SHA_256.equals(this.hashAlgorithm)) {
            byArray = PKCS1EncodingV15.appendBytes(HexStringConvert.parseHexStr2Byte(SHA256_OID), inData);
        } else if (SHA_384.equals(this.hashAlgorithm)) {
            byArray = PKCS1EncodingV15.appendBytes(HexStringConvert.parseHexStr2Byte(SHA384_OID), inData);
        } else if (SHA_512.equals(this.hashAlgorithm)) {
            byArray = PKCS1EncodingV15.appendBytes(HexStringConvert.parseHexStr2Byte(SHA512_OID), inData);
        } else if (MD2.equals(this.hashAlgorithm)) {
            byArray = PKCS1EncodingV15.appendBytes(HexStringConvert.parseHexStr2Byte(MD2_OID), inData);
        } else if (SHA_224.equals(this.hashAlgorithm)) {
            byArray = PKCS1EncodingV15.appendBytes(HexStringConvert.parseHexStr2Byte(SHA224_OID), inData);
        } else if (SHA_512_224.equals(this.hashAlgorithm)) {
            byArray = PKCS1EncodingV15.appendBytes(HexStringConvert.parseHexStr2Byte(SHA_512_224_OID), inData);
        } else if (SHA_512_256.equals(this.hashAlgorithm)) {
            void var1_1;
            byArray = PKCS1EncodingV15.appendBytes(HexStringConvert.parseHexStr2Byte(SHA_512_256_OID), (byte[])var1_1);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] removeOID(byte[] outData) {
        void var1_1;
        String string = HexStringConvert.parseByte2HexStr(outData);
        if (string != null) {
            string = string.toLowerCase();
            if (MD5.equals(this.hashAlgorithm)) {
                String string2 = string.replace(MD5_OID, "");
                outData = string2;
                return HexStringConvert.parseHexStr2Byte(string2);
            }
            if (SHA1.equals(this.hashAlgorithm)) {
                String string3 = string.replace(SHA1_OID, "");
                outData = string3;
                return HexStringConvert.parseHexStr2Byte(string3);
            }
            if (SHA_256.equals(this.hashAlgorithm)) {
                String string4 = string.replace(SHA256_OID, "");
                outData = string4;
                return HexStringConvert.parseHexStr2Byte(string4);
            }
            if (SHA_384.equals(this.hashAlgorithm)) {
                String string5 = string.replace(SHA384_OID, "");
                outData = string5;
                return HexStringConvert.parseHexStr2Byte(string5);
            }
            if (SHA_512.equals(this.hashAlgorithm)) {
                String string6 = string.replace(SHA512_OID, "");
                outData = string6;
                return HexStringConvert.parseHexStr2Byte(string6);
            }
            if (MD2.equals(this.hashAlgorithm)) {
                String string7 = string.replace(MD2_OID, "");
                outData = string7;
                return HexStringConvert.parseHexStr2Byte(string7);
            }
            if (SHA_224.equals(this.hashAlgorithm)) {
                String string8 = string.replace(SHA224_OID, "");
                outData = string8;
                return HexStringConvert.parseHexStr2Byte(string8);
            }
            if (SHA_512_224.equals(this.hashAlgorithm)) {
                String string9 = string.replace(SHA_512_224_OID, "");
                outData = string9;
                return HexStringConvert.parseHexStr2Byte(string9);
            }
            if (SHA_512_256.equals(this.hashAlgorithm)) {
                String string10 = string.replace(SHA_512_256_OID, "");
                outData = string10;
                return HexStringConvert.parseHexStr2Byte(string10);
            }
        }
        return var1_1;
    }

    private static byte[] appendBytes(byte[] left, byte[] right) {
        int n2;
        byte[] byArray = new byte[left.length + right.length];
        for (n2 = 0; n2 < left.length; ++n2) {
            byArray[n2] = left[n2];
        }
        for (n2 = 0; n2 < right.length; ++n2) {
            byArray[left.length + n2] = right[n2];
        }
        return byArray;
    }
}

