/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import simkey.kms.aw;

public final class TimestampUtil {
    private static final String DEFAULT_FORMATTER_STRING = "yyyyMMddHHmmss";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final Map<String, SimpleDateFormat> formatterCache = new HashMap<String, SimpleDateFormat>(10);

    public static DateFormat getDateFormater() {
        SimpleDateFormat simpleDateFormat = formatterCache.get(DEFAULT_FORMATTER_STRING);
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(DEFAULT_FORMATTER_STRING, Locale.getDefault());
            formatterCache.put(DEFAULT_FORMATTER_STRING, simpleDateFormat);
        }
        return simpleDateFormat;
    }

    public static String getTimeStamp() {
        return TimestampUtil.getDateFormater().format(new Date());
    }

    public static Date parserToDate(String date) throws ParseException {
        String string;
        return TimestampUtil.getDateFormater().parse(string);
    }

    public static String parserDateToString(Date date) {
        Serializable serializable;
        try {
            return TimestampUtil.getDateFormater().format((Date)serializable);
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String parserDateToString(Date date, String dateFormatter) {
        try {
            Date date2;
            SimpleDateFormat simpleDateFormat = formatterCache.get(dateFormatter);
            if (simpleDateFormat == null) {
                void var1_1;
                simpleDateFormat = new SimpleDateFormat(dateFormatter, Locale.getDefault());
                formatterCache.put((String)var1_1, simpleDateFormat);
            }
            return simpleDateFormat.format(date2);
        }
        catch (Exception exception) {
            aw.a("parserDateToString", exception.getMessage(), exception);
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Date parserToDate(String date, String dateFormatter) {
        try {
            String string;
            SimpleDateFormat simpleDateFormat = formatterCache.get(dateFormatter);
            if (simpleDateFormat == null) {
                void var1_1;
                simpleDateFormat = new SimpleDateFormat(dateFormatter, Locale.getDefault());
                formatterCache.put((String)var1_1, simpleDateFormat);
            }
            return simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            aw.a("parserDateToString", exception.getMessage(), exception);
            return null;
        }
    }

    public static Date parserTimeStampAuto(String date) {
        try {
            String string;
            if (date.length() == 14) {
                return TimestampUtil.parserToDate(date, DEFAULT_FORMATTER_STRING);
            }
            if (date.length() == 19) {
                return TimestampUtil.parserToDate(date, YYYY_MM_DD_HH_MM_SS);
            }
            aw.e("parserTimeStampAuto", "unknown type:" + string);
            return null;
        }
        catch (Exception exception) {
            aw.a("parserDateToString", exception.getMessage(), exception);
            return null;
        }
    }

    public static String getTimeStamp(String dateFormatter) {
        SimpleDateFormat simpleDateFormat = formatterCache.get(dateFormatter);
        if (simpleDateFormat == null) {
            String string;
            simpleDateFormat = new SimpleDateFormat(dateFormatter, Locale.getDefault());
            formatterCache.put(string, simpleDateFormat);
        }
        return simpleDateFormat.format(new Date());
    }
}

