/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.utils;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class NumberFormater {
    public static String format(double num) {
        return new DecimalFormat(",###.##").format(num);
    }

    public static String format(int num) {
        return new DecimalFormat(",###.##").format(num);
    }

    public static String format(long num) {
        return new DecimalFormat(",###.##").format(num);
    }

    public static String distanceFormat(int meter) {
        String unit;
        double distenct;
        StringBuilder sb = new StringBuilder();
        if ((long)meter > 1000L) {
            int tmp = meter / 10;
            distenct = (double)tmp / 100.0;
            unit = "km";
        } else {
            distenct = meter;
            unit = "m";
        }
        sb.setLength(0);
        sb.append(NumberFormater.format(distenct)).append(unit);
        return sb.toString();
    }

    public static int parseInt(String intStr, int defaultValue) {
        try {
            return Integer.parseInt(intStr);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public static double parseDouble(String doubleStr, double defaultValue) {
        try {
            return Double.parseDouble(doubleStr);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public static String parseDoubleToPercent(double doubleValue) {
        try {
            NumberFormat fmt = NumberFormat.getPercentInstance();
            fmt.setMaximumFractionDigits(2);
            return fmt.format(doubleValue);
        }
        catch (Exception e2) {
            return String.valueOf(doubleValue);
        }
    }

    public static String parseDoubleToPercent(String doubleValue) {
        try {
            String dValue = doubleValue;
            if (doubleValue.length() > 5) {
                dValue = doubleValue.substring(0, 5);
            }
            return NumberFormater.parseDoubleToPercent(NumberFormater.parseDouble(doubleValue, 0.0));
        }
        catch (Exception e2) {
            return String.valueOf(doubleValue);
        }
    }

    public static String friendFileSize(long byteArrayLen) {
        double kb = (double)byteArrayLen / 1024.0;
        if (kb < 1025.0) {
            return NumberFormater.format(kb) + " KB";
        }
        double mb = kb / 1024.0;
        if (mb < 1025.0) {
            return NumberFormater.format(mb) + " MB";
        }
        double gb = mb / 1024.0;
        return NumberFormater.format(gb) + " GB";
    }

    public static String friendTimeUsed(long milliseconds, boolean withMills) {
        long mills = milliseconds % 1000L;
        long totalSeconds = milliseconds / 1000L;
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (withMills) {
            if (hours > 0L) {
                return String.format("%02d\u5c0f\u65f6%02d\u5206%02d\u79d2%03d\u6beb\u79d2", hours, minutes, seconds, mills);
            }
            if (minutes > 0L) {
                return String.format("%02d\u5206%02d\u79d2%03d\u6beb\u79d2", minutes, seconds, mills);
            }
            return String.format("%02d\u79d2%03d\u6beb\u79d2", seconds, mills);
        }
        if (hours > 0L) {
            return String.format("%02d\u5c0f\u65f6%02d\u5206%02d\u79d2", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%02d\u5206%02d\u79d2", minutes, seconds);
        }
        return String.format("%02d\u79d2", seconds);
    }
}

