/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.utils;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.simkey.dove.util.ParamsEmptyChecker;

public class StringUtils {
    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p2 = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m2 = p2.matcher(str);
            dest = m2.replaceAll("");
        }
        return dest;
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static boolean isSame(String left, String right) {
        if (left == null) {
            return right == null;
        }
        return left.equals(right);
    }

    public static String addColonForMacaddress(String mac) {
        if (ParamsEmptyChecker.isEmpty(mac)) {
            return "";
        }
        if (mac.length() == 12) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < mac.length(); i2 += 2) {
                if (i2 != 0) {
                    sb.append(":");
                }
                sb.append(mac.charAt(i2));
                sb.append(mac.charAt(i2 + 1));
            }
            return sb.toString().toUpperCase();
        }
        return mac.toUpperCase();
    }

    public static String addColon(String hex) {
        if (ParamsEmptyChecker.isEmpty(hex)) {
            return "";
        }
        if (hex.length() % 2 == 0) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < hex.length(); i2 += 2) {
                if (i2 != 0) {
                    sb.append(":");
                }
                sb.append(hex.charAt(i2));
                sb.append(hex.charAt(i2 + 1));
            }
            return sb.toString().toUpperCase();
        }
        throw new IllegalArgumentException("addColon \u4f20\u5165\u7684\u503c\u5fc5\u987b\u662f\u5341\u516d\u8fdb\u5236\u5b57\u7b26\u4e32, \u5b83\u662f\u5076\u6570\u7684\u957f\u5ea6");
    }

    public static String newStringNoTailZero(byte[] data, Charset charset) {
        int lastPos = data.length - 1;
        while (data[lastPos] == 0 && --lastPos >= 0) {
        }
        return new String(data, 0, lastPos + 1, charset);
    }

    public static String initialToCapital(String s2) {
        String[] split;
        StringBuilder sb = new StringBuilder();
        if (s2 == null || s2.trim().isEmpty()) {
            return sb.toString();
        }
        if (s2.length() <= 1) {
            return sb.append(s2).toString().toUpperCase();
        }
        for (String string : split = s2.split("_")) {
            sb.append(string.substring(0, 1).toUpperCase());
            sb.append(string.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static String capitalToInitial(String s2) {
        StringBuilder sb = new StringBuilder();
        if (s2 == null || s2.trim().isEmpty()) {
            return sb.toString();
        }
        if (s2.length() <= 1) {
            return sb.append(s2).toString().toLowerCase();
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char charAt = s2.charAt(i2);
            if (Character.isUpperCase(charAt)) {
                sb.append("_");
                sb.append(Character.toLowerCase(charAt));
                continue;
            }
            sb.append(charAt);
        }
        return sb.toString();
    }

    public static String formate(String template, Map<String, Object> params) {
        String result = template;
        for (Map.Entry<String, Object> param : params.entrySet()) {
            String paramkey = String.format(Locale.CHINA, "${%s}", param.getKey());
            result = result.replace(paramkey, String.valueOf(param.getValue()));
        }
        return result;
    }

    public static String[] split(String str, String splitToken) {
        int lastIndex = 0;
        int fromIndexFroSearch = 0;
        ArrayList<String> result = new ArrayList<String>();
        while (true) {
            int indexYinhao = str.indexOf("\"", fromIndexFroSearch);
            int indexToken = str.indexOf(splitToken, fromIndexFroSearch);
            if (indexToken < 0) {
                String substr = str.substring(lastIndex);
                if (ParamsEmptyChecker.isEmpty(substr)) break;
                result.add(substr);
                break;
            }
            if (indexYinhao >= 0 && indexYinhao < indexToken) {
                int indexEndYinhao = str.indexOf("\"", lastIndex + 1);
                fromIndexFroSearch = indexEndYinhao + 1;
                continue;
            }
            String substr = str.substring(lastIndex, indexToken);
            if (!ParamsEmptyChecker.isEmpty(substr)) {
                result.add(substr);
            }
            fromIndexFroSearch = lastIndex = indexToken + splitToken.length();
        }
        String[] strArray = new String[result.size()];
        result.toArray(strArray);
        return strArray;
    }

    public static String subStringKeyword(String str, String keyword) {
        int index = str.indexOf(keyword);
        if (index >= 0) {
            return str.substring(index + keyword.length());
        }
        return "";
    }

    public static List<String> subStringBetweenKeyword(String str, String keywordStart, boolean withKeywordStart, String keywordEnd, boolean withKeywordEnd) {
        ArrayList<String> result = new ArrayList<String>();
        int startIndex = -1;
        int endIndex = -1;
        while ((startIndex = str.indexOf(keywordStart, endIndex + 1)) >= 0) {
            endIndex = str.indexOf(keywordEnd, startIndex + 1);
            int start = startIndex + keywordStart.length();
            if (withKeywordStart) {
                start = startIndex;
            }
            int end = endIndex;
            if (withKeywordEnd) {
                end = endIndex + keywordEnd.length();
            }
            result.add(str.substring(start, end));
        }
        return result;
    }

    public static String getFileNameWithoutExtension(String fileNameWithExtension) {
        int col = fileNameWithExtension.lastIndexOf(".");
        return fileNameWithExtension.substring(0, col);
    }

    public static String getFileNameExtension(String fileNameWithExtension) {
        int col = fileNameWithExtension.lastIndexOf(".");
        return fileNameWithExtension.substring(col + 1);
    }

    public static void main(String[] agrs) {
    }
}

