/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.pkcs.gmt0010;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import tech.simkey.pkcs.gmt0010.ContentEncryptionAlgorithmIdentifier;
import tech.simkey.pkcs.gmt0010.ContentType;
import tech.simkey.pkcs.gmt0010.EncryptedContent;

public class EncryptedContentInfo
implements ASN1Encodable {
    private ContentType contentType = new ContentType();
    private ContentEncryptionAlgorithmIdentifier contentEncryptionAlgorithmIdentifier;
    private EncryptedContent encryptedContent;

    public static EncryptedContentInfo getInstance(Object obj) {
        if (obj instanceof EncryptedContentInfo) {
            return (EncryptedContentInfo)obj;
        }
        if (obj != null) {
            Object object;
            return new EncryptedContentInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public EncryptedContentInfo(ContentEncryptionAlgorithmIdentifier contentEncryptionAlgorithmIdentifier, EncryptedContent encryptedContent) {
        void var2_2;
        void var1_1;
        this.contentEncryptionAlgorithmIdentifier = var1_1;
        this.encryptedContent = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private EncryptedContentInfo(ASN1Sequence sequence) {
        void var1_1;
        this.contentEncryptionAlgorithmIdentifier = ContentEncryptionAlgorithmIdentifier.getInstance(sequence.getObjectAt(1));
        this.encryptedContent = EncryptedContent.getInstance(var1_1.getObjectAt(2));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.contentType);
        aSN1EncodableVector.add(this.contentEncryptionAlgorithmIdentifier);
        aSN1EncodableVector.add(this.encryptedContent);
        return new DERSequence(aSN1EncodableVector);
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public ContentEncryptionAlgorithmIdentifier getContentEncryptionAlgorithmIdentifier() {
        return this.contentEncryptionAlgorithmIdentifier;
    }

    public EncryptedContent getEncryptedContent() {
        return this.encryptedContent;
    }
}

