/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.solon.integration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.HashMap;

class LogbackConfigurator {
    private final LoggerContext context;

    LogbackConfigurator(LoggerContext context) {
        this.context = context;
    }

    LoggerContext getContext() {
        return this.context;
    }

    Object getConfigurationLock() {
        return this.context.getConfigurationLock();
    }

    void conversionRule(String conversionWord, Class<? extends Converter> converterClass) {
        HashMap<String, String> registry = (HashMap<String, String>)this.context.getObject("PATTERN_RULE_REGISTRY");
        if (registry == null) {
            registry = new HashMap<String, String>();
            this.context.putObject("PATTERN_RULE_REGISTRY", registry);
        }
        registry.put(conversionWord, converterClass.getName());
    }

    void appender(String name, Appender<?> appender) {
        appender.setName(name);
        this.start(appender);
    }

    void logger(String name, Level level) {
        this.logger(name, level, true);
    }

    void logger(String name, Level level, boolean additive) {
        this.logger(name, level, additive, null);
    }

    void logger(String name, Level level, boolean additive, Appender<ILoggingEvent> appender) {
        Logger logger2 = this.context.getLogger(name);
        if (level != null) {
            logger2.setLevel(level);
        }
        logger2.setAdditive(additive);
        if (appender != null) {
            logger2.addAppender(appender);
        }
    }

    @SafeVarargs
    final void root(Level level, Appender<ILoggingEvent> ... appenders) {
        Logger logger2 = this.context.getLogger("ROOT");
        if (level != null) {
            logger2.setLevel(level);
        }
        for (Appender<ILoggingEvent> appender : appenders) {
            logger2.addAppender(appender);
        }
    }

    void start(LifeCycle lifeCycle) {
        if (lifeCycle instanceof ContextAware) {
            ((ContextAware)((Object)lifeCycle)).setContext(this.context);
        }
        lifeCycle.start();
    }
}

