/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.captcha.generator.RandomGenerator;
import cn.hutool.core.img.GraphicsUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.RandomUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.ThreadLocalRandom;

public class LineCaptcha
extends AbstractCaptcha {
    private static final long serialVersionUID = 8691294460763091089L;

    public LineCaptcha(int width, int height) {
        this(width, height, 5, 150);
    }

    public LineCaptcha(int width, int height, int codeCount, int lineCount) {
        this(width, height, new RandomGenerator(codeCount), lineCount);
    }

    public LineCaptcha(int width, int height, CodeGenerator generator, int interfereCount) {
        super(width, height, generator, interfereCount);
    }

    public LineCaptcha(int width, int height, int codeCount, int interfereCount, float size) {
        super(width, height, new RandomGenerator(codeCount), interfereCount, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image createImage(String code) {
        BufferedImage image = new BufferedImage(this.width, this.height, null == this.background ? 6 : 1);
        Graphics2D g2 = ImgUtil.createGraphics(image, this.background);
        try {
            this.drawInterfere(g2);
            this.drawString(g2, code);
        }
        finally {
            g2.dispose();
        }
        return image;
    }

    private void drawString(Graphics2D g2, String code) {
        if (null != this.textAlpha) {
            g2.setComposite(this.textAlpha);
        }
        GraphicsUtil.drawStringColourful(g2, code, this.font, this.width, this.height);
    }

    private void drawInterfere(Graphics2D g2) {
        ThreadLocalRandom random = RandomUtil.getRandom();
        for (int i = 0; i < this.interfereCount; ++i) {
            int xs = random.nextInt(this.width);
            int ys = random.nextInt(this.height);
            int xe = xs + random.nextInt(this.width / 8);
            int ye = ys + random.nextInt(this.height / 8);
            g2.setColor(ImgUtil.randomColor(random));
            g2.drawLine(xs, ys, xe, ye);
        }
    }
}

