/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.captcha.generator.RandomGenerator;
import cn.hutool.core.img.GraphicsUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ShearCaptcha
extends AbstractCaptcha {
    private static final long serialVersionUID = -7096627300356535494L;

    public ShearCaptcha(int width, int height) {
        this(width, height, 5);
    }

    public ShearCaptcha(int width, int height, int codeCount) {
        this(width, height, codeCount, 4);
    }

    public ShearCaptcha(int width, int height, int codeCount, int thickness) {
        this(width, height, new RandomGenerator(codeCount), thickness);
    }

    public ShearCaptcha(int width, int height, CodeGenerator generator, int interfereCount) {
        super(width, height, generator, interfereCount);
    }

    public ShearCaptcha(int width, int height, int codeCount, int interfereCount, float size) {
        super(width, height, new RandomGenerator(codeCount), interfereCount, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image createImage(String code) {
        BufferedImage image = new BufferedImage(this.width, this.height, null == this.background ? 6 : 1);
        Graphics2D g2 = ImgUtil.createGraphics(image, this.background);
        try {
            this.drawString(g2, code);
            this.shear(g2, this.width, this.height, ObjectUtil.defaultIfNull(this.background, Color.WHITE));
            this.drawInterfere(g2, 0, RandomUtil.randomInt(this.height) + 1, this.width, RandomUtil.randomInt(this.height) + 1, this.interfereCount, ImgUtil.randomColor());
        }
        finally {
            g2.dispose();
        }
        return image;
    }

    private void drawString(Graphics2D g2, String code) {
        if (null != this.textAlpha) {
            g2.setComposite(this.textAlpha);
        }
        GraphicsUtil.drawStringColourful(g2, code, this.font, this.width, this.height);
    }

    private void shear(Graphics g2, int w1, int h1, Color color) {
        this.shearX(g2, w1, h1, color);
        this.shearY(g2, w1, h1, color);
    }

    private void shearX(Graphics g2, int w1, int h1, Color color) {
        int period = RandomUtil.randomInt(this.width);
        boolean frames = true;
        int phase = RandomUtil.randomInt(2);
        for (int i = 0; i < h1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g2.copyArea(0, i, w1, 1, (int)d, 0);
            g2.setColor(color);
            g2.drawLine((int)d, i, 0, i);
            g2.drawLine((int)d + w1, i, w1, i);
        }
    }

    private void shearY(Graphics g2, int w1, int h1, Color color) {
        int period = RandomUtil.randomInt(this.height >> 1);
        int frames = 20;
        int phase = 7;
        for (int i = 0; i < w1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g2.copyArea(i, 0, 1, h1, 0, (int)d);
            g2.setColor(color);
            g2.drawLine(i, (int)d, i, 0);
            g2.drawLine(i, (int)d + h1, i, h1);
        }
    }

    private void drawInterfere(Graphics g2, int x1, int y1, int x2, int y2, int thickness, Color c) {
        g2.setColor(c);
        int dX = x2 - x1;
        int dY = y2 - y1;
        double lineLength = Math.sqrt(dX * dX + dY * dY);
        double scale = (double)thickness / (2.0 * lineLength);
        double ddx = -scale * (double)dY;
        double ddy = scale * (double)dX;
        double d = ddy > 0.0 ? 0.5 : -0.5;
        int dx = (int)(ddx += ddx > 0.0 ? 0.5 : -0.5);
        int dy = (int)(ddy += d);
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        xPoints[0] = x1 + dx;
        yPoints[0] = y1 + dy;
        xPoints[1] = x1 - dx;
        yPoints[1] = y1 - dy;
        xPoints[2] = x2 - dx;
        yPoints[2] = y2 - dy;
        xPoints[3] = x2 + dx;
        yPoints[3] = y2 + dy;
        g2.fillPolygon(xPoints, yPoints, 4);
    }
}

