/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;

public class NumberWordFormatter {
    private static final String[] NUMBER = new String[]{"", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"};
    private static final String[] NUMBER_TEEN = new String[]{"TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"};
    private static final String[] NUMBER_TEN = new String[]{"TEN", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
    private static final String[] NUMBER_MORE = new String[]{"", "THOUSAND", "MILLION", "BILLION", "TRILLION"};
    private static final String[] NUMBER_SUFFIX = new String[]{"k", "w", "", "m", "", "", "b", "", "", "t", "", "", "p", "", "", "e"};

    public static String format(Object x) {
        if (x != null) {
            return NumberWordFormatter.format(x.toString());
        }
        return "";
    }

    public static String formatSimple(long value) {
        return NumberWordFormatter.formatSimple(value, true);
    }

    public static String formatSimple(long value, boolean isTwo) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        int index = -1;
        double res = value;
        while (res > 10.0 && (!isTwo || index < 1)) {
            if (res >= 1000.0) {
                res /= 1000.0;
                ++index;
            }
            if (!(res > 10.0)) continue;
            res /= 10.0;
            ++index;
        }
        return String.format("%s%s", NumberUtil.decimalFormat("#.##", res), NUMBER_SUFFIX[index]);
    }

    private static String format(String x) {
        String xs;
        String lstr;
        int z = x.indexOf(".");
        String rstr = "";
        if (z > -1) {
            lstr = x.substring(0, z);
            rstr = x.substring(z + 1);
        } else {
            lstr = x;
        }
        String lstrrev = StrUtil.reverse(lstr);
        String[] a = new String[5];
        switch (lstrrev.length() % 3) {
            case 1: {
                lstrrev = lstrrev + "00";
                break;
            }
            case 2: {
                lstrrev = lstrrev + "0";
            }
        }
        StringBuilder lm = new StringBuilder();
        for (int i = 0; i < lstrrev.length() / 3; ++i) {
            a[i] = StrUtil.reverse(lstrrev.substring(3 * i, 3 * i + 3));
            if (!"000".equals(a[i])) {
                if (i != 0) {
                    lm.insert(0, NumberWordFormatter.transThree(a[i]) + " " + NumberWordFormatter.parseMore(i) + " ");
                    continue;
                }
                lm = new StringBuilder(NumberWordFormatter.transThree(a[i]));
                continue;
            }
            lm.append(NumberWordFormatter.transThree(a[i]));
        }
        String string = xs = lm.length() == 0 ? "ZERO " : " ";
        if (z > -1) {
            xs = xs + "AND CENTS " + NumberWordFormatter.transTwo(rstr) + " ";
        }
        return lm.toString().trim() + xs + "ONLY";
    }

    private static String parseTeen(String s2) {
        return NUMBER_TEEN[Integer.parseInt(s2) - 10];
    }

    private static String parseTen(String s2) {
        return NUMBER_TEN[Integer.parseInt(s2.substring(0, 1)) - 1];
    }

    private static String parseMore(int i) {
        return NUMBER_MORE[i];
    }

    private static String transTwo(String s2) {
        if (s2.length() > 2) {
            s2 = s2.substring(0, 2);
        } else if (s2.length() < 2) {
            s2 = s2 + "0";
        }
        String value = s2.startsWith("0") ? NumberWordFormatter.parseLast(s2) : (s2.startsWith("1") ? NumberWordFormatter.parseTeen(s2) : (s2.endsWith("0") ? NumberWordFormatter.parseTen(s2) : NumberWordFormatter.parseTen(s2) + " " + NumberWordFormatter.parseLast(s2)));
        return value;
    }

    private static String transThree(String s2) {
        String value = s2.startsWith("0") ? NumberWordFormatter.transTwo(s2.substring(1)) : ("00".equals(s2.substring(1)) ? NumberWordFormatter.parseLast(s2.substring(0, 1)) + " HUNDRED" : NumberWordFormatter.parseLast(s2.substring(0, 1)) + " HUNDRED AND " + NumberWordFormatter.transTwo(s2.substring(1)));
        return value;
    }

    private static String parseLast(String s2) {
        return NUMBER[Integer.parseInt(s2.substring(s2.length() - 1))];
    }
}

