/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class TableMap<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_CAPACITY = 10;
    private final List<K> keys;
    private final List<V> values;

    public TableMap() {
        this(10);
    }

    public TableMap(int size) {
        this.keys = new ArrayList<K>(size);
        this.values = new ArrayList<V>(size);
    }

    public TableMap(K[] keys, V[] values) {
        this.keys = CollUtil.toList(keys);
        this.values = CollUtil.toList(values);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return CollUtil.isEmpty(this.keys);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public V get(Object key) {
        int index = this.keys.indexOf(key);
        if (index > -1) {
            return this.values.get(index);
        }
        return null;
    }

    public K getKey(V value) {
        int index = this.values.indexOf(value);
        if (index > -1) {
            return this.keys.get(index);
        }
        return null;
    }

    public List<V> getValues(K key) {
        return CollUtil.getAny(this.values, ListUtil.indexOfAll(this.keys, ele -> ObjectUtil.equal(ele, key)));
    }

    public List<K> getKeys(V value) {
        return CollUtil.getAny(this.keys, ListUtil.indexOfAll(this.values, ele -> ObjectUtil.equal(ele, value)));
    }

    @Override
    public V put(K key, V value) {
        this.keys.add(key);
        this.values.add(value);
        return null;
    }

    @Override
    public V remove(Object key) {
        int index;
        V lastValue = null;
        while ((index = this.keys.indexOf(key)) > -1) {
            lastValue = this.removeByIndex(index);
        }
        return lastValue;
    }

    public V removeByIndex(int index) {
        this.keys.remove(index);
        return this.values.remove(index);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        for (Map.Entry<K, V> entry : m4.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public Set<K> keySet() {
        return new HashSet<K>(this.keys);
    }

    public List<K> keys() {
        return Collections.unmodifiableList(this.keys);
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> hashSet = new LinkedHashSet<Map.Entry<K, V>>();
        for (int i = 0; i < this.size(); ++i) {
            hashSet.add(MapUtil.entry(this.keys.get(i), this.values.get(i)));
        }
        return hashSet;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new Iterator<Map.Entry<K, V>>(){
            private final Iterator<K> keysIter;
            private final Iterator<V> valuesIter;
            {
                this.keysIter = TableMap.this.keys.iterator();
                this.valuesIter = TableMap.this.values.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.keysIter.hasNext() && this.valuesIter.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                return MapUtil.entry(this.keysIter.next(), this.valuesIter.next());
            }

            @Override
            public void remove() {
                this.keysIter.remove();
                this.valuesIter.remove();
            }
        };
    }

    public String toString() {
        return "TableMap{keys=" + this.keys + ", values=" + this.values + '}';
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (int i = 0; i < this.size(); ++i) {
            action.accept(this.keys.get(i), this.values.get(i));
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean removed = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!ObjUtil.equals(key, this.keys.get(i)) || !ObjUtil.equals(value, this.values.get(i))) continue;
            this.removeByIndex(i);
            removed = true;
            --i;
        }
        return removed;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        for (int i = 0; i < this.size(); ++i) {
            V newValue = function.apply(this.keys.get(i), this.values.get(i));
            this.values.set(i, newValue);
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        for (int i = 0; i < this.size(); ++i) {
            if (!ObjUtil.equals(key, this.keys.get(i)) || !ObjUtil.equals(oldValue, this.values.get(i))) continue;
            this.values.set(i, newValue);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        V lastValue = null;
        for (int i = 0; i < this.size(); ++i) {
            if (!ObjUtil.equals(key, this.keys.get(i))) continue;
            lastValue = this.values.set(i, value);
        }
        return lastValue;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (null == remappingFunction) {
            return null;
        }
        V lastValue = null;
        for (int i = 0; i < this.size(); ++i) {
            if (!ObjUtil.equals(key, this.keys.get(i))) continue;
            V newValue = remappingFunction.apply(key, this.values.get(i));
            if (null != newValue) {
                lastValue = this.values.set(i, newValue);
                continue;
            }
            this.removeByIndex(i);
            --i;
        }
        return lastValue;
    }
}

