/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import javax.net.SocketFactory;

public class ProxySocketFactory
extends SocketFactory {
    private final Proxy proxy;

    public static ProxySocketFactory of(Proxy proxy) {
        return new ProxySocketFactory(proxy);
    }

    public ProxySocketFactory(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public Socket createSocket() {
        if (this.proxy != null) {
            return new Socket(this.proxy);
        }
        return new Socket();
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        if (this.proxy != null) {
            Socket s2 = new Socket(this.proxy);
            s2.connect(new InetSocketAddress(address, port));
            return s2;
        }
        return new Socket(address, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        if (this.proxy != null) {
            Socket s2 = new Socket(this.proxy);
            s2.bind(new InetSocketAddress(localAddr, localPort));
            s2.connect(new InetSocketAddress(address, port));
            return s2;
        }
        return new Socket(address, port, localAddr, localPort);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        if (this.proxy != null) {
            Socket s2 = new Socket(this.proxy);
            s2.connect(new InetSocketAddress(host, port));
            return s2;
        }
        return new Socket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        if (this.proxy != null) {
            Socket s2 = new Socket(this.proxy);
            s2.bind(new InetSocketAddress(localAddr, localPort));
            s2.connect(new InetSocketAddress(host, port));
            return s2;
        }
        return new Socket(host, port, localAddr, localPort);
    }
}

