/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.jboss;

import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLog;
import cn.hutool.log.level.Level;
import org.jboss.logging.Logger;

public class JbossLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Logger logger;

    public JbossLog(Logger logger2) {
        this.logger = logger2;
    }

    public JbossLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public JbossLog(String name) {
        this(Logger.getLogger(name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String fqcn, Throwable t2, String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.logger.trace(fqcn, StrUtil.format(format, arguments), t2);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String fqcn, Throwable t2, String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.logger.debug(fqcn, StrUtil.format(format, arguments), t2);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String fqcn, Throwable t2, String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.logger.info(fqcn, StrUtil.format(format, arguments), t2);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabled(Logger.Level.WARN);
    }

    @Override
    public void warn(String fqcn, Throwable t2, String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.logger.warn(fqcn, StrUtil.format(format, arguments), t2);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabled(Logger.Level.ERROR);
    }

    @Override
    public void error(String fqcn, Throwable t2, String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.logger.error(fqcn, StrUtil.format(format, arguments), t2);
        }
    }

    @Override
    public void log(String fqcn, Level level, Throwable t2, String format, Object ... arguments) {
        switch (level) {
            case TRACE: {
                this.trace(fqcn, t2, format, arguments);
                break;
            }
            case DEBUG: {
                this.debug(fqcn, t2, format, arguments);
                break;
            }
            case INFO: {
                this.info(fqcn, t2, format, arguments);
                break;
            }
            case WARN: {
                this.warn(fqcn, t2, format, arguments);
                break;
            }
            case ERROR: {
                this.error(fqcn, t2, format, arguments);
                break;
            }
            default: {
                throw new Error(StrUtil.format("Can not identify level: {}", new Object[]{level}));
            }
        }
    }
}

