/*
 * Decompiled with CFR 0.152.
 */
package com.cym;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.RuntimeUtil;
import com.cym.utils.JarUtil;
import com.cym.utils.SystemTool;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Solon;
import org.noear.solon.annotation.SolonMain;
import org.noear.solon.scheduling.annotation.EnableScheduling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnableScheduling
@SolonMain
public class NginxWebUI {
    static Logger logger = LoggerFactory.getLogger(NginxWebUI.class);

    public static void main(String[] args) {
        boolean findPass = false;
        Object initAdmin = null;
        Object initPass = null;
        if (args != null) {
            for (String arg : args) {
                if (!arg.equals("--project.findPass=true")) continue;
                findPass = true;
            }
        }
        try {
            if (!findPass) {
                NginxWebUI.killSelf(args);
                NginxWebUI.removeJar();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        Solon.start(NginxWebUI.class, args);
    }

    public static void killSelf(String[] args) {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String myPid = runtimeMXBean.getName().split("@")[0];
        List<String> pids = NginxWebUI.getProcessId();
        for (String pid : pids) {
            if (pid.equals(myPid)) continue;
            logger.info("\u6740\u6389\u65e7\u8fdb\u7a0b:" + pid);
            if (SystemTool.isWindows().booleanValue()) {
                RuntimeUtil.exec("taskkill /F /PID " + pid);
                ThreadUtil.safeSleep(1000L);
                continue;
            }
            if (!SystemTool.isLinux().booleanValue()) continue;
            RuntimeUtil.exec("kill -9 " + pid);
        }
    }

    private static List<String> getProcessId() {
        ArrayList<String> pids = new ArrayList<String>();
        if (SystemTool.isWindows().booleanValue()) {
            List<String> list = RuntimeUtil.execForLines("wmic process where \"CommandLine like '%nginxWebUI%'\" get ProcessId,CommandLine");
            for (String line : list) {
                if (!line.contains(".jar")) continue;
                String[] lines = line.split("\\s+");
                pids.add(lines[lines.length - 1]);
            }
        } else {
            List<String> list = RuntimeUtil.execForLines("/bin/sh", "-c", "ps -ef | grep nginxWebUI");
            for (String line : list) {
                if (!line.contains(".jar") || line.contains("nginxWebUI-Website")) continue;
                String[] lines = line.split("\\s+");
                pids.add(lines[1]);
            }
        }
        return pids;
    }

    private static void removeJar() {
        File[] list;
        for (File file : list = new File(JarUtil.getCurrentFilePath()).getParentFile().listFiles()) {
            if (!file.getName().startsWith("nginxWebUI") || !file.getName().endsWith(".jar") || file.getPath().equals(JarUtil.getCurrentFilePath())) continue;
            FileUtil.del(file);
            logger.info("\u5220\u9664\u65e7\u6587\u4ef6:" + file);
        }
    }
}

