/*
 * Decompiled with CFR 0.152.
 */
package com.cym.config;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.cym.config.VersionConfig;
import com.cym.model.Admin;
import com.cym.model.Message;
import com.cym.model.Remote;
import com.cym.service.AdminService;
import com.cym.service.CreditService;
import com.cym.service.SettingService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.MessageUtils;
import com.cym.utils.PropertiesUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AppFilter
implements Filter {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    AdminService adminService;
    @Inject
    MessageUtils m;
    @Inject
    CreditService creditService;
    @Inject(value="${solon.app.name}")
    String projectName;
    @Inject
    VersionConfig versionConfig;
    @Inject
    PropertiesUtils propertiesUtils;
    @Inject
    SettingService settingService;

    @Override
    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        try {
            this.doFilterDo(ctx, chain);
        }
        catch (StatusException e) {
            ctx.status(e.getCode());
            if (404 != e.getCode()) {
                this.logger.error(e.getMessage(), e);
            }
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private void doFilterDo(Context ctx, FilterChain chain) throws Throwable {
        String path = ctx.path().toLowerCase();
        if (!(path.contains("/lib/") || path.toLowerCase().contains("/js/") || path.toLowerCase().contains("/doc/") || path.toLowerCase().contains("/img/") || path.toLowerCase().contains("/css/"))) {
            this.frontInterceptor(ctx);
        }
        if (!(!path.toLowerCase().contains("/adminPage/".toLowerCase()) && !path.toLowerCase().contains("/doc.html") && !path.toLowerCase().contains("/doc/api.html") || path.contains("/lib/") || path.contains("/js/") || path.contains("/img/") || path.contains("/css/") || this.adminInterceptor(ctx))) {
            ctx.setHandled(true);
            return;
        }
        if (!(!path.toLowerCase().contains("/api/") || path.contains("/lib/") || path.contains("/doc/") || path.contains("/js/") || path.contains("/img/") || path.contains("/css/") || this.apiInterceptor(ctx))) {
            ctx.setHandled(true);
            return;
        }
        if (StrUtil.isNotEmpty(ctx.param("limit"))) {
            ctx.sessionSet("limit", ctx.param("limit"));
        }
        if (path.toLowerCase().contains("/adminPage/admin".toLowerCase())) {
            Admin admin = (Admin)ctx.session("admin");
            String showAdmin = ctx.param("showAdmin");
            if (admin.getType() != 0 && !"true".equals(showAdmin)) {
                JsonResult result = new JsonResult();
                result.setSuccess(false);
                result.setStatus("401");
                result.setMsg(this.m.get("loginStr.notPermission"));
                ctx.output(JSONUtil.toJsonPrettyStr(result));
                ctx.setHandled(true);
                return;
            }
        }
        chain.doFilter(ctx);
    }

    private boolean apiInterceptor(Context ctx) {
        String token = ctx.header("token");
        Admin admin = this.adminService.getByToken(token);
        if (admin != null && admin.getApi().booleanValue()) {
            return true;
        }
        JsonResult result = new JsonResult();
        result.setSuccess(false);
        result.setStatus("401");
        result.setMsg(this.m.get("apiStr.wrongToken"));
        ctx.output(JSONUtil.toJsonPrettyStr(result));
        return false;
    }

    private boolean adminInterceptor(Context ctx) {
        String ctxStr = this.getCtxStr(ctx);
        if (ctx.path().toLowerCase().contains("adminPage/login".toLowerCase())) {
            return true;
        }
        if (ctx.path().toLowerCase().contains("adminPage/sso/code".toLowerCase())) {
            return true;
        }
        if (ctx.path().toLowerCase().contains("adminPage/sso/redirect".toLowerCase())) {
            return true;
        }
        String creditKey = ctx.param("creditKey");
        boolean isCredit = this.creditService.check(creditKey);
        Boolean isLogin = (Boolean)ctx.session("isLogin");
        if (!(isLogin != null && isLogin.booleanValue() || isCredit)) {
            ctx.redirect("/adminPage/login");
            return false;
        }
        String localType = (String)ctx.session("localType");
        if (localType != null && localType.equals("remote") && !ctx.path().toLowerCase().contains("adminPage/remote".toLowerCase()) && !ctx.path().toLowerCase().contains("adminPage/admin".toLowerCase()) && !ctx.path().toLowerCase().contains("adminPage/about".toLowerCase())) {
            Remote remote = (Remote)ctx.session("remote");
            String url = this.buildUrl(ctxStr, ctx, remote);
            try {
                HttpResponse httpResponse = null;
                if (url.contains("main/upload")) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("creditKey", remote.getCreditKey());
                    UploadedFile uploadedFile = ctx.file("file");
                    File temp = new File(FileUtil.getTmpDir() + "/" + uploadedFile.getName());
                    uploadedFile.transferTo(temp);
                    map.put("file", temp);
                    httpResponse = HttpRequest.post(url).form(map).execute();
                } else {
                    Admin admin = new BaseController().getAdmin();
                    String body = this.buldBody(ctx.paramMap(), remote, admin);
                    httpResponse = HttpRequest.post(url).body(body).execute();
                }
                ctx.charset("utf-8");
                ctx.headerSet("Content-Type", httpResponse.header("Content-Type"));
                ctx.headerSet("content-disposition", httpResponse.header("content-disposition"));
                ctx.output(httpResponse.body());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
                ctx.redirect("/adminPage/login/noServer");
            }
            return false;
        }
        return true;
    }

    private void frontInterceptor(Context ctx) {
        String ctxStr = this.getCtxStr(ctx);
        if (StrUtil.isNotEmpty(ctx.param("ctx"))) {
            ctxStr = Base64.decodeStr(ctx.param("ctx"));
        }
        ctx.attrSet("ctx", ctxStr);
        ctx.attrSet("jsrandom", this.versionConfig.currentVersion);
        ctx.attrSet("currentVersion", this.versionConfig.currentVersion);
        ctx.attrSet("projectName", this.projectName);
        ctx.attrSet("showAdmin", ctx.param("showAdmin"));
        ctx.attrSet("admin", ctx.session("admin"));
        if (this.versionConfig.newVersion != null && this.versionConfig.newVersion.getVersion() != null && this.versionConfig.currentVersion != null) {
            ctx.attrSet("newVersion", this.versionConfig.newVersion);
            int currentVersion = Integer.parseInt(this.versionConfig.currentVersion.replace(".", "").replace("v", ""));
            int newVersion = Integer.parseInt(this.versionConfig.newVersion.getVersion().replace(".", "").replace("v", ""));
            if (currentVersion < newVersion) {
                ctx.attrSet("hasNewVersion", 1);
            }
        }
        Properties properties = null;
        String lang = this.settingService.get("lang");
        if (StrUtil.isEmpty(lang)) {
            properties = this.m.getProperties();
            lang = "zh";
        }
        if ("en_US".equals(lang)) {
            properties = this.m.getPropertiesEN();
        }
        if ("zh_TW".equals(lang)) {
            properties = this.m.getPropertiesTW();
        }
        ctx.attrSet("lang", lang);
        HashSet<String> messageHeaders = new HashSet<String>();
        ArrayList<Message> messages = new ArrayList<Message>();
        for (String key : properties.stringPropertyNames()) {
            Message message = new Message();
            message.setKey(key);
            message.setValue(properties.getProperty(key));
            messages.add(message);
            messageHeaders.add(key.split("\\.")[0]);
        }
        ctx.attrSet("messageHeaders", messageHeaders);
        ctx.attrSet("messages", messages);
        for (String key : messageHeaders) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Message message : messages) {
                if (!message.getKey().split("\\.")[0].equals(key)) continue;
                map.put(message.getKey().split("\\.")[1], message.getValue());
            }
            ctx.attrSet(key, map);
        }
        ctx.attrSet("langType", "\u7b80\u4f53\u4e2d\u6587");
        if (this.settingService.get("lang") != null) {
            if (this.settingService.get("lang").equals("en_US")) {
                ctx.attrSet("langType", "English");
            }
            if (this.settingService.get("lang").equals("zh_TW")) {
                ctx.attrSet("langType", "\u7e41\u4f53\u4e2d\u6587");
            }
        }
    }

    private String buldBody(MultiMap<String> parameterMap, Remote remote, Admin admin) throws UnsupportedEncodingException {
        ArrayList<String> body = new ArrayList<String>();
        body.add("creditKey=" + remote.getCreditKey());
        if (admin != null) {
            body.add("adminName=" + admin.getName());
        }
        for (KeyValues<String> keyValues : parameterMap) {
            for (String value : keyValues.getValues()) {
                body.add(keyValues.getKey() + "=" + URLEncoder.encode(value, "UTF-8"));
            }
        }
        return StrUtil.join((CharSequence)"&", body);
    }

    private String buildUrl(String ctxStr, Context ctx, Remote remote) {
        String url = ctx.url().replace(ctxStr, "//" + remote.getIp() + ":" + remote.getPort() + "/");
        if (url.startsWith("http")) {
            url = url.replace("http:", "").replace("https:", "");
        }
        url = remote.getProtocol() + ":" + url;
        Admin admin = (Admin)ctx.session("admin");
        String showAdmin = "false";
        if (admin != null && admin.getType() == 0) {
            showAdmin = "true";
        }
        return url + "?jsrandom=" + System.currentTimeMillis() + "&protocol=" + remote.getProtocol() + "&showAdmin=" + showAdmin + "&ctx=" + Base64.encode(ctxStr);
    }

    public String getCtxStr(Context context) {
        String httpHost = context.header("X-Forwarded-Host");
        String realPort = context.header("X-Forwarded-Port");
        String host = context.header("Host");
        String ctx = "//";
        if (StrUtil.isNotEmpty(httpHost)) {
            ctx = ctx + httpHost;
        } else if (StrUtil.isNotEmpty(host)) {
            ctx = ctx + host;
            if (!host.contains(":") && StrUtil.isNotEmpty(realPort)) {
                ctx = ctx + ":" + realPort;
            }
        } else {
            host = context.url().split("/")[2];
            ctx = ctx + host;
            if (!host.contains(":") && StrUtil.isNotEmpty(realPort)) {
                ctx = ctx + ":" + realPort;
            }
        }
        return ctx;
    }
}

