/*
 * Decompiled with CFR 0.152.
 */
package com.cym.config;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.cym.utils.FilePermissionUtil;
import com.cym.utils.JarUtil;
import com.cym.utils.SystemTool;
import com.cym.utils.ToolUtils;
import java.io.File;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Init;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class HomeConfig {
    @Inject(value="${project.home}")
    public String home;
    public String acmeSh;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Init
    public void afterInjection() {
        if (StrUtil.isEmpty(this.home)) {
            File file = new File(JarUtil.getCurrentFilePath());
            this.home = file.getPath().contains("target") && file.getPath().contains("classes") ? FileUtil.getUserHomePath() + File.separator + "nginxWebUI" : file.getParent();
        }
        if (SystemTool.isWindows().booleanValue() && !this.home.contains(":")) {
            this.home = JarUtil.getCurrentFilePath().split(":")[0] + ":" + this.home;
        }
        this.home = ToolUtils.endDir(ToolUtils.handlePath(this.home));
        if (!FilePermissionUtil.canWrite(new File(this.home)).booleanValue()) {
            this.logger.error(this.home + " directory does not have writable permission. Please specify it again.");
            this.logger.error(this.home + " \u76ee\u5f55\u6ca1\u6709\u53ef\u5199\u6743\u9650,\u8bf7\u91cd\u65b0\u6307\u5b9a.");
            System.exit(1);
        }
        this.acmeSh = this.home + ".acme.sh/acme.sh";
    }
}

