/*
 * Decompiled with CFR 0.152.
 */
package com.cym.config;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.cym.config.HomeConfig;
import com.cym.config.SQLConstants;
import com.cym.config.VersionConfig;
import com.cym.model.Admin;
import com.cym.model.Basic;
import com.cym.model.Http;
import com.cym.service.BasicService;
import com.cym.service.ConfService;
import com.cym.service.SettingService;
import com.cym.sqlhelper.config.DataSourceEmbed;
import com.cym.sqlhelper.config.Table;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.JdbcTemplate;
import com.cym.sqlhelper.utils.SqlHelper;
import com.cym.utils.EncodePassUtils;
import com.cym.utils.MessageUtils;
import com.cym.utils.SystemTool;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Init;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class InitConfig {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    MessageUtils m;
    @Inject
    HomeConfig homeConfig;
    @Inject
    VersionConfig versionConfig;
    @Inject
    SettingService settingService;
    @Inject
    BasicService basicService;
    @Inject
    SqlHelper sqlHelper;
    @Inject
    JdbcTemplate jdbcTemplate;
    @Inject
    ConfService confService;
    @Inject
    DataSourceEmbed dataSourceEmbed;
    @Inject(value="${project.beanPackage}")
    String packageName;
    @Inject(value="${project.findPass}")
    Boolean findPass;
    @Inject(value="${spring.database.type}")
    String databaseType;
    @Inject(value="${initAdmin}")
    String initAdmin;
    @Inject(value="${initPass}")
    String initPass;
    @Inject(value="${initApi}")
    Boolean initApi;

    @Init
    public void start() throws Throwable {
        String nginxPath;
        InputStream inputStream;
        ClassPathResource resource;
        Long count;
        if (this.findPass.booleanValue()) {
            List<Admin> admins = this.sqlHelper.findAll(Admin.class);
            for (Admin admin : admins) {
                String randomPass = RandomUtil.randomString(8);
                admin.setAuth(false);
                admin.setPass(EncodePassUtils.encode(randomPass));
                this.sqlHelper.updateById(admin);
            }
            System.exit(1);
        }
        if (StrUtil.isNotBlank(this.initAdmin) && StrUtil.isNotBlank(this.initPass)) {
            this.addAdmin();
        }
        if ((count = this.sqlHelper.findAllCount(Basic.class)) == 0L) {
            ArrayList<Basic> basics = new ArrayList<Basic>();
            basics.add(new Basic("worker_processes", "auto", 1L));
            basics.add(new Basic("events", "{\r\n    worker_connections  1024;\r\n    accept_mutex on;\r\n}", 2L));
            this.sqlHelper.insertAll(basics);
        }
        if ((count = this.sqlHelper.findAllCount(Http.class)) == 0L) {
            ArrayList<Http> https = new ArrayList<Http>();
            https.add(new Http("include", "mime.types", 0L));
            https.add(new Http("default_type", "application/octet-stream", 1L));
            this.sqlHelper.insertAll(https);
        }
        if (!FileUtil.exist(this.homeConfig.home + "fastcgi.conf")) {
            resource = new ClassPathResource("conf.zip");
            inputStream = resource.getStream();
            ZipUtil.unzip(inputStream, new File(this.homeConfig.home), CharsetUtil.defaultCharset());
        }
        if (!FileUtil.exist(this.homeConfig.home + "nginx.conf")) {
            resource = new ClassPathResource("nginx.conf");
            inputStream = resource.getStream();
            FileUtil.writeFromStream(inputStream, this.homeConfig.home + "nginx.conf");
        }
        if (StrUtil.isEmpty(nginxPath = this.settingService.get("nginxPath"))) {
            nginxPath = this.homeConfig.home + "nginx.conf";
            this.settingService.set("nginxPath", nginxPath);
        }
        String acmeShDir = this.homeConfig.home + ".acme.sh" + File.separator;
        ClassPathResource resource2 = new ClassPathResource("acme.zip");
        InputStream inputStream2 = resource2.getStream();
        ZipUtil.unzip(inputStream2, new File(acmeShDir), CharsetUtil.defaultCharset());
        if (this.settingService.get("denyAllow") == null) {
            this.settingService.set("denyAllow", "0");
        }
        if (this.settingService.get("denyAllowStream") == null) {
            this.settingService.set("denyAllowStream", "0");
        }
        if (SystemTool.isLinux().booleanValue()) {
            if (!this.basicService.contain("ngx_stream_module.so") && FileUtil.exist("/usr/lib/nginx/modules/ngx_stream_module.so")) {
                Basic basic = new Basic("load_module", "/usr/lib/nginx/modules/ngx_stream_module.so", -10L);
                this.sqlHelper.insert(basic);
            }
            if (this.hasNginx() && StrUtil.isEmpty(this.settingService.get("nginxExe"))) {
                this.settingService.set("nginxExe", "nginx");
            }
            ThreadUtil.execute(new Runnable(){

                @Override
                public void run() {
                    String nginxExe = InitConfig.this.settingService.get("nginxExe");
                    String nginxDir = InitConfig.this.settingService.get("nginxDir");
                    String nginxPath = InitConfig.this.settingService.get("nginxPath");
                    if (StrUtil.isNotEmpty(nginxExe) && StrUtil.isNotEmpty(nginxPath)) {
                        InitConfig.this.runCmd("pkill -9 nginx");
                        String cmd = nginxExe + " -c " + nginxPath;
                        if (StrUtil.isNotEmpty(nginxDir)) {
                            cmd = cmd + " -p " + nginxDir;
                        }
                        InitConfig.this.runCmd(cmd);
                    }
                }
            });
        }
        this.showLogo();
    }

    private void runCmd(String cmd) {
        this.logger.info("run: " + cmd);
        RuntimeUtil.execForStr("/bin/sh", "-c", cmd);
    }

    private boolean hasNginx() {
        String rs = RuntimeUtil.execForStr("which nginx");
        return StrUtil.isNotEmpty(rs);
    }

    private void showLogo() throws IOException {
        ClassPathResource resource = new ClassPathResource("banner.txt");
        BufferedReader reader = resource.getReader(StandardCharsets.UTF_8);
        String str = null;
        StringBuilder stringBuilder = new StringBuilder();
        while (null != (str = reader.readLine())) {
            stringBuilder.append(str).append("\n");
        }
        reader.close();
        stringBuilder.append("nginxWebUI ").append(this.versionConfig.currentVersion).append("\n");
        this.logger.info(stringBuilder.toString());
    }

    private void transferSql() {
        this.dataSourceEmbed.getDataSource().close();
        HikariConfig dbConfig = new HikariConfig();
        dbConfig.setJdbcUrl("jdbc:h2:" + this.homeConfig.home + "h2");
        dbConfig.setUsername("sa");
        dbConfig.setPassword("");
        dbConfig.setMaximumPoolSize(1);
        HikariDataSource dataSourceH2 = new HikariDataSource(dbConfig);
        this.dataSourceEmbed.setDataSource(dataSourceH2);
        Map<String, List<?>> map = this.readAll();
        dataSourceH2.close();
        this.dataSourceEmbed.init();
        this.insertAll(map);
        FileUtil.rename(new File(this.homeConfig.home + "h2.mv.db"), this.homeConfig.home + "h2.mv.db.bak", true);
    }

    private Map<String, List<?>> readAll() {
        HashMap map = new HashMap();
        Set<Class<?>> set = ClassUtil.scanPackage(this.packageName);
        for (Class<?> clazz : set) {
            Table table = clazz.getAnnotation(Table.class);
            if (table == null) continue;
            try {
                List<Map<String, Object>> list = this.jdbcTemplate.queryForList("SELECT * FROM " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX, new Object[0]);
                map.put(clazz.getName(), this.sqlHelper.buildObjects(list, clazz));
            }
            catch (Exception e) {
                this.logger.info(e.getMessage(), e);
            }
        }
        return map;
    }

    private void insertAll(Map<String, List<?>> map) {
        try {
            for (String key : map.keySet()) {
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), Class.forName(key));
                this.sqlHelper.insertAll(map.get(key));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private void addAdmin() {
        Long adminCount = this.sqlHelper.findAllCount(Admin.class);
        if (adminCount > 0L) {
            return;
        }
        Admin admin = new Admin();
        admin.setName(this.initAdmin);
        admin.setPass(EncodePassUtils.encode(this.initPass));
        admin.setApi(this.initApi);
        admin.setType(0);
        this.sqlHelper.insert(admin);
    }
}

