/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.util.StrUtil;
import com.cym.controller.adminPage.RemoteController;
import com.cym.ext.AdminExt;
import com.cym.ext.Tree;
import com.cym.model.Admin;
import com.cym.model.Group;
import com.cym.service.AdminService;
import com.cym.service.GroupService;
import com.cym.service.SettingService;
import com.cym.sqlhelper.bean.Page;
import com.cym.utils.AuthUtils;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SendMailUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@Mapping(value="/adminPage/admin")
public class AdminController
extends BaseController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    AdminService adminService;
    @Inject
    SettingService settingService;
    @Inject
    SendMailUtils sendCloudUtils;
    @Inject
    AuthUtils authUtils;
    @Inject
    GroupService groupService;
    @Inject
    RemoteController remoteController;

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView, Page page) {
        this.setPage(page);
        page = this.adminService.search(page);
        modelAndView.put("page", page);
        modelAndView.view("/adminPage/admin/index.html");
        return modelAndView;
    }

    @Mapping(value="addOver")
    public JsonResult addOver(String id, String name, Boolean api, Integer type, String[] parentId) {
        Long count;
        if (StrUtil.isEmpty(id) ? (count = this.adminService.getCountByName(name)) > 0L : (count = this.adminService.getCountByNameWithOutId(name, id)) > 0L) {
            return this.renderError(this.m.get("adminStr.nameRepetition"));
        }
        Admin admin = new Admin();
        admin.setId(id);
        admin.setName(name);
        admin.setApi(api);
        admin.setType(type);
        this.adminService.addOver(admin, parentId);
        return this.renderSuccess();
    }

    @Mapping(value="changePassOver")
    public JsonResult changePassOver(String id, String pass, Boolean auth) {
        Admin admin = new Admin();
        admin.setId(id);
        admin.setPass(pass);
        admin.setAuth(auth);
        this.adminService.changePassOver(admin);
        return this.renderSuccess();
    }

    @Mapping(value="detail")
    public JsonResult detail(String id) {
        AdminExt adminExt = new AdminExt();
        adminExt.setAdmin(this.sqlHelper.findById(id, Admin.class));
        adminExt.setGroupIds(this.adminService.getGroupIds(adminExt.getAdmin().getId()));
        adminExt.getAdmin().setPass("");
        return this.renderSuccess(adminExt);
    }

    @Mapping(value="del")
    public JsonResult del(String id) {
        String[] ids = id.split(",");
        this.sqlHelper.deleteByIds(ids, Admin.class);
        return this.renderSuccess();
    }

    @Mapping(value="getMailSetting")
    public JsonResult getMailSetting() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mail_host", this.settingService.get("mail_host"));
        map.put("mail_port", this.settingService.get("mail_port"));
        map.put("mail_from", this.settingService.get("mail_from"));
        map.put("mail_user", this.settingService.get("mail_user"));
        map.put("mail_pass", this.settingService.get("mail_pass"));
        map.put("mail_ssl", this.settingService.get("mail_ssl"));
        map.put("mail_interval", this.settingService.get("mail_interval"));
        return this.renderSuccess(map);
    }

    @Mapping(value="updateMailSetting")
    public JsonResult updateMailSetting(String mailType, String mail_user, String mail_host, String mail_port, String mail_from, String mail_pass, String mail_ssl, String mail_interval) {
        this.settingService.set("mail_host", mail_host);
        this.settingService.set("mail_port", mail_port);
        this.settingService.set("mail_user", mail_user);
        this.settingService.set("mail_from", mail_from);
        this.settingService.set("mail_pass", mail_pass);
        this.settingService.set("mail_ssl", mail_ssl);
        this.settingService.set("mail_interval", mail_interval);
        return this.renderSuccess();
    }

    @Mapping(value="testMail")
    public JsonResult testMail(String mail) {
        if (StrUtil.isEmpty(mail)) {
            return this.renderError(this.m.get("adminStr.emailEmpty"));
        }
        try {
            this.sendCloudUtils.sendMailSmtp(mail, this.m.get("adminStr.emailTest"), this.m.get("adminStr.emailTest"));
            return this.renderSuccess();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return this.renderError(this.m.get("commonStr.error") + ": " + e.getMessage());
        }
    }

    @Mapping(value="testAuth")
    public JsonResult testAuth(String key, String code) {
        Boolean rs = this.authUtils.testKey(key, code);
        return this.renderSuccess(rs);
    }

    @Mapping(value="qr")
    public void getqcode(String url, Integer w, Integer h2) throws IOException {
        if (StrUtil.isNotBlank(url)) {
            if (w == null) {
                w = 300;
            }
            if (h2 == null) {
                h2 = 300;
            }
            try {
                Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
                hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
                hints.put(EncodeHintType.MARGIN, 0);
                BitMatrix matrix = new MultiFormatWriter().encode(url, BarcodeFormat.QR_CODE, w, h2, hints);
                MatrixToImageWriter.writeToStream(matrix, "png", Context.current().outputStream());
            }
            catch (WriterException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
    }

    @Mapping(value="getGroupTree")
    public JsonResult getGroupTree() {
        List<Group> groups = this.groupService.getListByParent(null);
        ArrayList<Tree> treeList = new ArrayList<Tree>();
        this.remoteController.fillTree(groups, treeList);
        return this.renderSuccess(treeList);
    }
}

