/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.cym.model.Bak;
import com.cym.model.BakSub;
import com.cym.service.BakService;
import com.cym.service.SettingService;
import com.cym.sqlhelper.bean.Page;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;

@Controller
@Mapping(value="/adminPage/bak")
public class BakController
extends BaseController {
    @Inject
    SettingService settingService;
    @Inject
    BakService bakService;

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView, Page page) {
        this.setPage(page);
        page = this.bakService.getList(page);
        modelAndView.put("page", page);
        modelAndView.view("/adminPage/bak/index.html");
        return modelAndView;
    }

    @Mapping(value="getCompare")
    public JsonResult getCompare(String id) {
        Bak bak = this.sqlHelper.findById(id, Bak.class);
        Bak pre = this.bakService.getPre(id);
        if (pre == null) {
            return this.renderError("\u6ca1\u6709\u66f4\u65e9\u7684\u5907\u4efd\u6587\u4ef6");
        }
        HashMap<String, Bak> map = new HashMap<String, Bak>();
        map.put("bak", bak);
        map.put("pre", pre);
        return this.renderSuccess(map);
    }

    @Mapping(value="content")
    public JsonResult content(String id) {
        Bak bak = this.sqlHelper.findById(id, Bak.class);
        return this.renderSuccess(bak);
    }

    @Mapping(value="replace")
    public JsonResult replace(String id) {
        Bak bak = this.sqlHelper.findById(id, Bak.class);
        String nginxPath = this.settingService.get("nginxPath");
        if (StrUtil.isNotEmpty(nginxPath)) {
            File pathFile = new File(nginxPath);
            FileUtil.writeString(bak.getContent(), pathFile, StandardCharsets.UTF_8);
            String confd = pathFile.getParent() + File.separator + "conf.d" + File.separator;
            FileUtil.del(confd);
            FileUtil.mkdir(confd);
            List<BakSub> subList = this.bakService.getSubList(bak.getId());
            for (BakSub bakSub : subList) {
                FileUtil.writeString(bakSub.getContent(), confd + bakSub.getName(), StandardCharsets.UTF_8);
            }
            return this.renderSuccess();
        }
        return this.renderError(this.m.get("bakStr.pathNotice"));
    }

    @Mapping(value="del")
    public JsonResult del(String id) {
        this.bakService.del(id);
        return this.renderSuccess();
    }

    @Mapping(value="delAll")
    public JsonResult delAll() {
        this.bakService.delAll();
        return this.renderSuccess();
    }
}

