/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.cym.controller.adminPage.ConfController;
import com.cym.model.Cert;
import com.cym.model.CertCode;
import com.cym.service.CertService;
import com.cym.service.SettingService;
import com.cym.sqlhelper.bean.Page;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SystemTool;
import com.cym.utils.TimeExeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.handle.ModelAndView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@Mapping(value="/adminPage/cert")
public class CertController
extends BaseController {
    @Inject
    SettingService settingService;
    @Inject
    CertService certService;
    @Inject
    TimeExeUtils timeExeUtils;
    @Inject
    ConfController confController;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    Boolean isInApply = false;
    String acmeDnsAuth = "http://auth.nginxwebui.cn";

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView, Page page, String keywords) {
        this.setPage(page);
        page = this.certService.getPage(keywords, page);
        for (Cert cert : page.getRecords()) {
            if (cert.getType() == 0 || cert.getType() == 2) {
                cert.setDomain(cert.getDomain() + "(" + cert.getEncryption() + ")");
            }
            if (cert.getMakeTime() == null || cert.getType() == 1) continue;
            cert.setEndTime(cert.getMakeTime() + 7776000000L);
        }
        modelAndView.put("keywords", keywords);
        modelAndView.put("page", page);
        modelAndView.view("/adminPage/cert/index.html");
        return modelAndView;
    }

    @Mapping(value="addOver")
    public JsonResult addOver(Cert cert, String[] domains, String[] types, String[] values) {
        String domain;
        if (this.certService.hasName(cert)) {
            return this.renderError(this.m.get("certStr.nameRepetition"));
        }
        Integer type = cert.getType();
        if (type == null && StrUtil.isNotEmpty(cert.getId())) {
            Cert certOrg = this.sqlHelper.findById(cert.getId(), Cert.class);
            type = certOrg.getType();
        }
        if (StrUtil.isEmpty(domain = cert.getDomain()) && StrUtil.isNotEmpty(cert.getId())) {
            Cert certOrg = this.sqlHelper.findById(cert.getId(), Cert.class);
            domain = certOrg.getDomain();
        }
        if (type != null && type == 1) {
            String dir = this.homeConfig.home + "cert/" + domain + "/";
            if (SystemTool.isWindows().booleanValue()) {
                dir = dir.replace("*", "_");
            }
            if (cert.getKey().contains(FileUtil.getTmpDir().toString().replace("\\", "/"))) {
                String keyName = new File(cert.getKey()).getName();
                FileUtil.move(new File(cert.getKey()), new File(dir + keyName), true);
                cert.setKey(dir + keyName);
            }
            if (cert.getPem().contains(FileUtil.getTmpDir().toString().replace("\\", "/"))) {
                String pemName = new File(cert.getPem()).getName();
                FileUtil.move(new File(cert.getPem()), new File(dir + pemName), true);
                cert.setPem(dir + pemName);
            }
            if (cert.getEndTime() == null) {
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    FileInputStream in = new FileInputStream(cert.getPem());
                    X509Certificate certFile = (X509Certificate)cf.generateCertificate(in);
                    Date effDate = certFile.getNotBefore();
                    Date expDate = certFile.getNotAfter();
                    cert.setMakeTime(effDate.getTime());
                    cert.setEndTime(expDate.getTime());
                }
                catch (Exception e) {
                    this.logger.info(e.getMessage(), e);
                }
            }
        }
        this.certService.insertOrUpdate(cert, domains, types, values);
        return this.renderSuccess(cert);
    }

    @Mapping(value="setAutoRenew")
    public JsonResult setAutoRenew(Cert cert) {
        this.sqlHelper.updateById(cert);
        return this.renderSuccess();
    }

    @Mapping(value="detail")
    public JsonResult detail(String id) {
        Cert cert = this.sqlHelper.findById(id, Cert.class);
        return this.renderSuccess(cert);
    }

    @Mapping(value="del")
    public JsonResult del(String id) {
        String[] ids;
        for (String i : ids = id.split(",")) {
            Cert cert = this.sqlHelper.findById(i, Cert.class);
            if (cert.getType() == 1) {
                if (cert.getPem().contains(this.homeConfig.home + "cert/")) {
                    FileUtil.del(cert.getPem());
                }
                if (cert.getKey().contains(this.homeConfig.home + "cert/")) {
                    FileUtil.del(cert.getKey());
                }
            } else {
                String domain = cert.getDomain().split(",")[0];
                String path = this.homeConfig.home + File.separator + ".acme.sh" + File.separator + domain;
                if ("ECC".equals(cert.getEncryption())) {
                    path = path + "_ecc";
                }
                if (FileUtil.exist(path)) {
                    FileUtil.del(path);
                }
            }
            this.sqlHelper.deleteById(i, Cert.class);
        }
        return this.renderSuccess();
    }

    @Mapping(value="apply")
    public JsonResult apply(String id, String type) {
        if (!SystemTool.isLinux().booleanValue()) {
            return this.renderError(this.m.get("certStr.error2"));
        }
        if (this.isInApply.booleanValue()) {
            return this.renderError(this.m.get("certStr.error4"));
        }
        this.isInApply = true;
        Cert cert = this.sqlHelper.findById(id, Cert.class);
        String keylength = " --keylength 2048 ";
        String ecc = "";
        if ("ECC".equals(cert.getEncryption())) {
            keylength = " --keylength ec-256 ";
            ecc = " --ecc";
        }
        String cmd = "sh ";
        String[] envs = this.getEnv(cert);
        String[] split = cert.getDomain().split(",");
        if (type.equals("issue")) {
            StringBuffer sb = new StringBuffer();
            Arrays.stream(split).forEach(s2 -> sb.append(" -d ").append((String)s2));
            String domain = sb.toString();
            if (cert.getType() == 0) {
                String dnsType = "";
                if (cert.getDnsType().equals("ali")) {
                    dnsType = "dns_ali";
                } else if (cert.getDnsType().equals("dp")) {
                    dnsType = "dns_dp";
                } else if (cert.getDnsType().equals("tencent")) {
                    dnsType = "dns_tencent";
                } else if (cert.getDnsType().equals("cf")) {
                    dnsType = "dns_cf";
                } else if (cert.getDnsType().equals("cfToken")) {
                    dnsType = "dns_cf";
                } else if (cert.getDnsType().equals("gd")) {
                    dnsType = "dns_gd";
                } else if (cert.getDnsType().equals("hw")) {
                    dnsType = "dns_huaweicloud";
                } else if (cert.getDnsType().equals("aws")) {
                    dnsType = "dns_aws";
                } else if (cert.getDnsType().equals("ipv64")) {
                    dnsType = "dns_ipv64";
                }
                cmd = cmd + this.homeConfig.acmeSh + " --issue --dns " + dnsType + domain + keylength + " --server letsencrypt";
            } else if (cert.getType() == 2) {
                if (StrUtil.isEmpty(this.settingService.get("fulldomain"))) {
                    this.isInApply = false;
                    return this.renderError(this.m.get("certStr.error6"));
                }
                cmd = cmd + this.homeConfig.acmeSh + " --issue --dns dns_acmedns" + domain + keylength + " --server letsencrypt";
            }
        } else if (type.equals("renew")) {
            String domain = split[0];
            cmd = cmd + this.homeConfig.acmeSh + " --renew --force " + ecc + " -d " + domain;
        }
        String rs = this.timeExeUtils.execCMD(cmd, envs, 180000L);
        if (rs.contains("Your cert is in")) {
            cert.setPem(this.getPem(rs));
            cert.setKey(this.getKey(rs));
            cert.setMakeTime(System.currentTimeMillis());
            this.sqlHelper.updateById(cert);
            if (type.equals("renew")) {
                this.confController.reload(null, null, null);
            }
            this.isInApply = false;
            return this.renderSuccess();
        }
        this.isInApply = false;
        return this.renderError("<span class='blue'>" + cmd + "</span><br>" + this.m.get("certStr.applyFail") + "<br>" + rs.replace("\n", "<br>"));
    }

    private String getKey(String rs) {
        String[] lines;
        for (String line : lines = rs.split("\n")) {
            if (!line.contains("Your cert key is in:")) continue;
            return line.split("Your cert key is in:")[1].trim().replace("\\", "/").replace("//", "/");
        }
        return null;
    }

    private String getPem(String rs) {
        String[] lines;
        for (String line : lines = rs.split("\n")) {
            if (!line.contains("And the full-chain cert is in:")) continue;
            return line.split("And the full-chain cert is in:")[1].trim().replace("\\", "/").replace("//", "/");
        }
        return null;
    }

    private String[] getEnv(Cert cert) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("HOME=" + this.homeConfig.home);
        if (cert.getType() == 0) {
            if (cert.getDnsType().equals("ali")) {
                list.add("Ali_Key=" + cert.getAliKey());
                list.add("Ali_Secret=" + cert.getAliSecret());
            }
            if (cert.getDnsType().equals("dp")) {
                list.add("DP_Id=" + cert.getDpId());
                list.add("DP_Key=" + cert.getDpKey());
            }
            if (cert.getDnsType().equals("tencent")) {
                list.add("Tencent_SecretId=" + cert.getTencentSecretId());
                list.add("Tencent_SecretKey=" + cert.getTencentSecretKey());
            }
            if (cert.getDnsType().equals("aws")) {
                list.add("AWS_ACCESS_KEY_ID=" + cert.getAwsAccessKeyId());
                list.add("AWS_SECRET_ACCESS_KEY=" + cert.getAwsSecretAccessKey());
            }
            if (cert.getDnsType().equals("ipv64")) {
                list.add("IPv64_Token=" + cert.getIpv64Token());
            }
            if (cert.getDnsType().equals("cf")) {
                list.add("CF_Email=" + cert.getCfEmail());
                list.add("CF_Key=" + cert.getCfKey());
            }
            if (cert.getDnsType().equals("cfToken")) {
                list.add("CF_Token=" + cert.getCfToken());
                if (StrUtil.isNotEmpty(cert.getCfAccountId())) {
                    list.add("CF_Account_ID=" + cert.getCfAccountId());
                }
                if (StrUtil.isNotEmpty(cert.getCfZoneId())) {
                    list.add("CF_Zone_ID=" + cert.getCfZoneId());
                }
            }
            if (cert.getDnsType().equals("gd")) {
                list.add("GD_Key=" + cert.getGdKey());
                list.add("GD_Secret=" + cert.getGdSecret());
            }
            if (cert.getDnsType().equals("hw")) {
                list.add("HUAWEICLOUD_Username=" + cert.getHwUsername());
                list.add("HUAWEICLOUD_Password=" + cert.getHwPassword());
                list.add("HUAWEICLOUD_DomainName=" + cert.getHwDomainName());
            }
        } else if (cert.getType() == 2) {
            list.add("ACMEDNS_BASE_URL=" + this.acmeDnsAuth);
            list.add("ACMEDNS_USERNAME=" + this.settingService.get("username"));
            list.add("ACMEDNS_PASSWORD=" + this.settingService.get("password"));
            list.add("ACMEDNS_SUBDOMAIN=" + this.settingService.get("subdomain"));
        }
        return list.toArray(new String[0]);
    }

    @Mapping(value="getTxtValue")
    public JsonResult getTxtValue(String id) {
        Cert cert = this.sqlHelper.findById(id, Cert.class);
        if (StrUtil.isEmpty(this.settingService.get("fulldomain"))) {
            try {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                String rs = HttpUtil.post(this.acmeDnsAuth + "/register", paramMap);
                this.logger.info(rs);
                JSONObject jsonObject = JSONUtil.parseObj(rs);
                this.settingService.set("username", jsonObject.getStr("username"));
                this.settingService.set("password", jsonObject.getStr("password"));
                this.settingService.set("fulldomain", jsonObject.getStr("fulldomain"));
                this.settingService.set("subdomain", jsonObject.getStr("subdomain"));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
                return this.renderError(this.m.get("certStr.error7"));
            }
        }
        ArrayList<CertCode> certCodes = new ArrayList<CertCode>();
        CertCode certCode = new CertCode();
        certCode.setDomain(CertController.buildDomain(cert.getDomain()));
        certCode.setType("CNAME");
        certCode.setValue(this.settingService.get("fulldomain"));
        certCodes.add(certCode);
        return this.renderSuccess(certCodes);
    }

    private static String buildDomain(String domain) {
        if ((domain = domain.replace("*", "")).startsWith(".")) {
            domain = domain.substring(1);
        }
        return "_acme-challenge." + domain;
    }

    @Mapping(value="download")
    public DownloadedFile download(String id) throws IOException {
        Cert cert = this.sqlHelper.findById(id, Cert.class);
        if (StrUtil.isNotEmpty(cert.getPem()) && StrUtil.isNotEmpty(cert.getKey())) {
            String dir = this.homeConfig.home + "/temp/cert";
            FileUtil.del(dir);
            FileUtil.del(dir + ".zip");
            FileUtil.mkdir(dir);
            File pem = new File(cert.getPem());
            File key = new File(cert.getKey());
            FileUtil.copy(pem, new File(dir + "/" + pem.getName()), true);
            FileUtil.copy(key, new File(dir + "/" + key.getName()), true);
            ZipUtil.zip(dir);
            FileUtil.del(dir);
            DownloadedFile downloadedFile = new DownloadedFile("application/octet-stream", Files.newInputStream(Paths.get(dir + ".zip", new String[0]), new OpenOption[0]), "cert.zip");
            return downloadedFile;
        }
        return null;
    }
}

