/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.cym.config.VersionConfig;
import com.cym.controller.adminPage.MainController;
import com.cym.ext.ConfExt;
import com.cym.ext.ConfFile;
import com.cym.model.Admin;
import com.cym.service.ConfService;
import com.cym.service.ServerService;
import com.cym.service.SettingService;
import com.cym.service.UpstreamService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.NginxUtils;
import com.cym.utils.SystemTool;
import com.cym.utils.ToolUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@Mapping(value="/adminPage/conf")
public class ConfController
extends BaseController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    UpstreamService upstreamService;
    @Inject
    SettingService settingService;
    @Inject
    ServerService serverService;
    @Inject
    ConfService confService;
    @Inject
    MainController mainController;
    @Inject
    VersionConfig versionConfig;
    String aesKey = "aes";

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView) {
        String nginxPath = ToolUtils.handleConf(this.settingService.get("nginxPath"));
        this.settingService.set("nginxPath", nginxPath);
        modelAndView.put("nginxPath", nginxPath);
        String nginxExe = ToolUtils.handleConf(this.settingService.get("nginxExe"));
        this.settingService.set("nginxExe", nginxExe);
        modelAndView.put("nginxExe", nginxExe);
        String nginxDir = ToolUtils.handleConf(this.settingService.get("nginxDir"));
        this.settingService.set("nginxDir", nginxDir);
        modelAndView.put("nginxDir", nginxDir);
        String decompose = this.settingService.get("decompose");
        modelAndView.put("decompose", decompose);
        modelAndView.put("tmp", this.homeConfig.home + "temp/nginx.conf");
        modelAndView.view("/adminPage/conf/index.html");
        return modelAndView;
    }

    @Mapping(value="nginxStatus")
    public JsonResult nginxStatus() {
        if (NginxUtils.isRun()) {
            return this.renderSuccess(this.m.get("confStr.nginxStatus") + "\uff1a<span class='green'>" + this.m.get("confStr.running") + "</span>");
        }
        return this.renderSuccess(this.m.get("confStr.nginxStatus") + "\uff1a<span class='red'>" + this.m.get("confStr.stopped") + "</span>");
    }

    @Mapping(value="replace")
    public JsonResult replace(String json, String adminName) {
        if (StrUtil.isEmpty(json)) {
            json = this.getReplaceJson();
        }
        JSONObject jsonObject = JSONUtil.parseObj(json);
        String nginxPath = jsonObject.getStr("nginxPath");
        String nginxContent = Base64.decodeStr(jsonObject.getStr("nginxContent"));
        List<String> subContent = jsonObject.getJSONArray("subContent").toList(String.class);
        for (int i = 0; i < subContent.size(); ++i) {
            String content = Base64.decodeStr(subContent.get(i));
            subContent.set(i, content);
        }
        List<String> subName = jsonObject.getJSONArray("subName").toList(String.class);
        if (nginxPath == null) {
            nginxPath = this.settingService.get("nginxPath");
        }
        if (FileUtil.isDirectory(nginxPath)) {
            return this.renderError(this.m.get("confStr.error2"));
        }
        try {
            if (StrUtil.isEmpty(adminName)) {
                Admin admin = this.getAdmin();
                adminName = admin.getName();
            }
            this.confService.replace(nginxPath, nginxContent, subContent, subName, true, adminName);
            return this.renderSuccess(this.m.get("confStr.replaceSuccess"));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return this.renderError(this.m.get("confStr.error3") + ":" + e.getMessage());
        }
    }

    public String getReplaceJson() {
        String decompose = this.settingService.get("decompose");
        ConfExt confExt = this.confService.buildConf(StrUtil.isNotEmpty(decompose) && decompose.equals("true"), false);
        JSONObject jsonObject = new JSONObject();
        jsonObject.set("nginxContent", Base64.encode(confExt.getConf()));
        jsonObject.set("subContent", new JSONArray());
        jsonObject.set("subName", new JSONArray());
        for (ConfFile confFile : confExt.getFileList()) {
            jsonObject.getJSONArray("subContent").add(Base64.encode(confFile.getConf()));
            jsonObject.getJSONArray("subName").add(confFile.getName());
        }
        return jsonObject.toStringPretty();
    }

    @Mapping(value="checkBase")
    public JsonResult checkBase() {
        String nginxExe = ToolUtils.handleConf(this.settingService.get("nginxExe"));
        this.settingService.set("nginxExe", nginxExe);
        String nginxDir = ToolUtils.handleConf(this.settingService.get("nginxDir"));
        this.settingService.set("nginxDir", nginxDir);
        String rs = null;
        String cmd = null;
        FileUtil.del(this.homeConfig.home + "temp");
        String fileTemp = this.homeConfig.home + "temp/nginx.conf";
        ConfExt confExt = this.confService.buildConf(false, true);
        String nginxContent = confExt.getConf();
        List<String> subContent = confExt.getFileList().stream().map(ConfFile::getConf).collect(Collectors.toList());
        List<String> subName = confExt.getFileList().stream().map(ConfFile::getName).collect(Collectors.toList());
        this.confService.replace(fileTemp, nginxContent, subContent, subName, false, null);
        try {
            cmd = nginxExe + " -t -c " + fileTemp;
            if (StrUtil.isNotEmpty(nginxDir)) {
                cmd = cmd + " -p " + nginxDir;
            }
            rs = RuntimeUtil.execForStr(cmd);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            rs = e.getMessage().replace("\n", "<br>");
        }
        cmd = "<span class='blue'>" + cmd + "</span>";
        if (rs.contains("successful")) {
            return this.renderSuccess(cmd + "<br>" + this.m.get("confStr.verifySuccess") + "<br>" + rs.replace("\n", "<br>"));
        }
        return this.renderError(cmd + "<br>" + this.m.get("confStr.verifyFail") + "<br>" + rs.replace("\n", "<br>"));
    }

    @Mapping(value="check")
    public JsonResult check(String nginxPath, String nginxExe, String nginxDir, String json) {
        if (nginxExe == null) {
            nginxExe = ToolUtils.handleConf(this.settingService.get("nginxExe"));
            this.settingService.set("nginxExe", nginxExe);
        }
        if (nginxDir == null) {
            nginxDir = ToolUtils.handleConf(this.settingService.get("nginxDir"));
            this.settingService.set("nginxDir", nginxDir);
        }
        JSONObject jsonObject = JSONUtil.parseObj(json);
        String nginxContent = Base64.decodeStr((CharSequence)jsonObject.getStr("nginxContent"), CharsetUtil.CHARSET_UTF_8);
        List<String> subContent = jsonObject.getJSONArray("subContent").toList(String.class);
        List<String> subName = jsonObject.getJSONArray("subName").toList(String.class);
        for (int i = 0; i < subContent.size(); ++i) {
            String content = Base64.decodeStr((CharSequence)subContent.get(i), CharsetUtil.CHARSET_UTF_8);
            subContent.set(i, content);
        }
        FileUtil.del(this.homeConfig.home + "temp");
        String fileTemp = this.homeConfig.home + "temp/nginx.conf";
        this.confService.replace(fileTemp, nginxContent, subContent, subName, false, null);
        String rs = null;
        String cmd = null;
        try {
            cmd = nginxExe + " -t -c " + fileTemp;
            if (StrUtil.isNotEmpty(nginxDir)) {
                cmd = cmd + " -p " + nginxDir;
            }
            rs = RuntimeUtil.execForStr(cmd);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            rs = e.getMessage().replace("\n", "<br>");
        }
        cmd = "<span class='blue'>" + cmd + "</span>";
        if (rs.contains("test is successful")) {
            return this.renderSuccess(cmd + "<br>" + this.m.get("confStr.verifySuccess") + "<br>" + rs.replace("\n", "<br>"));
        }
        return this.renderSuccess(cmd + "<br>" + this.m.get("confStr.verifyFail") + "<br>" + rs.replace("\n", "<br>"));
    }

    @Mapping(value="saveCmd")
    public JsonResult saveCmd(String nginxPath, String nginxExe, String nginxDir) {
        nginxPath = ToolUtils.handlePath(nginxPath);
        nginxExe = ToolUtils.handlePath(nginxExe);
        nginxDir = ToolUtils.handlePath(nginxDir);
        if (StrUtil.isNotEmpty(nginxPath) && !this.isFile(nginxPath)) {
            nginxPath = null;
        }
        if (StrUtil.isNotEmpty(nginxDir) && !this.isFile(nginxDir)) {
            nginxDir = null;
        }
        if (StrUtil.isNotEmpty(nginxExe) && !this.isFile(nginxExe) && !this.isSafeCmd(nginxExe)) {
            nginxExe = null;
        }
        if (StrUtil.isNotEmpty(nginxExe) && this.isFile(nginxExe) && !this.isSafeEnd(nginxExe)) {
            nginxExe = null;
        }
        if (nginxPath != null) {
            this.settingService.set("nginxPath", nginxPath);
        }
        if (nginxExe != null) {
            this.settingService.set("nginxExe", nginxExe);
        }
        if (nginxDir != null) {
            this.settingService.set("nginxDir", nginxDir);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nginxPath", nginxPath);
        map.put("nginxExe", nginxExe);
        map.put("nginxDir", nginxDir);
        return this.renderSuccess(map);
    }

    private boolean isSafeEnd(String nginxExe) {
        return nginxExe.endsWith("nginx") || nginxExe.endsWith("openresty") || nginxExe.endsWith("nginx.exe") || nginxExe.endsWith("openrestys.exe");
    }

    private boolean isSafeCmd(String nginxExe) {
        return nginxExe.equals("nginx") || nginxExe.equals("openresty") || nginxExe.equals("nginx.exe") || nginxExe.equals("openrestys.exe");
    }

    private boolean isFile(String path) {
        return FileUtil.isDirectory(path) || FileUtil.isFile(path);
    }

    @Mapping(value="reload")
    public synchronized JsonResult reload(String nginxPath, String nginxExe, String nginxDir) {
        if (nginxPath == null) {
            nginxPath = ToolUtils.handlePath(this.settingService.get("nginxPath"));
            this.settingService.set("nginxPath", nginxPath);
        }
        if (nginxExe == null) {
            nginxExe = ToolUtils.handlePath(this.settingService.get("nginxExe"));
            this.settingService.set("nginxExe", nginxExe);
        }
        if (nginxDir == null) {
            nginxDir = ToolUtils.handlePath(this.settingService.get("nginxDir"));
            this.settingService.set("nginxDir", nginxDir);
        }
        try {
            String cmd = nginxExe + " -s reload -c " + nginxPath;
            if (StrUtil.isNotEmpty(nginxDir)) {
                cmd = cmd + " -p " + nginxDir;
            }
            String rs = RuntimeUtil.execForStr(cmd);
            cmd = "<span class='blue'>" + cmd + "</span>";
            if (!rs.contains("[error]") && !rs.contains("[emerg]")) {
                return this.renderSuccess(cmd + "<br>" + this.m.get("confStr.reloadSuccess") + "<br>" + rs.replace("\n", "<br>"));
            }
            if (rs.contains("The system cannot find the file specified") || rs.contains("nginx.pid") || rs.contains("PID")) {
                rs = rs + this.m.get("confStr.mayNotRun");
            }
            return this.renderSuccess(cmd + "<br>" + this.m.get("confStr.reloadFail") + "<br>" + rs.replace("\n", "<br>"));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return this.renderSuccess(this.m.get("confStr.reloadFail") + "<br>" + e.getMessage().replace("\n", "<br>"));
        }
    }

    @Mapping(value="runCmd")
    public JsonResult runCmd(String cmd, String type) {
        if (StrUtil.isNotEmpty(type)) {
            this.settingService.set(type, cmd);
        }
        if (StrUtil.isEmpty(cmd = this.buildRealCmd(cmd))) {
            return this.renderSuccess(this.m.get("confStr.notAvailableCmd"));
        }
        try {
            String rs = "";
            if (SystemTool.isWindows().booleanValue()) {
                RuntimeUtil.exec("cmd /c start " + cmd);
            } else {
                rs = RuntimeUtil.execForStr("/bin/sh", "-c", cmd);
            }
            cmd = "<span class='blue'>" + cmd + "</span>";
            if (StrUtil.isEmpty(rs) || rs.contains("\u5df2\u7ec8\u6b62\u8fdb\u7a0b") || rs.contains("signal process started") || rs.toLowerCase().contains("terminated process") || rs.toLowerCase().contains("starting") || rs.toLowerCase().contains("stopping")) {
                return this.renderSuccess(cmd + "<br>" + this.m.get("confStr.runSuccess") + "<br>" + rs.replace("\n", "<br>"));
            }
            return this.renderSuccess(cmd + "<br>" + this.m.get("confStr.runFail") + "<br>" + rs.replace("\n", "<br>"));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return this.renderSuccess(this.m.get("confStr.runFail") + "<br>" + e.getMessage().replace("\n", "<br>"));
        }
    }

    private String buildRealCmd(String cmd) {
        String dir = "";
        if (StrUtil.isNotEmpty(this.settingService.get("nginxDir"))) {
            dir = " -p " + this.settingService.get("nginxDir");
        }
        switch (cmd) {
            case "net start nginx": 
            case "service nginx start": 
            case "systemctl start nginx": 
            case "net stop nginx": 
            case "service nginx stop": 
            case "systemctl stop nginx": 
            case "taskkill /f /im nginx.exe": 
            case "pkill nginx": {
                return cmd;
            }
            case "stopNormal": {
                return this.settingService.get("nginxExe") + " -s stop" + dir;
            }
            case "startNormal": {
                return this.settingService.get("nginxExe") + " -c " + this.settingService.get("nginxPath") + dir;
            }
        }
        if (cmd.trim().equalsIgnoreCase((this.settingService.get("nginxExe") + " -s stop" + dir).trim()) || cmd.trim().equalsIgnoreCase((this.settingService.get("nginxExe") + " -c " + this.settingService.get("nginxPath") + dir).trim())) {
            return cmd;
        }
        return null;
    }

    @Mapping(value="getLastCmd")
    public JsonResult getLastCmd(String type) {
        return this.renderSuccess(this.settingService.get(type));
    }

    @Mapping(value="loadConf")
    public JsonResult loadConf() {
        String decompose = this.settingService.get("decompose");
        ConfExt confExt = this.confService.buildConf(StrUtil.isNotEmpty(decompose) && decompose.equals("true"), false);
        return this.renderSuccess(confExt);
    }

    @Mapping(value="loadOrg")
    public JsonResult loadOrg(String nginxPath) {
        String decompose = this.settingService.get("decompose");
        ConfExt confExt = this.confService.buildConf(StrUtil.isNotEmpty(decompose) && decompose.equals("true"), false);
        if (StrUtil.isNotEmpty(nginxPath) && FileUtil.exist(nginxPath) && FileUtil.isFile(nginxPath)) {
            String orgStr = FileUtil.readString(nginxPath, StandardCharsets.UTF_8);
            confExt.setConf(orgStr);
            for (ConfFile confFile : confExt.getFileList()) {
                confFile.setConf("");
                String filePath = new File(nginxPath).getParent() + "/conf.d/" + confFile.getName();
                if (!FileUtil.exist(filePath)) continue;
                confFile.setConf(FileUtil.readString(filePath, StandardCharsets.UTF_8));
            }
            return this.renderSuccess(confExt);
        }
        if (FileUtil.isDirectory(nginxPath)) {
            return this.renderError(this.m.get("confStr.error2"));
        }
        return this.renderError(this.m.get("confStr.notExist"));
    }

    @Mapping(value="decompose")
    public JsonResult decompose(String decompose) {
        this.settingService.set("decompose", decompose);
        return this.renderSuccess();
    }

    @Mapping(value="update")
    public JsonResult update() {
        this.versionConfig.checkVersion();
        if (Integer.parseInt(this.versionConfig.currentVersion.replace(".", "").replace("v", "")) < Integer.parseInt(this.versionConfig.newVersion.getVersion().replace(".", "").replace("v", ""))) {
            this.mainController.autoUpdate(this.versionConfig.newVersion.getUrl());
            return this.renderSuccess(this.m.get("confStr.updateSuccess"));
        }
        return this.renderSuccess(this.m.get("confStr.noNeedUpdate"));
    }

    @Mapping(value="getKey")
    public JsonResult getKey(String key) {
        return this.renderSuccess(this.settingService.get(key));
    }

    @Mapping(value="setKey")
    public JsonResult setKey(String key, String val) {
        this.settingService.set(key, val);
        return this.renderSuccess();
    }
}

