/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.util.StrUtil;
import com.cym.ext.DenyAllowExt;
import com.cym.model.DenyAllow;
import com.cym.service.DenyAllowService;
import com.cym.service.SettingService;
import com.cym.sqlhelper.bean.Page;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import java.util.ArrayList;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@Mapping(value="/adminPage/denyAllow")
public class DenyAllowController
extends BaseController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    DenyAllowService denyAllowService;
    @Inject
    SettingService settingService;

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView, Page page) {
        this.setPage(page);
        page = this.denyAllowService.search(page);
        ArrayList<DenyAllowExt> exts = new ArrayList<DenyAllowExt>();
        for (DenyAllow denyAllow : page.getRecords()) {
            DenyAllowExt denyAllowExt = new DenyAllowExt();
            denyAllowExt.setDenyAllow(denyAllow);
            if (StrUtil.isBlankIfStr(denyAllow.getIp())) {
                denyAllowExt.setIpCount(0);
            } else {
                denyAllowExt.setIpCount(denyAllow.getIp().split("\n").length);
            }
            exts.add(denyAllowExt);
        }
        page.setRecords(exts);
        modelAndView.put("page", page);
        modelAndView.view("/adminPage/denyAllow/index.html");
        return modelAndView;
    }

    @Mapping(value="addOver")
    public JsonResult addOver(DenyAllow denyAllow) {
        this.denyAllowService.removeSame(denyAllow);
        this.sqlHelper.insertOrUpdate(denyAllow);
        return this.renderSuccess();
    }

    @Mapping(value="detail")
    public JsonResult detail(String id) {
        return this.renderSuccess(this.sqlHelper.findById(id, DenyAllow.class));
    }

    @Mapping(value="del")
    public JsonResult del(String id) {
        String[] ids = id.split(",");
        this.sqlHelper.deleteByIds(ids, DenyAllow.class);
        return this.renderSuccess();
    }
}

